/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.util.Rnd;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NpcPersonalAIData {
    private final Map<String, Map<String, Integer>> _AIData = new HashMap<String, Map<String, Integer>>();

    protected NpcPersonalAIData() {
    }

    public void storeData(L2Spawn spawnDat, Map<String, Integer> data) {
        if (data != null && !data.isEmpty()) {
            if (spawnDat.getName() == null) {
                spawnDat.setName(Long.toString(Rnd.nextLong()));
            }
            this._AIData.put(spawnDat.getName(), data);
        }
    }

    public int getAIValue(String spawnName, String paramName) {
        return this.hasAIValue(spawnName, paramName) ? this._AIData.get(spawnName).get(paramName) : -1;
    }

    public boolean hasAIValue(String spawnName, String paramName) {
        return spawnName != null && this._AIData.containsKey(spawnName) && this._AIData.get(spawnName).containsKey(paramName);
    }

    public void initializeNpcParameters(L2Npc npc, L2Spawn spawn, String spawnName) {
        if (this._AIData.containsKey(spawnName)) {
            Map<String, Integer> map = this._AIData.get(spawnName);
            try {
                Iterator<String> i$ = map.keySet().iterator();
                while (i$.hasNext()) {
                    String key;
                    switch (key = i$.next()) {
                        case "disableRandomAnimation": {
                            npc.setRandomAnimationEnabled(map.get(key) == 0);
                            break;
                        }
                        case "disableRandomWalk": {
                            npc.setIsNoRndWalk(map.get(key) == 1);
                            spawn.setIsNoRndWalk(map.get(key) == 1);
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static NpcPersonalAIData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final NpcPersonalAIData _instance = new NpcPersonalAIData();

        private SingletonHolder() {
        }
    }
}

