/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.SkillLearnData;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.StringIntern;
import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.L2DropData;
import com.l2jserver.gameserver.model.L2MinionData;
import com.l2jserver.gameserver.model.L2NpcAIData;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.items.type.L2WeaponType;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.stats.MoveType;
import com.l2jserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NpcTable
extends DocumentParser {
    private static final Logger _log = Logger.getLogger(NpcTable.class.getName());
    private static final Map<Integer, L2NpcTemplate> _npcs = new HashMap<Integer, L2NpcTemplate>();
    private static final String SELECT_NPC_ALL = "SELECT * FROM npc ORDER BY id";
    private static final String SELECT_NPC_BY_ID = "SELECT * FROM npc WHERE id = ?";
    private static final String SELECT_SKILLS_ALL = "SELECT * FROM npcskills ORDER BY npcid";
    private static final String SELECT_SKILLS_BY_ID = "SELECT * FROM npcskills WHERE npcid = ?";
    private static final String SELECT_DROPLIST_ALL = "SELECT * FROM droplist ORDER BY mobId, category, chance";
    private static final String SELECT_DROPLIST_BY_ID = "SELECT * FROM droplist WHERE mobId = ? ORDER BY mobId, category, chance";
    private static final String SELECT_NPC_AI_ALL = "SELECT * FROM npcaidata ORDER BY npcId";
    private static final String SELECT_NPC_AI_BY_ID = "SELECT * FROM npcaidata WHERE npcId = ?";
    private static final String SELECT_NPC_ELEMENTALS_ALL = "SELECT * FROM npc_elementals ORDER BY npc_id";
    private static final String SELECT_NPC_ELEMENTALS_BY_ID = "SELECT * FROM npc_elementals WHERE npc_id = ?";
    private static final String SELECT_MINION_ALL = "SELECT * FROM minions ORDER BY boss_id";
    private static final String SELECT_MINION_BY_ID = "SELECT * FROM minions WHERE boss_id = ?";
    private static final String CUSTOM_SELECT_NPC_ALL = "SELECT * FROM custom_npc ORDER BY id";
    private static final String CUSTOM_SELECT_NPC_BY_ID = "SELECT * FROM custom_npc WHERE id = ?";
    private static final String CUSTOM_SELECT_SKILLS_ALL = "SELECT * FROM custom_npcskills ORDER BY npcid";
    private static final String CUSTOM_SELECT_SKILLS_BY_ID = "SELECT * FROM custom_npcskills WHERE npcid = ?";
    private static final String CUSTOM_SELECT_DROPLIST_ALL = "SELECT * FROM custom_droplist ORDER BY mobId, category, chance";
    private static final String CUSTOM_SELECT_DROPLIST_BY_ID = "SELECT * FROM custom_droplist WHERE mobId = ? ORDER BY mobId, category, chance";
    private static final String CUSTOM_SELECT_NPC_AI_ALL = "SELECT * FROM custom_npcaidata ORDER BY npcId";
    private static final String CUSTOM_SELECT_NPC_AI_BY_ID = "SELECT * FROM custom_npcaidata WHERE npcId = ?";
    private static final String CUSTOM_SELECT_NPC_ELEMENTALS_ALL = "SELECT * FROM custom_npc_elementals ORDER BY npc_id";
    private static final String CUSTOM_SELECT_NPC_ELEMENTALS_BY_ID = "SELECT * FROM custom_npc_elementals WHERE npc_id = ?";

    protected NpcTable() {
        _npcs.clear();
        this.restoreNpcData();
        this.load();
    }

    @Override
    public synchronized void load() {
        this.parseDatapackDirectory("data/stats/npcs", false);
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equals(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                NamedNodeMap attrs;
                int id;
                if (!"npc".equals(d.getNodeName()) || !_npcs.containsKey(id = this.parseInteger(attrs = d.getAttributes(), "id").intValue())) continue;
                L2NpcTemplate template = _npcs.get(id);
                block26: for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
                    if (c.getNodeName() == null || c.getNodeName().startsWith("#")) continue;
                    attrs = c.getAttributes();
                    switch (c.getNodeName()) {
                        case "base_attack": {
                            String type = this.parseString(attrs, "type");
                            int range = this.parseInteger(attrs, "range");
                            L2WeaponType weaponType = L2WeaponType.findByName(type);
                            template.setBaseAttackType(weaponType);
                            template.setBaseAttackRange(range);
                            continue block26;
                        }
                        case "base_attribute": {
                            Node b;
                            for (b = c.getFirstChild(); b != null; b = b.getNextSibling()) {
                                attrs = b.getAttributes();
                                if ("attack".equals(b.getNodeName())) {
                                    template.setBaseFire(this.parseInteger(attrs, "fire"));
                                    template.setBaseWater(this.parseInteger(attrs, "water"));
                                    template.setBaseEarth(this.parseInteger(attrs, "earth"));
                                    template.setBaseWind(this.parseInteger(attrs, "wind"));
                                    template.setBaseHoly(this.parseInteger(attrs, "holy"));
                                    template.setBaseDark(this.parseInteger(attrs, "dark"));
                                    continue;
                                }
                                if (!"defend".equals(b.getNodeName())) continue;
                                template.setBaseFireRes(this.parseInteger(attrs, "fire").intValue());
                                template.setBaseWaterRes(this.parseInteger(attrs, "water").intValue());
                                template.setBaseEarthRes(this.parseInteger(attrs, "earth").intValue());
                                template.setBaseWindRes(this.parseInteger(attrs, "wind").intValue());
                                template.setBaseHolyRes(this.parseInteger(attrs, "holy").intValue());
                                template.setBaseDarkRes(this.parseInteger(attrs, "dark").intValue());
                                template.setBaseElementRes(this.parseInteger(attrs, "unknown").intValue());
                            }
                            continue block26;
                        }
                        case "npc_ai": {
                            StatsSet set = new StatsSet();
                            block28: for (Node b = c.getFirstChild(); b != null; b = b.getNextSibling()) {
                                attrs = b.getAttributes();
                                switch (b.getNodeName()) {
                                    case "ai_param": {
                                        set.set(this.parseString(attrs, "name"), this.parseString(attrs, "val"));
                                        continue block28;
                                    }
                                    case "ai_skill": {
                                        set.set(this.parseString(attrs, "name"), new SkillHolder(this.parseInteger(attrs, "id"), this.parseInteger(attrs, "level")));
                                        continue block28;
                                    }
                                    case "ai_item": {
                                        set.set(this.parseString(attrs, "name"), new ItemHolder(this.parseInteger(attrs, "id"), 1L));
                                        continue block28;
                                    }
                                    case "ai": {
                                        set.set(b.getNodeName(), b.getTextContent());
                                    }
                                }
                            }
                            template.setParameters(set);
                            continue block26;
                        }
                        case "speed": {
                            Node b;
                            for (b = c.getFirstChild(); b != null; b = b.getNextSibling()) {
                                attrs = b.getAttributes();
                                if ("run".equals(b.getNodeName())) {
                                    template.setBaseMoveSpeed(MoveType.RUN, this.parseFloat(attrs, "ground").floatValue());
                                    template.setBaseMoveSpeed(MoveType.FAST_SWIM, this.parseFloat(attrs, "underWater").floatValue());
                                    template.setBaseMoveSpeed(MoveType.FAST_FLY, this.parseFloat(attrs, "flying").floatValue());
                                    continue;
                                }
                                if (!"walk".equals(b.getNodeName())) continue;
                                template.setBaseMoveSpeed(MoveType.WALK, this.parseFloat(attrs, "ground").floatValue());
                                template.setBaseMoveSpeed(MoveType.SLOW_SWIM, this.parseFloat(attrs, "underWater").floatValue());
                                template.setBaseMoveSpeed(MoveType.SLOW_FLY, this.parseFloat(attrs, "flying").floatValue());
                            }
                            continue block26;
                        }
                    }
                }
            }
        }
    }

    private void restoreNpcData() {
        this.loadNpcs(0);
        this.loadNpcsSkills(0);
        this.loadNpcsDrop(0);
        this.loadNpcsSkillLearn(0);
        this.loadMinions(0);
        this.loadNpcsAI(0);
        this.loadNpcsElement(0);
    }

    private void fillNpcTable(ResultSet NpcData) throws Exception {
        StatsSet npcDat = new StatsSet();
        int id = NpcData.getInt("id");
        int idTemp = NpcData.getInt("idTemplate");
        assert (idTemp < 1000000);
        npcDat.set("npcId", id);
        npcDat.set("idTemplate", idTemp);
        int level = NpcData.getInt("level");
        npcDat.set("level", level);
        npcDat.set("client_class", NpcData.getString("class"));
        npcDat.set("baseShldDef", 0);
        npcDat.set("baseShldRate", 0);
        npcDat.set("baseCritRate", NpcData.getInt("critical"));
        npcDat.set("name", NpcData.getString("name"));
        npcDat.set("serverSideName", NpcData.getBoolean("serverSideName"));
        npcDat.set("title", NpcData.getString("title"));
        npcDat.set("serverSideTitle", NpcData.getBoolean("serverSideTitle"));
        npcDat.set("collision_radius", NpcData.getDouble("collision_radius"));
        npcDat.set("collision_height", NpcData.getDouble("collision_height"));
        npcDat.set("sex", NpcData.getString("sex"));
        npcDat.set("type", NpcData.getString("type"));
        npcDat.set("baseAtkRange", NpcData.getInt("attackrange"));
        npcDat.set("rewardExp", NpcData.getInt("exp"));
        npcDat.set("rewardSp", NpcData.getInt("sp"));
        npcDat.set("basePAtkSpd", NpcData.getInt("atkspd"));
        npcDat.set("baseMAtkSpd", NpcData.getInt("matkspd"));
        npcDat.set("rhand", NpcData.getInt("rhand"));
        npcDat.set("lhand", NpcData.getInt("lhand"));
        npcDat.set("enchant", NpcData.getInt("enchant"));
        npcDat.set("baseWalkSpd", NpcData.getInt("walkspd"));
        npcDat.set("baseRunSpd", NpcData.getInt("runspd"));
        npcDat.safeSet("baseSTR", NpcData.getInt("str"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
        npcDat.safeSet("baseCON", NpcData.getInt("con"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
        npcDat.safeSet("baseDEX", NpcData.getInt("dex"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
        npcDat.safeSet("baseINT", NpcData.getInt("int"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
        npcDat.safeSet("baseWIT", NpcData.getInt("wit"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
        npcDat.safeSet("baseMEN", NpcData.getInt("men"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
        npcDat.set("baseHpMax", NpcData.getDouble("hp"));
        npcDat.set("baseCpMax", 0);
        npcDat.set("baseMpMax", NpcData.getDouble("mp"));
        npcDat.set("baseHpReg", NpcData.getFloat("hpreg") > 0.0f ? (double)NpcData.getFloat("hpreg") : 1.5 + (double)(level - 1) / 10.0);
        npcDat.set("baseMpReg", NpcData.getFloat("mpreg") > 0.0f ? (double)NpcData.getFloat("mpreg") : 0.9 + 0.3 * ((double)(level - 1) / 10.0));
        npcDat.set("basePAtk", NpcData.getInt("patk"));
        npcDat.set("basePDef", NpcData.getInt("pdef"));
        npcDat.set("baseMAtk", NpcData.getInt("matk"));
        npcDat.set("baseMDef", NpcData.getInt("mdef"));
        npcDat.set("dropHerbGroup", NpcData.getInt("dropHerbGroup"));
        npcDat.set("baseFireRes", 20);
        npcDat.set("baseWindRes", 20);
        npcDat.set("baseWaterRes", 20);
        npcDat.set("baseEarthRes", 20);
        npcDat.set("baseHolyRes", 20);
        npcDat.set("baseDarkRes", 20);
        L2NpcTemplate template = this.getTemplate(id);
        if (template == null) {
            _npcs.put(id, new L2NpcTemplate(npcDat));
        } else {
            template.set(npcDat);
        }
    }

    public void reloadNpc(int id, boolean base, boolean ai, boolean element, boolean skills, boolean drops, boolean minions) {
        try {
            if (base) {
                this.loadNpcs(id);
            }
            if (ai) {
                this.loadNpcsAI(id);
            }
            if (element) {
                this.loadNpcsElement(id);
            }
            if (skills) {
                this.loadNpcsSkills(id);
                this.loadNpcsSkillLearn(id);
            }
            if (drops) {
                this.loadNpcsDrop(id);
            }
            if (minions) {
                this.loadMinions(id);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Could not reload data for NPC " + id + ": " + e.getMessage(), e);
        }
    }

    public void reloadAllNpc() {
        this.restoreNpcData();
    }

    public void saveNpc(StatsSet npc) {
        int npcId = npc.getInt("npcId");
        StringBuilder npcAttributes = new StringBuilder(256);
        ArrayList<Object> npcAttributeValues = new ArrayList<Object>();
        StringBuilder npcaidataAttributes = new StringBuilder(256);
        ArrayList<Object> npcaidataAttributeValues = new ArrayList<Object>();
        StringBuilder npcElementAttributes = new StringBuilder(256);
        ArrayList<Object> npcElementAttributeValues = new ArrayList<Object>();
        block86: for (Map.Entry<String, Object> entry : npc.getSet().entrySet()) {
            switch (entry.getKey()) {
                case "npcId": {
                    continue block86;
                }
                case "serverSideName": 
                case "serverSideTitle": 
                case "sex": 
                case "enchant": 
                case "level": 
                case "str": 
                case "con": 
                case "dex": 
                case "int": 
                case "wit": 
                case "men": 
                case "critical": 
                case "dropHerbGroup": 
                case "atkspd": 
                case "matkspd": 
                case "attackrange": 
                case "rhand": 
                case "lhand": 
                case "idTemplate": 
                case "exp": 
                case "sp": 
                case "collision_radius": 
                case "collision_height": 
                case "walkspd": 
                case "runspd": 
                case "patk": 
                case "pdef": 
                case "matk": 
                case "mdef": 
                case "hp": 
                case "mp": 
                case "hpreg": 
                case "mpreg": 
                case "type": 
                case "title": 
                case "name": {
                    this.appendEntry(npcAttributes, entry.getKey());
                    npcAttributeValues.add(entry.getValue());
                    continue block86;
                }
                case "canMove": 
                case "targetable": 
                case "showName": 
                case "isChaos": 
                case "dodge": 
                case "minSkillChance": 
                case "maxSkillChance": 
                case "minRangeChance": 
                case "maxRangeChance": 
                case "ssChance": 
                case "spsChance": 
                case "aggro": 
                case "clanRange": 
                case "enemyRange": 
                case "primarySkillId": 
                case "minRangeSkill": 
                case "maxRangeSkill": 
                case "soulShot": 
                case "spiritShot": 
                case "clan": 
                case "enemyClan": 
                case "aiType": {
                    this.appendEntry(npcaidataAttributes, entry.getKey());
                    npcaidataAttributeValues.add(entry.getValue());
                    continue block86;
                }
                case "elemAtkType": 
                case "elemAtkValue": 
                case "fireDefValue": 
                case "waterDefValue": 
                case "windDefValue": 
                case "earthDefValue": 
                case "holyDefValue": 
                case "darkDefValue": {
                    this.appendEntry(npcElementAttributes, entry.getKey());
                    npcElementAttributeValues.add(entry.getValue());
                    continue block86;
                }
            }
            _log.warning("Unknown stat " + entry.getKey() + " can't set.");
            return;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            int updated = 0;
            if (Config.CUSTOM_NPC_TABLE) {
                updated += this.performUpdate(npcAttributes, "custom_npc", "id", npcAttributeValues, npcId, con);
                updated += this.performUpdate(npcaidataAttributes, "custom_npcaidata", "npcId", npcaidataAttributeValues, npcId, con);
                updated += this.performUpdate(npcElementAttributes, "custom_npc_elementals", "npc_id", npcElementAttributeValues, npcId, con);
            }
            if (updated == 0) {
                updated += this.performUpdate(npcAttributes, "npc", "id", npcAttributeValues, npcId, con);
                updated += this.performUpdate(npcaidataAttributes, "npcaidata", "npcId", npcaidataAttributeValues, npcId, con);
                updated += this.performUpdate(npcElementAttributes, "npc_elementals", "npc_id", npcElementAttributeValues, npcId, con);
            }
            if (updated > 0) {
                this.reloadNpc(npcId, !npcAttributeValues.isEmpty(), !npcaidataAttributeValues.isEmpty(), !npcElementAttributeValues.isEmpty(), false, false, false);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Could not store new NPC data in database: " + e.getMessage(), e);
        }
    }

    private final void appendEntry(StringBuilder sb, String attribute) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append('`');
        sb.append(attribute);
        sb.append("` = ?");
    }

    private final int performUpdate(StringBuilder sb, String table, String key, Collection<Object> values, int npcId, Connection con) throws SQLException {
        int updated = 0;
        if (sb != null && !sb.toString().isEmpty()) {
            StringBuilder sbQuery = new StringBuilder(sb.length() + 28);
            sbQuery.append("UPDATE ");
            sbQuery.append(table);
            sbQuery.append(" SET ");
            sbQuery.append(sb.toString());
            sbQuery.append(" WHERE ");
            sbQuery.append(key);
            sbQuery.append(" = ?");
            try (PreparedStatement ps = con.prepareStatement(sbQuery.toString());){
                int i = 1;
                for (Object value : values) {
                    ps.setObject(i, value);
                    ++i;
                }
                ps.setInt(i, npcId);
                updated = ps.executeUpdate();
            }
        }
        return updated;
    }

    public L2NpcTemplate getTemplate(int id) {
        return _npcs.get(id);
    }

    public L2NpcTemplate getTemplateByName(String name) {
        for (L2NpcTemplate npcTemplate : _npcs.values()) {
            if (!npcTemplate.getName().equalsIgnoreCase(name)) continue;
            return npcTemplate;
        }
        return null;
    }

    public List<L2NpcTemplate> getAllOfLevel(int lvl) {
        FastList list = new FastList();
        for (L2NpcTemplate t : _npcs.values()) {
            if (t.getLevel() != lvl) continue;
            list.add(t);
        }
        return list;
    }

    public List<L2NpcTemplate> getAllOfLevel(int ... lvls) {
        ArrayList<L2NpcTemplate> list = new ArrayList<L2NpcTemplate>();
        for (int lvl : lvls) {
            for (L2NpcTemplate t : _npcs.values()) {
                if (t.getLevel() != lvl) continue;
                list.add(t);
            }
        }
        return list;
    }

    public List<L2NpcTemplate> getAllMonstersOfLevel(int lvl) {
        FastList list = new FastList();
        for (L2NpcTemplate t : _npcs.values()) {
            if (t.getLevel() != lvl || !t.isType("L2Monster")) continue;
            list.add(t);
        }
        return list;
    }

    public List<L2NpcTemplate> getAllMonstersOfLevel(int ... lvls) {
        ArrayList<L2NpcTemplate> list = new ArrayList<L2NpcTemplate>();
        for (int lvl : lvls) {
            for (L2NpcTemplate t : _npcs.values()) {
                if (t.getLevel() != lvl || !t.isType("L2Monster")) continue;
                list.add(t);
            }
        }
        return list;
    }

    public List<L2NpcTemplate> getAllNpcStartingWith(String letter) {
        FastList list = new FastList();
        for (L2NpcTemplate t : _npcs.values()) {
            if (!t.getName().startsWith(letter) || !t.isType("L2Npc")) continue;
            list.add(t);
        }
        return list;
    }

    public List<L2NpcTemplate> getAllNpcStartingWith(String ... letters) {
        ArrayList<L2NpcTemplate> list = new ArrayList<L2NpcTemplate>();
        for (String letter : letters) {
            for (L2NpcTemplate t : _npcs.values()) {
                if (!t.getName().startsWith(letter) || !t.isType("L2Npc")) continue;
                list.add(t);
            }
        }
        return list;
    }

    public List<L2NpcTemplate> getAllNpcOfClassType(String classType) {
        FastList list = new FastList();
        for (L2NpcTemplate t : _npcs.values()) {
            if (!t.isType(classType)) continue;
            list.add(t);
        }
        return list;
    }

    public List<L2NpcTemplate> getAllNpcOfClassType(String ... classTypes) {
        ArrayList<L2NpcTemplate> list = new ArrayList<L2NpcTemplate>();
        for (String classType : classTypes) {
            for (L2NpcTemplate t : _npcs.values()) {
                if (!t.isType(classType)) continue;
                list.add(t);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNpcs(int id) {
        long started = System.currentTimeMillis();
        StringIntern.begin(NpcTable.class.getSimpleName());
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            int count = this.loadNpcs(con, id, false);
            int ccount = 0;
            if (Config.CUSTOM_NPC_TABLE) {
                ccount = this.loadNpcs(con, id, true);
            }
            if (id == 0) {
                _log.info(this.getClass().getSimpleName() + ": Loaded " + count + " (Custom: " + ccount + ") NPC template(s). (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error reading NPC AI Data: " + e.getMessage(), e);
        }
        finally {
            StringIntern.end();
        }
    }

    public int loadNpcs(Connection con, int id, boolean isCustom) {
        int count = 0;
        try {
            String query = isCustom ? (id > 0 ? CUSTOM_SELECT_NPC_BY_ID : CUSTOM_SELECT_NPC_ALL) : (id > 0 ? SELECT_NPC_BY_ID : SELECT_NPC_ALL);
            try (PreparedStatement ps = con.prepareStatement(query);){
                if (id > 0) {
                    ps.setInt(1, id);
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        this.fillNpcTable(rs);
                        ++count;
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error creating NPC table.", e);
        }
        return count;
    }

    public void loadNpcsSkills(int id) {
        long started = System.currentTimeMillis();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            int count = this.loadNpcsSkills(con, id, false);
            int ccount = 0;
            if (Config.CUSTOM_NPC_SKILLS_TABLE) {
                ccount = this.loadNpcsSkills(con, id, true);
            }
            if (id == 0) {
                _log.info(this.getClass().getSimpleName() + ": Loaded " + count + " (Custom: " + ccount + ") NPC skills. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error reading NPC AI Data: " + e.getMessage(), e);
        }
    }

    private int loadNpcsSkills(Connection con, int id, boolean isCustom) {
        int count = 0;
        String query = isCustom ? (id > 0 ? CUSTOM_SELECT_SKILLS_BY_ID : CUSTOM_SELECT_SKILLS_ALL) : (id > 0 ? SELECT_SKILLS_BY_ID : SELECT_SKILLS_ALL);
        try (PreparedStatement ps = con.prepareStatement(query);){
            if (id > 0) {
                L2NpcTemplate template;
                ps.setInt(1, id);
                if (!isCustom && (template = this.getTemplate(id)) != null) {
                    template.resetSkills();
                }
            } else if (!isCustom) {
                for (L2NpcTemplate template : _npcs.values()) {
                    template.resetSkills();
                }
            }
            try (ResultSet rs = ps.executeQuery();){
                L2NpcTemplate npcDat = null;
                L2Skill npcSkill = null;
                while (rs.next()) {
                    int mobId = rs.getInt("npcid");
                    npcDat = _npcs.get(mobId);
                    if (npcDat == null) {
                        _log.warning(this.getClass().getSimpleName() + ": Skill data for undefined NPC. npcId: " + mobId);
                        continue;
                    }
                    int skillId = rs.getInt("skillid");
                    int level = rs.getInt("level");
                    if (skillId == 4416) {
                        npcDat.setRace(level);
                    }
                    if ((npcSkill = SkillTable.getInstance().getInfo(skillId, level)) == null) continue;
                    ++count;
                    npcDat.addSkill(npcSkill);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error reading NPC skills table.", e);
        }
        return count;
    }

    public void loadNpcsDrop(int id) {
        long started = System.currentTimeMillis();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            int count = this.loadNpcsDrop(con, id, false);
            int ccount = 0;
            if (Config.CUSTOM_DROPLIST_TABLE) {
                ccount = this.loadNpcsDrop(con, id, true);
            }
            if (id == 0) {
                _log.info(this.getClass().getSimpleName() + ": Loaded " + count + " (Custom: " + ccount + ") drops. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error reading NPC AI Data: " + e.getMessage(), e);
        }
    }

    public void loadNpcsSkillLearn(int id) {
        if (id > 0) {
            List<ClassId> teachInfo = SkillLearnData.getInstance().getSkillLearnData(id);
            L2NpcTemplate template = _npcs.get(id);
            if (teachInfo != null && template != null) {
                template.setTeachInfo(teachInfo);
            }
        } else {
            for (L2NpcTemplate template : _npcs.values()) {
                List<ClassId> teachInfo = SkillLearnData.getInstance().getSkillLearnData(template.getId());
                if (teachInfo == null) continue;
                template.setTeachInfo(teachInfo);
            }
        }
    }

    public int loadNpcsDrop(Connection con, int id, boolean isCustom) {
        int count = 0;
        String query = isCustom ? (id > 0 ? CUSTOM_SELECT_DROPLIST_BY_ID : CUSTOM_SELECT_DROPLIST_ALL) : (id > 0 ? SELECT_DROPLIST_BY_ID : SELECT_DROPLIST_ALL);
        try (PreparedStatement ps = con.prepareStatement(query);){
            if (id > 0) {
                L2NpcTemplate template;
                ps.setInt(1, id);
                if (!isCustom && (template = this.getTemplate(id)) != null) {
                    template.resetDroplist();
                }
            } else if (!isCustom) {
                for (L2NpcTemplate template : _npcs.values()) {
                    template.resetDroplist();
                }
            }
            try (ResultSet rs = ps.executeQuery();){
                L2DropData dropDat = null;
                L2NpcTemplate npcDat = null;
                while (rs.next()) {
                    int mobId = rs.getInt("mobId");
                    npcDat = _npcs.get(mobId);
                    if (npcDat == null) {
                        _log.warning(this.getClass().getSimpleName() + ": Drop data for undefined NPC. npcId: " + mobId);
                        continue;
                    }
                    dropDat = new L2DropData();
                    dropDat.setItemId(rs.getInt("itemId"));
                    dropDat.setMinDrop(rs.getInt("min"));
                    dropDat.setMaxDrop(rs.getInt("max"));
                    dropDat.setChance(rs.getInt("chance"));
                    int category = rs.getInt("category");
                    if (ItemTable.getInstance().getTemplate(dropDat.getItemId()) == null) {
                        _log.warning(this.getClass().getSimpleName() + ": Drop data for undefined item template! NpcId: " + mobId + " itemId: " + dropDat.getItemId());
                        continue;
                    }
                    ++count;
                    npcDat.addDropData(dropDat, category);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error reading NPC dropdata. ", e);
        }
        return count;
    }

    public void loadMinions(int id) {
        long started = System.currentTimeMillis();
        String query = id > 0 ? SELECT_MINION_BY_ID : SELECT_MINION_ALL;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(query);){
            if (id > 0) {
                statement.setInt(1, id);
            }
            int count = 0;
            try (ResultSet rset = statement.executeQuery();){
                L2MinionData minionDat = null;
                L2NpcTemplate npcDat = null;
                while (rset.next()) {
                    int raidId = rset.getInt("boss_id");
                    npcDat = _npcs.get(raidId);
                    if (npcDat == null) {
                        _log.warning(this.getClass().getSimpleName() + ": Minion references undefined boss NPC. Boss NpcId: " + raidId);
                        continue;
                    }
                    minionDat = new L2MinionData();
                    minionDat.setMinionId(rset.getInt("minion_id"));
                    minionDat.setAmountMin(rset.getInt("amount_min"));
                    minionDat.setAmountMax(rset.getInt("amount_max"));
                    npcDat.addMinionData(minionDat);
                    ++count;
                }
            }
            if (id == 0) {
                _log.info(this.getClass().getSimpleName() + ": Loaded " + count + " Minions. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error loading minion data.", e);
        }
    }

    public void loadNpcsAI(int id) {
        long started = System.currentTimeMillis();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            int count = this.loadNpcAi(con, id, false);
            int ccount = 0;
            if (Config.CUSTOM_NPC_TABLE) {
                ccount = this.loadNpcAi(con, id, true);
            }
            if (id == 0) {
                _log.info(this.getClass().getSimpleName() + ": Loaded " + count + " (Custom: " + ccount + ") AI Data. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error reading NPC AI Data: " + e.getMessage(), e);
        }
    }

    private int loadNpcAi(Connection con, int id, boolean isCustom) {
        int count = 0;
        String query = isCustom ? (id > 0 ? CUSTOM_SELECT_NPC_AI_BY_ID : CUSTOM_SELECT_NPC_AI_ALL) : (id > 0 ? SELECT_NPC_AI_BY_ID : SELECT_NPC_AI_ALL);
        try (PreparedStatement ps = con.prepareStatement(query);){
            if (id > 0) {
                ps.setInt(1, id);
            }
            try (ResultSet rs = ps.executeQuery();){
                L2NpcAIData npcAIDat = null;
                L2NpcTemplate npcDat = null;
                while (rs.next()) {
                    int npcId = rs.getInt("npcId");
                    npcDat = _npcs.get(npcId);
                    if (npcDat == null) {
                        _log.severe(this.getClass().getSimpleName() + ": AI Data Error with id : " + npcId);
                        continue;
                    }
                    npcAIDat = new L2NpcAIData();
                    npcAIDat.setPrimarySkillId(rs.getInt("primarySkillId"));
                    npcAIDat.setMinSkillChance(rs.getInt("minSkillChance"));
                    npcAIDat.setMaxSkillChance(rs.getInt("maxSkillChance"));
                    npcAIDat.setAggro(rs.getInt("aggro"));
                    npcAIDat.setCanMove(rs.getInt("canMove"));
                    npcAIDat.setShowName(rs.getInt("showName") == 1);
                    npcAIDat.setTargetable(rs.getInt("targetable") == 1);
                    npcAIDat.setSoulShot(rs.getInt("soulshot"));
                    npcAIDat.setSpiritShot(rs.getInt("spiritshot"));
                    npcAIDat.setSoulShotChance(rs.getInt("ssChance"));
                    npcAIDat.setSpiritShotChance(rs.getInt("spsChance"));
                    npcAIDat.setIsChaos(rs.getInt("isChaos"));
                    npcAIDat.setShortRangeSkill(rs.getInt("minRangeSkill"));
                    npcAIDat.setShortRangeChance(rs.getInt("minRangeChance"));
                    npcAIDat.setLongRangeSkill(rs.getInt("maxRangeSkill"));
                    npcAIDat.setLongRangeChance(rs.getInt("maxRangeChance"));
                    npcAIDat.setClan(rs.getString("clan"));
                    npcAIDat.setClanRange(rs.getInt("clanRange"));
                    npcAIDat.setEnemyClan(rs.getString("enemyClan"));
                    npcAIDat.setEnemyRange(rs.getInt("enemyRange"));
                    npcAIDat.setDodge(rs.getInt("dodge"));
                    npcAIDat.setAi(rs.getString("aiType"));
                    npcDat.setAIData(npcAIDat);
                    ++count;
                }
            }
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error reading NPC AI Data: " + e.getMessage(), e);
        }
        return count;
    }

    public void loadNpcsElement(int id) {
        long started = System.currentTimeMillis();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            int count = this.loadNpcsElement(con, id, false);
            int ccount = 0;
            if (Config.CUSTOM_NPC_TABLE) {
                ccount = this.loadNpcsElement(con, id, true);
            }
            if (id == 0) {
                _log.info(this.getClass().getSimpleName() + ": Loaded " + count + " (Custom: " + ccount + ") Elementals Data. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error reading NPC AI Data: " + e.getMessage(), e);
        }
    }

    private int loadNpcsElement(Connection con, int id, boolean isCustom) {
        int count = 0;
        String query = isCustom ? (id > 0 ? CUSTOM_SELECT_NPC_ELEMENTALS_BY_ID : CUSTOM_SELECT_NPC_ELEMENTALS_ALL) : (id > 0 ? SELECT_NPC_ELEMENTALS_BY_ID : SELECT_NPC_ELEMENTALS_ALL);
        try (PreparedStatement ps = con.prepareStatement(query);){
            if (id > 0) {
                ps.setInt(1, id);
            }
            try (ResultSet rset = ps.executeQuery();){
                L2NpcTemplate npcDat = null;
                block28: while (rset.next()) {
                    int npcId = rset.getInt("npc_id");
                    npcDat = _npcs.get(npcId);
                    if (npcDat == null) {
                        _log.severe("NPCElementals: Elementals Error with id : " + npcId);
                        continue;
                    }
                    switch (rset.getByte("elemAtkType")) {
                        case 0: {
                            npcDat.setBaseFire(rset.getInt("elemAtkValue"));
                            break;
                        }
                        case 1: {
                            npcDat.setBaseWater(rset.getInt("elemAtkValue"));
                            break;
                        }
                        case 3: {
                            npcDat.setBaseEarth(rset.getInt("elemAtkValue"));
                            break;
                        }
                        case 2: {
                            npcDat.setBaseWind(rset.getInt("elemAtkValue"));
                            break;
                        }
                        case 4: {
                            npcDat.setBaseHoly(rset.getInt("elemAtkValue"));
                            break;
                        }
                        case 5: {
                            npcDat.setBaseDark(rset.getInt("elemAtkValue"));
                            break;
                        }
                        default: {
                            _log.severe("NPCElementals: Elementals Error with id : " + npcId + "; unknown elementType: " + rset.getByte("elemAtkType"));
                            continue block28;
                        }
                    }
                    npcDat.setBaseFireRes(rset.getInt("fireDefValue"));
                    npcDat.setBaseWaterRes(rset.getInt("waterDefValue"));
                    npcDat.setBaseEarthRes(rset.getInt("earthDefValue"));
                    npcDat.setBaseWindRes(rset.getInt("windDefValue"));
                    npcDat.setBaseHolyRes(rset.getInt("holyDefValue"));
                    npcDat.setBaseDarkRes(rset.getInt("darkDefValue"));
                    ++count;
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error reading NPC Elementals Data: " + e.getMessage(), e);
        }
        return count;
    }

    public static NpcTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final NpcTable _instance = new NpcTable();

        private SingletonHolder() {
        }
    }
}

