/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.w3c.dom.Node;

public class SecondaryAuthData
extends DocumentParser {
    private boolean _enabled = false;
    private int _maxAttempts = 5;
    private int _banTime = 480;
    private String _recoveryLink = "";
    private final Set<String> _forbiddenPasswords = new HashSet<String>();

    protected SecondaryAuthData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        this._forbiddenPasswords.clear();
        this.parseFile(new File("config/SecondaryAuth.xml"));
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + this._forbiddenPasswords.size() + " forbidden passwords.");
    }

    @Override
    protected void parseDocument() {
        try {
            for (Node node = this.getCurrentDocument().getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"list".equalsIgnoreCase(node.getNodeName())) continue;
                for (Node list_node = node.getFirstChild(); list_node != null; list_node = list_node.getNextSibling()) {
                    if ("enabled".equalsIgnoreCase(list_node.getNodeName())) {
                        this._enabled = Boolean.parseBoolean(list_node.getTextContent());
                        continue;
                    }
                    if ("maxAttempts".equalsIgnoreCase(list_node.getNodeName())) {
                        this._maxAttempts = Integer.parseInt(list_node.getTextContent());
                        continue;
                    }
                    if ("banTime".equalsIgnoreCase(list_node.getNodeName())) {
                        this._banTime = Integer.parseInt(list_node.getTextContent());
                        continue;
                    }
                    if ("recoveryLink".equalsIgnoreCase(list_node.getNodeName())) {
                        this._recoveryLink = list_node.getTextContent();
                        continue;
                    }
                    if (!"forbiddenPasswords".equalsIgnoreCase(list_node.getNodeName())) continue;
                    for (Node forbiddenPasswords_node = list_node.getFirstChild(); forbiddenPasswords_node != null; forbiddenPasswords_node = forbiddenPasswords_node.getNextSibling()) {
                        if (!"password".equalsIgnoreCase(forbiddenPasswords_node.getNodeName())) continue;
                        this._forbiddenPasswords.add(forbiddenPasswords_node.getTextContent());
                    }
                }
            }
        }
        catch (Exception e) {
            this._log.log(Level.WARNING, "Failed to load secondary auth data from xml.", e);
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public int getMaxAttempts() {
        return this._maxAttempts;
    }

    public int getBanTime() {
        return this._banTime;
    }

    public String getRecoveryLink() {
        return this._recoveryLink;
    }

    public Set<String> getForbiddenPasswords() {
        return this._forbiddenPasswords;
    }

    public boolean isForbiddenPassword(String password) {
        return this._forbiddenPasswords.contains(password);
    }

    public static SecondaryAuthData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final SecondaryAuthData _instance = new SecondaryAuthData();

        private SingletonHolder() {
        }
    }
}

