/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.engines;

import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.StringIntern;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.PcRace;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.base.PlayerState;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.conditions.ConditionChangeWeapon;
import com.l2jserver.gameserver.model.conditions.ConditionGameChance;
import com.l2jserver.gameserver.model.conditions.ConditionGameTime;
import com.l2jserver.gameserver.model.conditions.ConditionLogicAnd;
import com.l2jserver.gameserver.model.conditions.ConditionLogicNot;
import com.l2jserver.gameserver.model.conditions.ConditionLogicOr;
import com.l2jserver.gameserver.model.conditions.ConditionMinDistance;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerActiveEffectId;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerActiveSkillId;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerAgathionId;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCallPc;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanEscape;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanPossessHolything;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanRefuelAirship;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanSummon;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanSweep;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanTransform;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanUntransform;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCharges;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerClassIdRestriction;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCloakStatus;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCp;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerFlyMounted;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerGrade;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerHasCastle;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerHasClanHall;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerHasFort;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerHasPet;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerHp;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerInsideZoneId;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerInstanceId;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerInvSize;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerIsClanLeader;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerIsHero;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerLandingZone;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerLevel;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerLevelRange;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerMp;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerPkCount;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerPledgeClass;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerRace;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerRangeFromNpc;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerServitorNpcId;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerSex;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerSiegeSide;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerSouls;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerState;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerSubclass;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerTransformationId;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerTvTEvent;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerVehicleMounted;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerWeight;
import com.l2jserver.gameserver.model.conditions.ConditionSiegeZone;
import com.l2jserver.gameserver.model.conditions.ConditionSlotItemId;
import com.l2jserver.gameserver.model.conditions.ConditionTargetAbnormal;
import com.l2jserver.gameserver.model.conditions.ConditionTargetActiveEffectId;
import com.l2jserver.gameserver.model.conditions.ConditionTargetActiveSkillId;
import com.l2jserver.gameserver.model.conditions.ConditionTargetAggro;
import com.l2jserver.gameserver.model.conditions.ConditionTargetClassIdRestriction;
import com.l2jserver.gameserver.model.conditions.ConditionTargetInvSize;
import com.l2jserver.gameserver.model.conditions.ConditionTargetLevel;
import com.l2jserver.gameserver.model.conditions.ConditionTargetLevelRange;
import com.l2jserver.gameserver.model.conditions.ConditionTargetMyPartyExceptMe;
import com.l2jserver.gameserver.model.conditions.ConditionTargetNpcId;
import com.l2jserver.gameserver.model.conditions.ConditionTargetNpcType;
import com.l2jserver.gameserver.model.conditions.ConditionTargetPlayable;
import com.l2jserver.gameserver.model.conditions.ConditionTargetRace;
import com.l2jserver.gameserver.model.conditions.ConditionTargetRaceId;
import com.l2jserver.gameserver.model.conditions.ConditionTargetUsesWeaponKind;
import com.l2jserver.gameserver.model.conditions.ConditionTargetWeight;
import com.l2jserver.gameserver.model.conditions.ConditionUsingItemType;
import com.l2jserver.gameserver.model.conditions.ConditionUsingSkill;
import com.l2jserver.gameserver.model.conditions.ConditionWithSkill;
import com.l2jserver.gameserver.model.effects.AbstractEffect;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.type.L2ArmorType;
import com.l2jserver.gameserver.model.items.type.L2WeaponType;
import com.l2jserver.gameserver.model.skills.EffectScope;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.model.skills.funcs.Lambda;
import com.l2jserver.gameserver.model.skills.funcs.LambdaCalc;
import com.l2jserver.gameserver.model.skills.funcs.LambdaConst;
import com.l2jserver.gameserver.model.skills.funcs.LambdaStats;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.model.stats.Stats;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class DocumentBase {
    protected final Logger _log = Logger.getLogger(this.getClass().getName());
    private File _file;
    protected Map<String, String[]> _tables;

    protected DocumentBase(File pFile) {
        this._file = pFile;
        this._tables = new FastMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parse() {
        try {
            Document doc = null;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setIgnoringComments(true);
                doc = factory.newDocumentBuilder().parse(this._file);
                this.parseDocument(doc);
            }
            catch (Exception e) {
                this._log.log(Level.SEVERE, "Error loading file " + this._file, e);
            }
            Document document = doc;
            return document;
        }
        finally {
            this._file = null;
            this._tables = null;
        }
    }

    protected abstract void parseDocument(Document var1);

    protected abstract StatsSet getStatsSet();

    protected abstract String getTableValue(String var1);

    protected abstract String getTableValue(String var1, int var2);

    protected void resetTable() {
        this._tables = new FastMap();
    }

    protected void setTable(String name, String[] table) {
        this._tables.put(name, table);
    }

    protected void parseTemplate(Node n, Object template) {
        this.parseTemplate(n, template, null);
    }

    protected void parseTemplate(Node n, Object template, EffectScope effectScope) {
        Condition condition = null;
        if ((n = n.getFirstChild()) == null) {
            return;
        }
        if ("cond".equalsIgnoreCase(n.getNodeName())) {
            condition = this.parseCondition(n.getFirstChild(), template);
            Node msg = n.getAttributes().getNamedItem("msg");
            Node msgId = n.getAttributes().getNamedItem("msgId");
            if (condition != null && msg != null) {
                condition.setMessage(msg.getNodeValue());
            } else if (condition != null && msgId != null) {
                condition.setMessageId(Integer.decode(this.getValue(msgId.getNodeValue(), null)));
                Node addName = n.getAttributes().getNamedItem("addName");
                if (addName != null && Integer.decode(this.getValue(msgId.getNodeValue(), null)) > 0) {
                    condition.addName();
                }
            }
            n = n.getNextSibling();
        }
        while (n != null) {
            if ("add".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Add", condition);
            } else if ("sub".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Sub", condition);
            } else if ("mul".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Mul", condition);
            } else if ("basemul".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "BaseMul", condition);
            } else if ("div".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Div", condition);
            } else if ("set".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Set", condition);
            } else if ("share".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Share", condition);
            } else if ("enchant".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Enchant", condition);
            } else if ("enchanthp".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "EnchantHp", condition);
            } else if ("effect".equalsIgnoreCase(n.getNodeName())) {
                if (template instanceof AbstractEffect) {
                    throw new RuntimeException("Nested effects");
                }
                this.attachEffect(n, template, condition, effectScope);
            }
            n = n.getNextSibling();
        }
    }

    protected void attachFunc(Node n, Object template, String name, Condition attachCond) {
        Stats stat = Stats.valueOfXml(n.getAttributes().getNamedItem("stat").getNodeValue());
        String order = n.getAttributes().getNamedItem("order").getNodeValue();
        Lambda lambda = this.getLambda(n, template);
        int ord = Integer.decode(this.getValue(order, template));
        Condition applayCond = this.parseCondition(n.getFirstChild(), template);
        FuncTemplate ft = new FuncTemplate(attachCond, applayCond, name, stat, ord, lambda);
        if (template instanceof L2Item) {
            ((L2Item)template).attach(ft);
        } else if (template instanceof L2Skill) {
            ((L2Skill)template).attach(ft);
        } else if (template instanceof AbstractEffect) {
            ((AbstractEffect)template).attach(ft);
        }
    }

    protected void attachLambdaFunc(Node n, Object template, LambdaCalc calc) {
        String name = n.getNodeName();
        StringBuilder sb = new StringBuilder(name);
        sb.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        name = sb.toString();
        Lambda lambda = this.getLambda(n, template);
        FuncTemplate ft = new FuncTemplate(null, null, name, null, calc.funcs.length, lambda);
        calc.addFunc(ft.getFunc(new Env(), calc));
    }

    protected void attachEffect(Node n, Object template, Condition attachCond) {
        this.attachEffect(n, template, attachCond, null);
    }

    protected void attachEffect(Node n, Object template, Condition attachCond, EffectScope effectScope) {
        NamedNodeMap attrs = n.getAttributes();
        StatsSet set = new StatsSet();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node att = attrs.item(i);
            set.set(att.getNodeName(), this.getValue(att.getNodeValue(), template));
        }
        StatsSet parameters = this.parseParameters(n.getFirstChild(), template);
        Condition applayCond = this.parseCondition(n.getFirstChild(), template);
        if (template instanceof IIdentifiable) {
            set.set("id", ((IIdentifiable)template).getId());
        }
        AbstractEffect effect = AbstractEffect.createEffect(attachCond, applayCond, set, parameters);
        this.parseTemplate(n, effect);
        if (template instanceof L2Item) {
            ((L2Item)template).attach(effect);
        } else if (template instanceof L2Skill) {
            L2Skill skill = (L2Skill)template;
            if (effectScope != null) {
                skill.addEffect(effectScope, effect);
            } else if (skill.isPassive()) {
                skill.addEffect(EffectScope.PASSIVE, effect);
            } else {
                skill.addEffect(EffectScope.GENERAL, effect);
            }
        }
    }

    private StatsSet parseParameters(Node n, Object template) {
        StatsSet parameters = null;
        while (n != null) {
            if (n.getNodeType() == 1 && "param".equals(n.getNodeName())) {
                if (parameters == null) {
                    parameters = new StatsSet();
                }
                NamedNodeMap params = n.getAttributes();
                for (int i = 0; i < params.getLength(); ++i) {
                    Node att = params.item(i);
                    parameters.set(StringIntern.intern(att.getNodeName()), StringIntern.intern(this.getValue(att.getNodeValue(), template)));
                }
            }
            n = n.getNextSibling();
        }
        return parameters;
    }

    protected Condition parseCondition(Node n, Object template) {
        while (n != null && n.getNodeType() != 1) {
            n = n.getNextSibling();
        }
        Condition condition = null;
        if (n != null) {
            switch (n.getNodeName()) {
                case "and": {
                    condition = this.parseLogicAnd(n, template);
                    break;
                }
                case "or": {
                    condition = this.parseLogicOr(n, template);
                    break;
                }
                case "not": {
                    condition = this.parseLogicNot(n, template);
                    break;
                }
                case "player": {
                    condition = this.parsePlayerCondition(n, template);
                    break;
                }
                case "target": {
                    condition = this.parseTargetCondition(n, template);
                    break;
                }
                case "using": {
                    condition = this.parseUsingCondition(n);
                    break;
                }
                case "game": {
                    condition = this.parseGameCondition(n);
                }
            }
        }
        return condition;
    }

    protected Condition parseLogicAnd(Node n, Object template) {
        ConditionLogicAnd cond = new ConditionLogicAnd();
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            cond.add(this.parseCondition(n, template));
        }
        if (cond.conditions == null || cond.conditions.length == 0) {
            this._log.severe("Empty <and> condition in " + this._file);
        }
        return cond;
    }

    protected Condition parseLogicOr(Node n, Object template) {
        ConditionLogicOr cond = new ConditionLogicOr();
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            cond.add(this.parseCondition(n, template));
        }
        if (cond.conditions == null || cond.conditions.length == 0) {
            this._log.severe("Empty <or> condition in " + this._file);
        }
        return cond;
    }

    protected Condition parseLogicNot(Node n, Object template) {
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return new ConditionLogicNot(this.parseCondition(n, template));
        }
        this._log.severe("Empty <not> condition in " + this._file);
        return null;
    }

    protected Condition parsePlayerCondition(Node n, Object template) {
        Condition cond = null;
        NamedNodeMap attrs = n.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node a = attrs.item(i);
            if ("races".equalsIgnoreCase(a.getNodeName())) {
                String[] racesVal = a.getNodeValue().split(",");
                PcRace[] races = new PcRace[racesVal.length];
                for (int r = 0; r < racesVal.length; ++r) {
                    if (racesVal[r] == null) continue;
                    races[r] = PcRace.valueOf(racesVal[r]);
                }
                cond = this.joinAnd(cond, new ConditionPlayerRace(races));
                continue;
            }
            if ("level".equalsIgnoreCase(a.getNodeName())) {
                int lvl = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionPlayerLevel(lvl));
                continue;
            }
            if ("levelRange".equalsIgnoreCase(a.getNodeName())) {
                String[] range = this.getValue(a.getNodeValue(), template).split(";");
                if (range.length != 2) continue;
                int[] lvlRange = new int[]{Integer.decode(this.getValue(a.getNodeValue(), template).split(";")[0]), Integer.decode(this.getValue(a.getNodeValue(), template).split(";")[1])};
                cond = this.joinAnd(cond, new ConditionPlayerLevelRange(lvlRange));
                continue;
            }
            if ("resting".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.RESTING, val));
                continue;
            }
            if ("flying".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.FLYING, val));
                continue;
            }
            if ("moving".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.MOVING, val));
                continue;
            }
            if ("running".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.RUNNING, val));
                continue;
            }
            if ("standing".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.STANDING, val));
                continue;
            }
            if ("behind".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.BEHIND, val));
                continue;
            }
            if ("front".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.FRONT, val));
                continue;
            }
            if ("chaotic".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.CHAOTIC, val));
                continue;
            }
            if ("olympiad".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.OLYMPIAD, val));
                continue;
            }
            if ("ishero".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerIsHero(val));
                continue;
            }
            if ("transformationId".equalsIgnoreCase(a.getNodeName())) {
                int id = Integer.parseInt(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerTransformationId(id));
                continue;
            }
            if ("hp".equalsIgnoreCase(a.getNodeName())) {
                int hp = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerHp(hp));
                continue;
            }
            if ("mp".equalsIgnoreCase(a.getNodeName())) {
                int hp = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerMp(hp));
                continue;
            }
            if ("cp".equalsIgnoreCase(a.getNodeName())) {
                int cp = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerCp(cp));
                continue;
            }
            if ("grade".equalsIgnoreCase(a.getNodeName())) {
                int expIndex = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionPlayerGrade(expIndex));
                continue;
            }
            if ("pkCount".equalsIgnoreCase(a.getNodeName())) {
                int expIndex = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionPlayerPkCount(expIndex));
                continue;
            }
            if ("siegezone".equalsIgnoreCase(a.getNodeName())) {
                int value = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionSiegeZone(value, true));
                continue;
            }
            if ("siegeside".equalsIgnoreCase(a.getNodeName())) {
                int value = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerSiegeSide(value));
                continue;
            }
            if ("charges".equalsIgnoreCase(a.getNodeName())) {
                int value = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionPlayerCharges(value));
                continue;
            }
            if ("souls".equalsIgnoreCase(a.getNodeName())) {
                int value = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionPlayerSouls(value));
                continue;
            }
            if ("weight".equalsIgnoreCase(a.getNodeName())) {
                int weight = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerWeight(weight));
                continue;
            }
            if ("invSize".equalsIgnoreCase(a.getNodeName())) {
                int size = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerInvSize(size));
                continue;
            }
            if ("isClanLeader".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerIsClanLeader(val));
                continue;
            }
            if ("onTvTEvent".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerTvTEvent(val));
                continue;
            }
            if ("pledgeClass".equalsIgnoreCase(a.getNodeName())) {
                int pledgeClass = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerPledgeClass(pledgeClass));
                continue;
            }
            if ("clanHall".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    array.add(Integer.decode(this.getValue(item, null)));
                }
                cond = this.joinAnd(cond, new ConditionPlayerHasClanHall(array));
                continue;
            }
            if ("fort".equalsIgnoreCase(a.getNodeName())) {
                int fort = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerHasFort(fort));
                continue;
            }
            if ("castle".equalsIgnoreCase(a.getNodeName())) {
                int castle = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerHasCastle(castle));
                continue;
            }
            if ("sex".equalsIgnoreCase(a.getNodeName())) {
                int sex = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerSex(sex));
                continue;
            }
            if ("flyMounted".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerFlyMounted(val));
                continue;
            }
            if ("vehicleMounted".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerVehicleMounted(val));
                continue;
            }
            if ("landingZone".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerLandingZone(val));
                continue;
            }
            if ("active_effect_id".equalsIgnoreCase(a.getNodeName())) {
                int effect_id = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionPlayerActiveEffectId(effect_id));
                continue;
            }
            if ("active_effect_id_lvl".equalsIgnoreCase(a.getNodeName())) {
                String val = this.getValue(a.getNodeValue(), template);
                int effect_id = Integer.decode(this.getValue(val.split(",")[0], template));
                int effect_lvl = Integer.decode(this.getValue(val.split(",")[1], template));
                cond = this.joinAnd(cond, new ConditionPlayerActiveEffectId(effect_id, effect_lvl));
                continue;
            }
            if ("active_skill_id".equalsIgnoreCase(a.getNodeName())) {
                int skill_id = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionPlayerActiveSkillId(skill_id));
                continue;
            }
            if ("active_skill_id_lvl".equalsIgnoreCase(a.getNodeName())) {
                String val = this.getValue(a.getNodeValue(), template);
                int skill_id = Integer.decode(this.getValue(val.split(",")[0], template));
                int skill_lvl = Integer.decode(this.getValue(val.split(",")[1], template));
                cond = this.joinAnd(cond, new ConditionPlayerActiveSkillId(skill_id, skill_lvl));
                continue;
            }
            if ("class_id_restriction".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    array.add(Integer.decode(this.getValue(item, null)));
                }
                cond = this.joinAnd(cond, new ConditionPlayerClassIdRestriction(array));
                continue;
            }
            if ("subclass".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerSubclass(val));
                continue;
            }
            if ("instanceId".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    array.add(Integer.decode(this.getValue(item, null)));
                }
                cond = this.joinAnd(cond, new ConditionPlayerInstanceId(array));
                continue;
            }
            if ("agathionId".equalsIgnoreCase(a.getNodeName())) {
                int agathionId = Integer.decode(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerAgathionId(agathionId));
                continue;
            }
            if ("cloakStatus".equalsIgnoreCase(a.getNodeName())) {
                int val = Integer.parseInt(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerCloakStatus(val));
                continue;
            }
            if ("hasPet".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    array.add(Integer.decode(this.getValue(item, null)));
                }
                cond = this.joinAnd(cond, new ConditionPlayerHasPet(array));
                continue;
            }
            if ("servitorNpcId".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    array.add(Integer.decode(this.getValue(item, null)));
                }
                cond = this.joinAnd(cond, new ConditionPlayerServitorNpcId(array));
                continue;
            }
            if ("npcIdRadius".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                if (st.countTokens() != 3) continue;
                String[] ids = st.nextToken().split(";");
                int[] npcIds = new int[ids.length];
                for (int index = 0; index < ids.length; ++index) {
                    npcIds[index] = Integer.parseInt(this.getValue(ids[index], template));
                }
                int radius = Integer.parseInt(st.nextToken());
                boolean val = Boolean.parseBoolean(st.nextToken());
                cond = this.joinAnd(cond, new ConditionPlayerRangeFromNpc(npcIds, radius, val));
                continue;
            }
            if ("callPc".equalsIgnoreCase(a.getNodeName())) {
                cond = this.joinAnd(cond, new ConditionPlayerCallPc(Boolean.parseBoolean(a.getNodeValue())));
                continue;
            }
            if ("canEscape".equalsIgnoreCase(a.getNodeName())) {
                cond = this.joinAnd(cond, new ConditionPlayerCanEscape(Boolean.parseBoolean(a.getNodeValue())));
                continue;
            }
            if ("canPossessHolything".equalsIgnoreCase(a.getNodeName())) {
                cond = this.joinAnd(cond, new ConditionPlayerCanPossessHolything(Boolean.parseBoolean(a.getNodeValue())));
                continue;
            }
            if ("canRefuelAirship".equalsIgnoreCase(a.getNodeName())) {
                cond = this.joinAnd(cond, new ConditionPlayerCanRefuelAirship(Integer.parseInt(a.getNodeValue())));
                continue;
            }
            if ("canSummon".equalsIgnoreCase(a.getNodeName())) {
                cond = this.joinAnd(cond, new ConditionPlayerCanSummon(Boolean.parseBoolean(a.getNodeValue())));
                continue;
            }
            if ("canSweep".equalsIgnoreCase(a.getNodeName())) {
                cond = this.joinAnd(cond, new ConditionPlayerCanSweep(Boolean.parseBoolean(a.getNodeValue())));
                continue;
            }
            if ("canTransform".equalsIgnoreCase(a.getNodeName())) {
                cond = this.joinAnd(cond, new ConditionPlayerCanTransform(Boolean.parseBoolean(a.getNodeValue())));
                continue;
            }
            if ("canUntransform".equalsIgnoreCase(a.getNodeName())) {
                cond = this.joinAnd(cond, new ConditionPlayerCanUntransform(Boolean.parseBoolean(a.getNodeValue())));
                continue;
            }
            if (!"insideZoneId".equalsIgnoreCase(a.getNodeName())) continue;
            StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
            ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
            while (st.hasMoreTokens()) {
                String item = st.nextToken().trim();
                array.add(Integer.decode(this.getValue(item, null)));
            }
            cond = this.joinAnd(cond, new ConditionPlayerInsideZoneId(array));
        }
        if (cond == null) {
            this._log.severe("Unrecognized <player> condition in " + this._file);
        }
        return cond;
    }

    protected Condition parseTargetCondition(Node n, Object template) {
        Condition cond = null;
        NamedNodeMap attrs = n.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node a = attrs.item(i);
            if ("aggro".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionTargetAggro(val));
                continue;
            }
            if ("siegezone".equalsIgnoreCase(a.getNodeName())) {
                int value = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionSiegeZone(value, false));
                continue;
            }
            if ("level".equalsIgnoreCase(a.getNodeName())) {
                int lvl = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionTargetLevel(lvl));
                continue;
            }
            if ("levelRange".equalsIgnoreCase(a.getNodeName())) {
                String[] range = this.getValue(a.getNodeValue(), template).split(";");
                if (range.length != 2) continue;
                int[] lvlRange = new int[]{Integer.decode(this.getValue(a.getNodeValue(), template).split(";")[0]), Integer.decode(this.getValue(a.getNodeValue(), template).split(";")[1])};
                cond = this.joinAnd(cond, new ConditionTargetLevelRange(lvlRange));
                continue;
            }
            if ("myPartyExceptMe".equalsIgnoreCase(a.getNodeName())) {
                cond = this.joinAnd(cond, new ConditionTargetMyPartyExceptMe(Boolean.parseBoolean(a.getNodeValue())));
                continue;
            }
            if ("playable".equalsIgnoreCase(a.getNodeName())) {
                cond = this.joinAnd(cond, new ConditionTargetPlayable());
                continue;
            }
            if ("class_id_restriction".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    array.add(Integer.decode(this.getValue(item, null)));
                }
                cond = this.joinAnd(cond, new ConditionTargetClassIdRestriction(array));
                continue;
            }
            if ("active_effect_id".equalsIgnoreCase(a.getNodeName())) {
                int effect_id = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionTargetActiveEffectId(effect_id));
                continue;
            }
            if ("active_effect_id_lvl".equalsIgnoreCase(a.getNodeName())) {
                String val = this.getValue(a.getNodeValue(), template);
                int effect_id = Integer.decode(this.getValue(val.split(",")[0], template));
                int effect_lvl = Integer.decode(this.getValue(val.split(",")[1], template));
                cond = this.joinAnd(cond, new ConditionTargetActiveEffectId(effect_id, effect_lvl));
                continue;
            }
            if ("active_skill_id".equalsIgnoreCase(a.getNodeName())) {
                int skill_id = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionTargetActiveSkillId(skill_id));
                continue;
            }
            if ("active_skill_id_lvl".equalsIgnoreCase(a.getNodeName())) {
                String val = this.getValue(a.getNodeValue(), template);
                int skill_id = Integer.decode(this.getValue(val.split(",")[0], template));
                int skill_lvl = Integer.decode(this.getValue(val.split(",")[1], template));
                cond = this.joinAnd(cond, new ConditionTargetActiveSkillId(skill_id, skill_lvl));
                continue;
            }
            if ("abnormal".equalsIgnoreCase(a.getNodeName())) {
                int abnormalId = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionTargetAbnormal(abnormalId));
                continue;
            }
            if ("mindistance".equalsIgnoreCase(a.getNodeName())) {
                int distance = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionMinDistance(distance * distance));
                continue;
            }
            if ("race_id".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    array.add(Integer.decode(this.getValue(item, null)));
                }
                cond = this.joinAnd(cond, new ConditionTargetRaceId(array));
                continue;
            }
            if ("races".equalsIgnoreCase(a.getNodeName())) {
                String[] racesVal = a.getNodeValue().split(",");
                PcRace[] races = new PcRace[racesVal.length];
                for (int r = 0; r < racesVal.length; ++r) {
                    if (racesVal[r] == null) continue;
                    races[r] = PcRace.valueOf(racesVal[r]);
                }
                cond = this.joinAnd(cond, new ConditionTargetRace(races));
                continue;
            }
            if ("using".equalsIgnoreCase(a.getNodeName())) {
                int mask = 0;
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                block4: while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    for (L2WeaponType l2WeaponType : L2WeaponType.values()) {
                        if (!l2WeaponType.getName().equals(item)) continue;
                        mask |= l2WeaponType.mask();
                        break;
                    }
                    for (Enum enum_ : L2ArmorType.values()) {
                        if (!((L2ArmorType)enum_).getName().equals(item)) continue;
                        mask |= ((L2ArmorType)enum_).mask();
                        continue block4;
                    }
                }
                cond = this.joinAnd(cond, new ConditionTargetUsesWeaponKind(mask));
                continue;
            }
            if ("npcId".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    array.add(Integer.decode(this.getValue(item, null)));
                }
                cond = this.joinAnd(cond, new ConditionTargetNpcId(array));
                continue;
            }
            if ("npcType".equalsIgnoreCase(a.getNodeName())) {
                String values = this.getValue(a.getNodeValue(), template).trim();
                String[] valuesSplit = values.split(",");
                InstanceType[] types = new InstanceType[valuesSplit.length];
                for (int j = 0; j < valuesSplit.length; ++j) {
                    InstanceType type = Enum.valueOf(InstanceType.class, valuesSplit[j]);
                    if (type == null) {
                        throw new IllegalArgumentException("Instance type not recognized: " + valuesSplit[j]);
                    }
                    types[j] = type;
                }
                cond = this.joinAnd(cond, new ConditionTargetNpcType(types));
                continue;
            }
            if ("weight".equalsIgnoreCase(a.getNodeName())) {
                int weight = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionTargetWeight(weight));
                continue;
            }
            if (!"invSize".equalsIgnoreCase(a.getNodeName())) continue;
            int size = Integer.decode(this.getValue(a.getNodeValue(), null));
            cond = this.joinAnd(cond, new ConditionTargetInvSize(size));
        }
        if (cond == null) {
            this._log.severe("Unrecognized <target> condition in " + this._file);
        }
        return cond;
    }

    protected Condition parseUsingCondition(Node n) {
        Condition cond = null;
        NamedNodeMap attrs = n.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node a = attrs.item(i);
            if ("kind".equalsIgnoreCase(a.getNodeName())) {
                int mask = 0;
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                while (st.hasMoreTokens()) {
                    int old = mask;
                    String item = st.nextToken().trim();
                    if (ItemTable._weaponTypes.containsKey(item)) {
                        mask |= ItemTable._weaponTypes.get(item).mask();
                    }
                    if (ItemTable._armorTypes.containsKey(item)) {
                        mask |= ItemTable._armorTypes.get(item).mask();
                    }
                    if (old != mask) continue;
                    this._log.info("[parseUsingCondition=\"kind\"] Unknown item type name: " + item);
                }
                cond = this.joinAnd(cond, new ConditionUsingItemType(mask));
                continue;
            }
            if ("skill".equalsIgnoreCase(a.getNodeName())) {
                int id = Integer.parseInt(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionUsingSkill(id));
                continue;
            }
            if ("slotitem".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ";");
                int id = Integer.parseInt(st.nextToken().trim());
                int slot = Integer.parseInt(st.nextToken().trim());
                int enchant = 0;
                if (st.hasMoreTokens()) {
                    enchant = Integer.parseInt(st.nextToken().trim());
                }
                cond = this.joinAnd(cond, new ConditionSlotItemId(slot, id, enchant));
                continue;
            }
            if (!"weaponChange".equalsIgnoreCase(a.getNodeName())) continue;
            boolean val = Boolean.parseBoolean(a.getNodeValue());
            cond = this.joinAnd(cond, new ConditionChangeWeapon(val));
        }
        if (cond == null) {
            this._log.severe("Unrecognized <using> condition in " + this._file);
        }
        return cond;
    }

    protected Condition parseGameCondition(Node n) {
        Condition cond = null;
        NamedNodeMap attrs = n.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            int val;
            Node a = attrs.item(i);
            if ("skill".equalsIgnoreCase(a.getNodeName())) {
                val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionWithSkill(val != 0));
            }
            if ("night".equalsIgnoreCase(a.getNodeName())) {
                val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionGameTime(ConditionGameTime.CheckGameTime.NIGHT, val != 0));
            }
            if (!"chance".equalsIgnoreCase(a.getNodeName())) continue;
            val = Integer.decode(this.getValue(a.getNodeValue(), null));
            cond = this.joinAnd(cond, new ConditionGameChance(val));
        }
        if (cond == null) {
            this._log.severe("Unrecognized <game> condition in " + this._file);
        }
        return cond;
    }

    protected void parseTable(Node n) {
        NamedNodeMap attrs = n.getAttributes();
        String name = attrs.getNamedItem("name").getNodeValue();
        if (name.charAt(0) != '#') {
            throw new IllegalArgumentException("Table name must start with #");
        }
        StringTokenizer data = new StringTokenizer(n.getFirstChild().getNodeValue());
        ArrayList<String> array = new ArrayList<String>(data.countTokens());
        while (data.hasMoreTokens()) {
            array.add(StringIntern.intern(data.nextToken()));
        }
        this.setTable(name, array.toArray(new String[array.size()]));
    }

    protected void parseBeanSet(Node n, StatsSet set, Integer level) {
        char ch;
        String name = n.getAttributes().getNamedItem("name").getNodeValue().trim();
        String value = n.getAttributes().getNamedItem("val").getNodeValue().trim();
        char c = ch = value.isEmpty() ? (char)' ' : (char)value.charAt(0);
        if (ch == '#' || ch == '-' || Character.isDigit(ch)) {
            set.set(name, String.valueOf(this.getValue(value, level)));
        } else {
            set.set(name, value);
        }
    }

    protected void setExtractableSkillData(StatsSet set, String value) {
        set.set("capsuled_items_skill", value);
    }

    protected Lambda getLambda(Node n, Object template) {
        Node nval = n.getAttributes().getNamedItem("val");
        if (nval != null) {
            String val = nval.getNodeValue();
            if (val.charAt(0) == '#') {
                return new LambdaConst(Double.parseDouble(this.getTableValue(val)));
            }
            if (val.charAt(0) == '$') {
                if (val.equalsIgnoreCase("$player_level")) {
                    return new LambdaStats(LambdaStats.StatsType.PLAYER_LEVEL);
                }
                if (val.equalsIgnoreCase("$target_level")) {
                    return new LambdaStats(LambdaStats.StatsType.TARGET_LEVEL);
                }
                if (val.equalsIgnoreCase("$player_max_hp")) {
                    return new LambdaStats(LambdaStats.StatsType.PLAYER_MAX_HP);
                }
                if (val.equalsIgnoreCase("$player_max_mp")) {
                    return new LambdaStats(LambdaStats.StatsType.PLAYER_MAX_MP);
                }
                StatsSet set = this.getStatsSet();
                String field = set.getString(val.substring(1));
                if (field != null) {
                    return new LambdaConst(Double.parseDouble(this.getValue(field, template)));
                }
                throw new IllegalArgumentException("Unknown value " + val);
            }
            return new LambdaConst(Double.parseDouble(val));
        }
        LambdaCalc calc = new LambdaCalc();
        for (n = n.getFirstChild(); n != null && n.getNodeType() != 1; n = n.getNextSibling()) {
        }
        if (n == null || !"val".equals(n.getNodeName())) {
            throw new IllegalArgumentException("Value not specified");
        }
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            this.attachLambdaFunc(n, template, calc);
        }
        return calc;
    }

    protected String getValue(String value, Object template) {
        if (value.charAt(0) == '#') {
            if (template instanceof L2Skill) {
                return this.getTableValue(value);
            }
            if (template instanceof Integer) {
                return this.getTableValue(value, (Integer)template);
            }
            throw new IllegalStateException();
        }
        return value;
    }

    protected Condition joinAnd(Condition cond, Condition c) {
        if (cond == null) {
            return c;
        }
        if (cond instanceof ConditionLogicAnd) {
            ((ConditionLogicAnd)cond).add(c);
            return cond;
        }
        ConditionLogicAnd and = new ConditionLogicAnd();
        and.add(cond);
        and.add(c);
        return and;
    }
}

