/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.engines;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.StringIntern;
import com.l2jserver.gameserver.engines.items.DocumentItem;
import com.l2jserver.gameserver.engines.skills.DocumentSkill;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.util.Util;
import com.l2jserver.util.file.filter.XMLFilter;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import jp.sf.l2j.troja.FastIntObjectMap;

public class DocumentEngine {
    private static final Logger _log = Logger.getLogger(DocumentEngine.class.getName());

    public static DocumentEngine getInstance() {
        return SingletonHolder._instance;
    }

    protected DocumentEngine() {
    }

    private void hashFiles(String dirname, List<File> hash) {
        File dir = new File(Config.DATAPACK_ROOT, dirname);
        if (!dir.exists()) {
            _log.warning("Dir " + dir.getAbsolutePath() + " not exists");
            return;
        }
        for (File f : dir.listFiles(new XMLFilter())) {
            hash.add(f);
        }
    }

    private List<L2Skill> loadSkills(File file) {
        if (file == null) {
            _log.warning("Skill file not found.");
            return null;
        }
        DocumentSkill doc = new DocumentSkill(file);
        doc.parse();
        return doc.getSkills();
    }

    public void loadAllSkills(FastIntObjectMap<L2Skill> allSkills) {
        long started = System.currentTimeMillis();
        int count = 0;
        FastList files = new FastList();
        this.hashFiles("data/stats/skills", (List<File>)files);
        if (Config.CUSTOM_SKILLS_LOAD) {
            this.hashFiles("data/stats/skills/custom", (List<File>)files);
        }
        StringIntern.begin(SkillTable.class.getSimpleName());
        StringIntern.intern("icon.skill0000");
        for (File file : files) {
            List<L2Skill> s = this.loadSkills(file);
            if (s == null) continue;
            for (L2Skill skill : s) {
                if (allSkills.put(SkillTable.getSkillHashCode(skill), (Object)skill) != null) {
                    _log.log(Level.INFO, "<!>" + SkillTable.class.getSimpleName() + ": file '" + file.getPath() + "' override the skill " + (Object)((Object)skill.getSkillType()) + " " + skill.getId() + " " + skill.getName());
                }
                ++count;
            }
        }
        StringIntern.end();
        _log.info("SkillTable: Loaded " + count + " Skill templates from XML files. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
    }

    public List<L2Item> loadItems() {
        FastIntObjectMap list = new FastIntObjectMap();
        FastList files = new FastList();
        this.hashFiles("data/stats/items", (List<File>)files);
        if (Config.CUSTOM_ITEMS_LOAD) {
            this.hashFiles("data/stats/items/custom", (List<File>)files);
        }
        StringIntern.begin(ItemTable.class.getSimpleName());
        for (File f : files) {
            DocumentItem document = new DocumentItem(f);
            document.parse();
            for (L2Item item : document.getItemList()) {
                if (list.put(item.getId(), (Object)item) == null) continue;
                _log.log(Level.INFO, "<!>" + ItemTable.class.getSimpleName() + ": file '" + f.getPath() + "' override the item " + item.getItemType() + " " + item.getId() + " " + item.getName());
            }
        }
        StringIntern.end();
        return new FastList(list.values());
    }

    private static class SingletonHolder {
        protected static final DocumentEngine _instance = new DocumentEngine();

        private SingletonHolder() {
        }
    }
}

