/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.engines;

import com.l2jserver.Config;
import com.l2jserver.util.file.filter.XMLFilter;
import java.io.File;
import java.io.FileFilter;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public abstract class DocumentParser {
    protected final Logger _log = Logger.getLogger(this.getClass().getName());
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final XMLFilter XML_FILTER = new XMLFilter();
    private File _currentFile;
    private Document _currentDocument;
    private FileFilter _currentFilter = XML_FILTER;

    public abstract void load();

    protected void parseDatapackFile(String path) {
        this.parseFile(new File(Config.DATAPACK_ROOT, path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseFile(File f) {
        try {
            if (!this.getCurrentFileFilter().accept(f)) {
                this._log.warning(this.getClass().getSimpleName() + ": Could not parse " + f.getPath() + " is not a file or it doesn't exist!");
                return;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(true);
            dbf.setIgnoringComments(true);
            this._currentDocument = null;
            this._currentFile = f;
            try {
                dbf.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                DocumentBuilder db = dbf.newDocumentBuilder();
                db.setErrorHandler(new XMLErrorHandler());
                this._currentDocument = db.parse(f);
            }
            catch (Exception e) {
                this._currentDocument = null;
                this._currentFile = null;
                return;
            }
            this.parseDocument();
        }
        finally {
            this._currentDocument = null;
            this._currentFile = null;
        }
    }

    public File getCurrentFile() {
        return this._currentFile;
    }

    protected Document getCurrentDocument() {
        return this._currentDocument;
    }

    protected boolean parseDirectory(File file) {
        return this.parseDirectory(file, false);
    }

    protected boolean parseDirectory(String path) {
        return this.parseDirectory(new File(path), false);
    }

    protected boolean parseDirectory(String path, boolean recursive) {
        return this.parseDirectory(new File(path), recursive);
    }

    protected boolean parseDirectory(File dir, boolean recursive) {
        File[] listOfFiles;
        if (!dir.exists()) {
            this._log.warning(this.getClass().getSimpleName() + ": Folder " + dir.getAbsolutePath() + " doesn't exist!");
            return false;
        }
        for (File f : listOfFiles = dir.listFiles()) {
            if (recursive && f.isDirectory()) {
                this.parseDirectory(f, recursive);
                continue;
            }
            if (!this.getCurrentFileFilter().accept(f)) continue;
            this.parseFile(f);
        }
        return true;
    }

    protected boolean parseDatapackDirectory(String path, boolean recursive) {
        return this.parseDirectory(new File(Config.DATAPACK_ROOT, path), recursive);
    }

    protected void parseDocument(Document doc) {
    }

    protected abstract void parseDocument();

    protected Boolean parseBoolean(Node node, Boolean defaultValue) {
        return node != null ? Boolean.valueOf(node.getNodeValue()) : defaultValue;
    }

    protected Boolean parseBoolean(Node node) {
        return this.parseBoolean(node, null);
    }

    protected Boolean parseBoolean(NamedNodeMap attrs, String name) {
        return this.parseBoolean(attrs.getNamedItem(name));
    }

    protected Boolean parseBoolean(NamedNodeMap attrs, String name, Boolean defaultValue) {
        return this.parseBoolean(attrs.getNamedItem(name), defaultValue);
    }

    protected Byte parseByte(Node node, Byte defaultValue) {
        return node != null ? Byte.valueOf(node.getNodeValue()) : defaultValue;
    }

    protected Byte parseByte(Node node) {
        return this.parseByte(node, null);
    }

    protected Byte parseByte(NamedNodeMap attrs, String name) {
        return this.parseByte(attrs.getNamedItem(name));
    }

    protected Byte parseByte(NamedNodeMap attrs, String name, Byte defaultValue) {
        return this.parseByte(attrs.getNamedItem(name), defaultValue);
    }

    protected Short parseShort(Node node, Short defaultValue) {
        return node != null ? Short.valueOf(node.getNodeValue()) : defaultValue;
    }

    protected Short parseShort(Node node) {
        return this.parseShort(node, null);
    }

    protected Short parseShort(NamedNodeMap attrs, String name) {
        return this.parseShort(attrs.getNamedItem(name));
    }

    protected Short parseShort(NamedNodeMap attrs, String name, Short defaultValue) {
        return this.parseShort(attrs.getNamedItem(name), defaultValue);
    }

    protected Integer parseInteger(Node node, Integer defaultValue) {
        return node != null ? Integer.valueOf(node.getNodeValue()) : defaultValue;
    }

    protected Integer parseInteger(Node node) {
        return this.parseInteger(node, null);
    }

    protected Integer parseInteger(NamedNodeMap attrs, String name) {
        return this.parseInteger(attrs.getNamedItem(name));
    }

    protected Integer parseInteger(NamedNodeMap attrs, String name, Integer defaultValue) {
        return this.parseInteger(attrs.getNamedItem(name), defaultValue);
    }

    protected Long parseLong(Node node, Long defaultValue) {
        return node != null ? Long.valueOf(node.getNodeValue()) : defaultValue;
    }

    protected Long parseLong(Node node) {
        return this.parseLong(node, null);
    }

    protected Long parseLong(NamedNodeMap attrs, String name) {
        return this.parseLong(attrs.getNamedItem(name));
    }

    protected Long parseLong(NamedNodeMap attrs, String name, Long defaultValue) {
        return this.parseLong(attrs.getNamedItem(name), defaultValue);
    }

    protected Float parseFloat(Node node, Float defaultValue) {
        return node != null ? Float.valueOf(node.getNodeValue()) : defaultValue;
    }

    protected Float parseFloat(Node node) {
        return this.parseFloat(node, null);
    }

    protected Float parseFloat(NamedNodeMap attrs, String name) {
        return this.parseFloat(attrs.getNamedItem(name));
    }

    protected Float parseFloat(NamedNodeMap attrs, String name, Float defaultValue) {
        return this.parseFloat(attrs.getNamedItem(name), defaultValue);
    }

    protected Double parseDouble(Node node, Double defaultValue) {
        return node != null ? Double.valueOf(node.getNodeValue()) : defaultValue;
    }

    protected Double parseDouble(Node node) {
        return this.parseDouble(node, null);
    }

    protected Double parseDouble(NamedNodeMap attrs, String name) {
        return this.parseDouble(attrs.getNamedItem(name));
    }

    protected Double parseDouble(NamedNodeMap attrs, String name, Double defaultValue) {
        return this.parseDouble(attrs.getNamedItem(name), defaultValue);
    }

    protected String parseString(Node node, String defaultValue) {
        return node != null ? node.getNodeValue() : defaultValue;
    }

    protected String parseString(Node node) {
        return this.parseString(node, null);
    }

    protected String parseString(NamedNodeMap attrs, String name) {
        return this.parseString(attrs.getNamedItem(name));
    }

    protected String parseString(NamedNodeMap attrs, String name, String defaultValue) {
        return this.parseString(attrs.getNamedItem(name), defaultValue);
    }

    protected <T extends Enum<T>> T parseEnum(Node node, Class<T> clazz, T defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(clazz, node.getNodeValue());
        }
        catch (IllegalArgumentException e) {
            this._log.warning("[" + this.getCurrentFile().getName() + "] Invalid value specified for node: " + node.getNodeName() + " specified value: " + node.getNodeValue() + " should be enum value of \"" + clazz.getSimpleName() + "\" using default value: " + defaultValue);
            return defaultValue;
        }
    }

    protected <T extends Enum<T>> T parseEnum(Node node, Class<T> clazz) {
        return this.parseEnum(node, clazz, null);
    }

    protected <T extends Enum<T>> T parseEnum(NamedNodeMap attrs, Class<T> clazz, String name) {
        return this.parseEnum(attrs.getNamedItem(name), clazz);
    }

    protected <T extends Enum<T>> T parseEnum(NamedNodeMap attrs, Class<T> clazz, String name, T defaultValue) {
        return this.parseEnum(attrs.getNamedItem(name), clazz, defaultValue);
    }

    public void setCurrentFileFilter(FileFilter filter) {
        this._currentFilter = filter;
    }

    public FileFilter getCurrentFileFilter() {
        return this._currentFilter;
    }

    protected class XMLErrorHandler
    implements ErrorHandler {
        protected XMLErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXParseException {
            this.log(e, "WARNING");
            throw e;
        }

        @Override
        public void error(SAXParseException e) throws SAXParseException {
            this.log(e, "ERROR");
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXParseException {
            this.log(e, "FATAL ERROR");
            throw e;
        }

        private void log(SAXParseException e, String kind) {
            DocumentParser.this._log.warning(DocumentParser.this.getClass().getSimpleName() + ": " + kind + " in " + DocumentParser.this.getCurrentFile().getPath() + " (at line " + e.getLineNumber() + " column " + e.getColumnNumber() + ")" + " - " + e.getMessage());
        }
    }
}

