/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handler;

import com.l2jserver.gameserver.handler.IHandler;
import com.l2jserver.gameserver.handler.ISkillHandler;
import com.l2jserver.gameserver.model.skills.L2SkillType;
import java.util.HashMap;
import java.util.Map;

public class SkillHandler
implements IHandler<ISkillHandler, L2SkillType> {
    private final Map<Integer, ISkillHandler> _datatable = new HashMap<Integer, ISkillHandler>();

    protected SkillHandler() {
    }

    @Override
    public void registerHandler(ISkillHandler handler) {
        L2SkillType[] types;
        for (L2SkillType t : types = handler.getSkillIds()) {
            this._datatable.put(t.ordinal(), handler);
        }
    }

    @Override
    public synchronized void removeHandler(ISkillHandler handler) {
        L2SkillType[] types;
        for (L2SkillType t : types = handler.getSkillIds()) {
            this._datatable.remove(t.ordinal());
        }
    }

    @Override
    public ISkillHandler getHandler(L2SkillType skillType) {
        return this._datatable.get(skillType.ordinal());
    }

    @Override
    public int size() {
        return this._datatable.size();
    }

    public static SkillHandler getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final SkillHandler _instance = new SkillHandler();

        private SingletonHolder() {
        }
    }
}

