/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.instancemanager.AuctionManager;
import com.l2jserver.gameserver.instancemanager.CHSiegeManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.entity.Auction;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.clanhall.AuctionableHall;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.zone.type.L2ClanHallZone;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public final class ClanHallManager {
    protected static final Logger _log = Logger.getLogger(ClanHallManager.class.getName());
    private final Map<Integer, AuctionableHall> _clanHall = new FastMap();
    private final Map<Integer, AuctionableHall> _freeClanHall = new FastMap();
    private final Map<Integer, AuctionableHall> _allAuctionableClanHalls = new FastMap();
    private static Map<Integer, ClanHall> _allClanHalls = new FastMap();
    private boolean _loaded = false;

    public boolean loaded() {
        return this._loaded;
    }

    protected ClanHallManager() {
        this.load();
    }

    private final void load() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT * FROM clanhall ORDER BY id");){
            while (rs.next()) {
                StatsSet set = new StatsSet();
                int id = rs.getInt("id");
                int ownerId = rs.getInt("ownerId");
                int lease = rs.getInt("lease");
                set.set("id", id);
                set.set("name", rs.getString("name"));
                set.set("ownerId", ownerId);
                set.set("lease", lease);
                set.set("desc", rs.getString("desc"));
                set.set("location", rs.getString("location"));
                set.set("paidUntil", rs.getLong("paidUntil"));
                set.set("grade", rs.getInt("Grade"));
                set.set("paid", rs.getBoolean("paid"));
                AuctionableHall ch = new AuctionableHall(set);
                this._allAuctionableClanHalls.put(id, ch);
                ClanHallManager.addClanHall(ch);
                if (ch.getOwnerId() > 0) {
                    this._clanHall.put(id, ch);
                    continue;
                }
                this._freeClanHall.put(id, ch);
                Auction auc = AuctionManager.getInstance().getAuction(id);
                if (auc != null || lease <= 0) continue;
                AuctionManager.getInstance().initNPC(id);
            }
            _log.info(this.getClass().getSimpleName() + ": Loaded: " + this.getClanHalls().size() + " clan halls");
            _log.info(this.getClass().getSimpleName() + ": Loaded: " + this.getFreeClanHalls().size() + " free clan halls");
            this._loaded = true;
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: ClanHallManager.load(): " + e.getMessage(), e);
        }
    }

    public static final Map<Integer, ClanHall> getAllClanHalls() {
        return _allClanHalls;
    }

    public final Map<Integer, AuctionableHall> getFreeClanHalls() {
        return this._freeClanHall;
    }

    public final Map<Integer, AuctionableHall> getClanHalls() {
        return this._clanHall;
    }

    public final Map<Integer, AuctionableHall> getAllAuctionableClanHalls() {
        return this._allAuctionableClanHalls;
    }

    public static final void addClanHall(ClanHall hall) {
        _allClanHalls.put(hall.getId(), hall);
    }

    public final boolean isFree(int chId) {
        return this._freeClanHall.containsKey(chId);
    }

    public final synchronized void setFree(int chId) {
        this._freeClanHall.put(chId, this._clanHall.get(chId));
        ClanTable.getInstance().getClan(this._freeClanHall.get(chId).getOwnerId()).setHideoutId(0);
        this._freeClanHall.get(chId).free();
        this._clanHall.remove(chId);
    }

    public final synchronized void setOwner(int chId, L2Clan clan) {
        if (!this._clanHall.containsKey(chId)) {
            this._clanHall.put(chId, this._freeClanHall.get(chId));
            this._freeClanHall.remove(chId);
        } else {
            this._clanHall.get(chId).free();
        }
        ClanTable.getInstance().getClan(clan.getId()).setHideoutId(chId);
        this._clanHall.get(chId).setOwner(clan);
    }

    public final ClanHall getClanHallById(int clanHallId) {
        return _allClanHalls.get(clanHallId);
    }

    public final AuctionableHall getAuctionableHallById(int clanHallId) {
        return this._allAuctionableClanHalls.get(clanHallId);
    }

    public final ClanHall getClanHall(int x, int y, int z) {
        for (ClanHall temp : ClanHallManager.getAllClanHalls().values()) {
            if (!temp.checkIfInZone(x, y, z)) continue;
            return temp;
        }
        return null;
    }

    public final ClanHall getClanHall(L2Object activeObject) {
        return this.getClanHall(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public final AuctionableHall getNearbyClanHall(int x, int y, int maxDist) {
        L2ClanHallZone zone = null;
        for (Map.Entry<Integer, AuctionableHall> ch : this._clanHall.entrySet()) {
            zone = ch.getValue().getZone();
            if (zone == null || !(zone.getDistanceToZone(x, y) < (double)maxDist)) continue;
            return ch.getValue();
        }
        for (Map.Entry<Integer, AuctionableHall> ch : this._freeClanHall.entrySet()) {
            zone = ch.getValue().getZone();
            if (zone == null || !(zone.getDistanceToZone(x, y) < (double)maxDist)) continue;
            return ch.getValue();
        }
        return null;
    }

    public final ClanHall getNearbyAbstractHall(int x, int y, int maxDist) {
        L2ClanHallZone zone = null;
        for (Map.Entry<Integer, ClanHall> ch : _allClanHalls.entrySet()) {
            zone = ch.getValue().getZone();
            if (zone == null || !(zone.getDistanceToZone(x, y) < (double)maxDist)) continue;
            return ch.getValue();
        }
        return null;
    }

    public final AuctionableHall getClanHallByOwner(L2Clan clan) {
        for (Map.Entry<Integer, AuctionableHall> ch : this._clanHall.entrySet()) {
            if (clan.getId() != ch.getValue().getOwnerId()) continue;
            return ch.getValue();
        }
        return null;
    }

    public final ClanHall getAbstractHallByOwner(L2Clan clan) {
        for (Map.Entry<Integer, AuctionableHall> ch : this._clanHall.entrySet()) {
            if (clan.getId() != ch.getValue().getOwnerId()) continue;
            return ch.getValue();
        }
        for (Map.Entry<Integer, AuctionableHall> ch : CHSiegeManager.getInstance().getConquerableHalls().entrySet()) {
            if (clan.getId() != ((SiegableHall)((Object)ch.getValue())).getOwnerId()) continue;
            return ch.getValue();
        }
        return null;
    }

    public static ClanHallManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final ClanHallManager _instance = new ClanHallManager();

        private SingletonHolder() {
        }
    }
}

