/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.instancemanager.RaidBossSpawnManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2RaidBossInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastSet;

public final class DayNightSpawnManager {
    private static Logger _log = Logger.getLogger(DayNightSpawnManager.class.getName());
    private final ArrayList<L2Spawn> _dayCreatures = new ArrayList();
    private final ArrayList<L2Spawn> _nightCreatures = new ArrayList();
    private final FastSet<L2Spawn> _nightBosses = new FastSet();

    public static DayNightSpawnManager getInstance() {
        return SingletonHolder._instance;
    }

    protected DayNightSpawnManager() {
    }

    public void addDayCreature(L2Spawn spawnDat) {
        this._dayCreatures.add(spawnDat);
    }

    public void addNightCreature(L2Spawn spawnDat) {
        this._nightCreatures.add(spawnDat);
    }

    public void spawnDayCreatures() {
        this.spawnCreatures(this._nightCreatures, this._dayCreatures, "night", "day");
    }

    public void spawnNightCreatures() {
        this.spawnCreatures(this._dayCreatures, this._nightCreatures, "day", "night");
    }

    private void spawnCreatures(List<L2Spawn> unSpawnCreatures, List<L2Spawn> spawnCreatures, String UnspawnLogInfo, String SpawnLogInfo) {
        try {
            int i;
            if (!unSpawnCreatures.isEmpty()) {
                i = 0;
                for (L2Spawn spawn : unSpawnCreatures) {
                    if (spawn == null) continue;
                    spawn.stopRespawn();
                    L2Npc last = spawn.getLastSpawn();
                    if (last == null) continue;
                    last.deleteMe();
                    ++i;
                }
                _log.info(this.getClass().getSimpleName() + ": Removed " + i + " " + UnspawnLogInfo + " creatures");
            }
            i = 0;
            for (L2Spawn spawnDat : spawnCreatures) {
                if (spawnDat == null) continue;
                spawnDat.startRespawn();
                spawnDat.doSpawn();
                ++i;
            }
            _log.info(this.getClass().getSimpleName() + ": Spawned " + i + " " + SpawnLogInfo + " creatures");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while spawning creatures: " + e.getMessage(), e);
        }
    }

    private void changeMode(boolean isNight) {
        if (this._nightCreatures.isEmpty() && this._dayCreatures.isEmpty() && this._nightBosses.isEmpty()) {
            return;
        }
        if (isNight) {
            this.spawnNightCreatures();
        } else {
            this.spawnDayCreatures();
        }
    }

    public DayNightSpawnManager trim() {
        this._nightCreatures.trimToSize();
        this._dayCreatures.trimToSize();
        return this;
    }

    public void notifyChangeMode() {
        try {
            boolean isNight = GameTimeController.getInstance().isNight();
            this.changeMode(isNight);
            this.changeBoss(isNight);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while notifyChangeMode(): " + e.getMessage(), e);
        }
    }

    public void cleanUp() {
        this._nightCreatures.clear();
        this._dayCreatures.clear();
        this._nightBosses.clear();
    }

    private void changeBoss(boolean isNight) {
        try {
            for (L2Spawn spawn : this._nightBosses) {
                L2RaidBossInstance raidboss = (L2RaidBossInstance)spawn.getLastSpawn();
                if (isNight) {
                    if (raidboss != null && raidboss.isVisible() || RaidBossSpawnManager.getInstance().getRaidBossStatusId(spawn.getId()) == RaidBossSpawnManager.StatusEnum.DEAD) continue;
                    raidboss = (L2RaidBossInstance)spawn.doSpawn();
                    RaidBossSpawnManager.getInstance().notifySpawnNightBoss(raidboss);
                    continue;
                }
                if (raidboss == null) continue;
                raidboss.deleteMe();
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while changeNightBoss(): " + e.getMessage(), e);
        }
    }

    public L2RaidBossInstance handleBoss(L2Spawn spawnDat) {
        this._nightBosses.add((Object)spawnDat);
        L2RaidBossInstance raidboss = (L2RaidBossInstance)spawnDat.getLastSpawn();
        if (raidboss != null && raidboss.isVisible()) {
            return raidboss;
        }
        raidboss = GameTimeController.getInstance().isNight() ? (L2RaidBossInstance)spawnDat.doSpawn() : null;
        return raidboss;
    }

    private static class SingletonHolder {
        protected static final DayNightSpawnManager _instance = new DayNightSpawnManager();

        private SingletonHolder() {
        }
    }
}

