/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.scripting.L2ScriptEngineManager;
import com.l2jserver.gameserver.scripting.ScriptManager;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public final class QuestManager
extends ScriptManager<Quest> {
    protected static final Logger _log = Logger.getLogger(QuestManager.class.getName());
    private final FastMap<String, Quest> _quests = new FastMap().shared();

    protected QuestManager() {
    }

    @Override
    public final boolean reload(String questFolder) {
        Quest q = this.getQuest(questFolder);
        if (q == null) {
            return false;
        }
        return q.reload();
    }

    @Override
    public final boolean reload(int questId) {
        Quest q = this.getQuest(questId);
        if (q == null) {
            return false;
        }
        return q.reload();
    }

    public final void reloadAllQuests() {
        _log.info(this.getClass().getSimpleName() + ": Reloading all server scripts.");
        for (Quest quest : this._quests.values()) {
            if (quest == null) continue;
            quest.unload(false);
        }
        this._quests.clear();
        try {
            L2ScriptEngineManager.getInstance().executeScriptList(new File(Config.DATAPACK_ROOT, "data/scripts.cfg"));
            QuestManager.getInstance().report();
        }
        catch (IOException e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Failed loading scripts.cfg, no script going to be loaded!", e);
        }
    }

    public final void report() {
        _log.info(this.getClass().getSimpleName() + ": Loaded: " + this._quests.size() + " quests");
    }

    public final void save() {
        for (Quest q : this._quests.values()) {
            q.saveGlobalData();
        }
    }

    public final Quest getQuest(String name) {
        return (Quest)this._quests.get((Object)name);
    }

    public final Quest getQuest(int questId) {
        for (Quest q : this._quests.values()) {
            if (q.getId() != questId) continue;
            return q;
        }
        return null;
    }

    public final void addQuest(Quest newQuest) {
        if (newQuest == null) {
            throw new IllegalArgumentException("Quest argument cannot be null");
        }
        Quest old = (Quest)this._quests.get((Object)newQuest.getName());
        if (old != null) {
            old.unload();
            _log.info(this.getClass().getSimpleName() + ": Replaced: (" + old.getName() + ") with a new version (" + newQuest.getName() + ")");
        }
        this._quests.put((Object)newQuest.getName(), (Object)newQuest);
    }

    public final boolean removeQuest(Quest q) {
        return this._quests.remove((Object)q.getName()) != null;
    }

    @Override
    public Iterable<Quest> getAllManagedScripts() {
        return this._quests.values();
    }

    @Override
    public boolean unload(Quest ms) {
        ms.saveGlobalData();
        return this.removeQuest(ms);
    }

    @Override
    public String getScriptManagerName() {
        return this.getClass().getSimpleName();
    }

    public static final QuestManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final QuestManager _instance = new QuestManager();

        private SingletonHolder() {
        }
    }
}

