/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.TerritoryWard;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeFlagInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.Siegable;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.PropertiesParser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;
import jp.sf.l2j.arrayMaps.SortedIntIntArrayMap;
import jp.sf.l2j.troja.FastIntObjectMap;

public final class TerritoryWarManager
implements Siegable {
    private static final Logger _log = Logger.getLogger(TerritoryWarManager.class.getName());
    private static final String DELETE = "DELETE FROM territory_registrations WHERE castleId = ? and registeredId = ?";
    private static final String INSERT = "INSERT INTO territory_registrations (castleId, registeredId) values (?, ?)";
    public static String qn = "TerritoryWarSuperClass";
    public static int DEFENDERMAXCLANS;
    public static int DEFENDERMAXPLAYERS;
    public static int CLANMINLEVEL;
    public static int PLAYERMINLEVEL;
    public static int MINTWBADGEFORNOBLESS;
    public static int MINTWBADGEFORSTRIDERS;
    public static int MINTWBADGEFORBIGSTRIDER;
    public static long WARLENGTH;
    public static boolean PLAYER_WITH_WARD_CAN_BE_KILLED_IN_PEACEZONE;
    public static boolean SPAWN_WARDS_WHEN_TW_IS_NOT_IN_PROGRESS;
    public static boolean RETURN_WARDS_WHEN_TW_STARTS;
    public final SortedIntIntArrayMap TERRITORY_ITEM_IDS = new SortedIntIntArrayMap();
    private final FastMap<Integer, FastList<L2Clan>> _registeredClans = new FastMap().shared();
    private final FastMap<Integer, FastList<Integer>> _registeredMercenaries = new FastMap().shared();
    private final FastIntObjectMap<Territory> _territoryList = new FastIntObjectMap().shared();
    protected final FastList<Integer> _disguisedPlayers = new FastList().shared();
    private final FastList<TerritoryWard> _territoryWards = new FastList().shared();
    private final FastMap<L2Clan, L2SiegeFlagInstance> _clanFlags = new FastMap().shared();
    private final FastIntObjectMap<int[]> _participantPoints = new FastIntObjectMap();
    protected Calendar _startTWDate = Calendar.getInstance();
    protected boolean _isRegistrationOver = true;
    protected boolean _isTWChannelOpen = false;
    private boolean _isTWInProgress = false;
    protected ScheduledFuture<?> _scheduledStartTWTask = null;
    protected ScheduledFuture<?> _scheduledEndTWTask = null;
    protected ScheduledFuture<?> _scheduledRewardOnlineTask = null;

    protected TerritoryWarManager() {
        this.TERRITORY_ITEM_IDS.put(81, 13757);
        this.TERRITORY_ITEM_IDS.put(82, 13758);
        this.TERRITORY_ITEM_IDS.put(83, 13759);
        this.TERRITORY_ITEM_IDS.put(84, 13760);
        this.TERRITORY_ITEM_IDS.put(85, 13761);
        this.TERRITORY_ITEM_IDS.put(86, 13762);
        this.TERRITORY_ITEM_IDS.put(87, 13763);
        this.TERRITORY_ITEM_IDS.put(88, 13764);
        this.TERRITORY_ITEM_IDS.put(89, 13765);
        this.load();
    }

    public int getRegisteredTerritoryId(L2PcInstance player) {
        int cId;
        Iterator i$;
        if (player == null || !this._isTWChannelOpen || player.getLevel() < PLAYERMINLEVEL) {
            return 0;
        }
        if (player.getClan() != null) {
            if (player.getClan().getCastleId() > 0) {
                return player.getClan().getCastleId() + 80;
            }
            i$ = this._registeredClans.keySet().iterator();
            while (i$.hasNext()) {
                cId = (Integer)i$.next();
                if (!((FastList)this._registeredClans.get((Object)cId)).contains((Object)player.getClan())) continue;
                return cId + 80;
            }
        }
        i$ = this._registeredMercenaries.keySet().iterator();
        while (i$.hasNext()) {
            cId = (Integer)i$.next();
            if (!((FastList)this._registeredMercenaries.get((Object)cId)).contains((Object)player.getObjectId())) continue;
            return cId + 80;
        }
        return 0;
    }

    public boolean isAllyField(L2PcInstance player, int fieldId) {
        if (player == null || player.getSiegeSide() == 0) {
            return false;
        }
        if (player.getSiegeSide() - 80 == fieldId) {
            return true;
        }
        return fieldId > 100 && this._territoryList.containsKey(player.getSiegeSide() - 80) && ((Territory)this._territoryList.get(player.getSiegeSide() - 80)).getFortId() == fieldId;
    }

    public final boolean checkIsRegistered(int castleId, L2Clan clan) {
        if (clan == null) {
            return false;
        }
        if (clan.getCastleId() > 0) {
            return castleId == -1 ? true : clan.getCastleId() == castleId;
        }
        if (castleId == -1) {
            Iterator i$ = this._registeredClans.keySet().iterator();
            while (i$.hasNext()) {
                int cId = (Integer)i$.next();
                if (!((FastList)this._registeredClans.get((Object)cId)).contains((Object)clan)) continue;
                return true;
            }
            return false;
        }
        return ((FastList)this._registeredClans.get((Object)castleId)).contains((Object)clan);
    }

    public final boolean checkIsRegistered(int castleId, int objId) {
        if (castleId == -1) {
            Iterator i$ = this._registeredMercenaries.keySet().iterator();
            while (i$.hasNext()) {
                int cId = (Integer)i$.next();
                if (!((FastList)this._registeredMercenaries.get((Object)cId)).contains((Object)objId)) continue;
                return true;
            }
            return false;
        }
        return ((FastList)this._registeredMercenaries.get((Object)castleId)).contains((Object)objId);
    }

    public Territory getTerritory(int castleId) {
        return (Territory)this._territoryList.get(castleId);
    }

    public FastList<Territory> getAllTerritories() {
        FastList ret = new FastList();
        for (Territory t : this._territoryList.values()) {
            if (t.getOwnerClan() == null) continue;
            ret.add((Object)t);
        }
        return ret;
    }

    public Collection<L2Clan> getRegisteredClans(int castleId) {
        return (Collection)this._registeredClans.get((Object)castleId);
    }

    public void addDisguisedPlayer(int playerObjId) {
        this._disguisedPlayers.add((Object)playerObjId);
    }

    public boolean isDisguised(int playerObjId) {
        return this._disguisedPlayers.contains((Object)playerObjId);
    }

    public Collection<Integer> getRegisteredMercenaries(int castleId) {
        return (Collection)this._registeredMercenaries.get((Object)castleId);
    }

    public long getTWStartTimeInMillis() {
        return this._startTWDate.getTimeInMillis();
    }

    public Calendar getTWStart() {
        return this._startTWDate;
    }

    public void setTWStartTimeInMillis(long time) {
        this._startTWDate.setTimeInMillis(time);
        if (this._isTWInProgress) {
            if (this._scheduledEndTWTask != null) {
                this._scheduledEndTWTask.cancel(false);
            }
            this._scheduledEndTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndTWTask(), 1000L);
        } else {
            if (this._scheduledStartTWTask != null) {
                this._scheduledStartTWTask.cancel(false);
            }
            this._scheduledStartTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartTWTask(), 1000L);
        }
    }

    public boolean isTWChannelOpen() {
        return this._isTWChannelOpen;
    }

    public void registerClan(int castleId, L2Clan clan) {
        if (clan == null || this._registeredClans.get((Object)castleId) != null && ((FastList)this._registeredClans.get((Object)castleId)).contains((Object)clan)) {
            return;
        }
        if (this._registeredClans.get((Object)castleId) == null) {
            this._registeredClans.put((Object)castleId, (Object)new FastList());
        }
        ((FastList)this._registeredClans.get((Object)castleId)).add((Object)clan);
        this.changeRegistration(castleId, clan.getId(), false);
    }

    public void registerMerc(int castleId, L2PcInstance player) {
        if (player == null || player.getLevel() < PLAYERMINLEVEL || this._registeredMercenaries.get((Object)castleId) != null && ((FastList)this._registeredMercenaries.get((Object)castleId)).contains((Object)player.getObjectId())) {
            return;
        }
        if (this._registeredMercenaries.get((Object)castleId) == null) {
            this._registeredMercenaries.put((Object)castleId, (Object)new FastList());
        }
        ((FastList)this._registeredMercenaries.get((Object)castleId)).add((Object)player.getObjectId());
        this.changeRegistration(castleId, player.getObjectId(), false);
    }

    public void removeClan(int castleId, L2Clan clan) {
        if (clan == null) {
            return;
        }
        if (this._registeredClans.get((Object)castleId) != null && ((FastList)this._registeredClans.get((Object)castleId)).contains((Object)clan)) {
            ((FastList)this._registeredClans.get((Object)castleId)).remove((Object)clan);
            this.changeRegistration(castleId, clan.getId(), true);
        }
    }

    public void removeMerc(int castleId, L2PcInstance player) {
        if (player == null) {
            return;
        }
        if (this._registeredMercenaries.get((Object)castleId) != null && ((FastList)this._registeredMercenaries.get((Object)castleId)).contains((Object)player.getObjectId())) {
            ((FastList)this._registeredMercenaries.get((Object)castleId)).remove(((FastList)this._registeredMercenaries.get((Object)castleId)).indexOf((Object)player.getObjectId()));
            this.changeRegistration(castleId, player.getObjectId(), true);
        }
    }

    public boolean getIsRegistrationOver() {
        return this._isRegistrationOver;
    }

    public boolean isTWInProgress() {
        return this._isTWInProgress;
    }

    public void territoryCatapultDestroyed(int castleId) {
        if (this._territoryList.get(castleId) != null) {
            ((Territory)this._territoryList.get(castleId)).changeNPCsSpawn(2, false);
        }
        for (L2DoorInstance door : CastleManager.getInstance().getCastleById(castleId).getDoors()) {
            door.openMe();
        }
    }

    public L2Npc addTerritoryWard(int territoryId, int newOwnerId, int oldOwnerId, boolean broadcastMessage) {
        L2Npc ret = null;
        if (this._territoryList.get(newOwnerId) != null) {
            Territory terNew = (Territory)this._territoryList.get(newOwnerId);
            TerritoryNPCSpawn ward = terNew.getFreeWardSpawnPlace();
            if (ward != null) {
                ward._npcId = territoryId;
                ret = this.spawnNPC(36491 + territoryId, ward.getLocation());
                ward.setNPC(ret);
                if (!this.isTWInProgress() && !SPAWN_WARDS_WHEN_TW_IS_NOT_IN_PROGRESS) {
                    ret.decayMe();
                }
                if (terNew.getOwnerClan() != null && terNew.getOwnedWardIds().contains((Object)(newOwnerId + 80))) {
                    Iterator i$ = terNew.getOwnedWardIds().iterator();
                    while (i$.hasNext()) {
                        int wardId = (Integer)i$.next();
                        List<L2SkillLearn> residentialSkills = SkillTreesData.getInstance().getAvailableResidentialSkills(wardId);
                        for (L2SkillLearn s : residentialSkills) {
                            L2Skill sk = SkillTable.getInstance().getInfo(s.getSkillId(), s.getSkillLevel());
                            if (sk == null) continue;
                            for (L2PcInstance member : terNew.getOwnerClan().getOnlineMembers(0)) {
                                if (member.isInOlympiadMode()) continue;
                                member.addSkill(sk, false);
                            }
                        }
                    }
                }
            }
            if (this._territoryList.containsKey(oldOwnerId)) {
                Territory terOld = (Territory)this._territoryList.get(oldOwnerId);
                terOld.removeWard(territoryId);
                this.updateTerritoryData(terOld);
                this.updateTerritoryData(terNew);
                if (broadcastMessage) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_S1_HAS_SUCCEDED_IN_CAPTURING_S2_TERRITORY_WARD);
                    sm.addString(terNew.getOwnerClan().getName());
                    sm.addCastleId(territoryId);
                    this.announceToParticipants(sm, 135000, 13500);
                }
                if (terOld.getOwnerClan() != null) {
                    List<L2SkillLearn> territorySkills = SkillTreesData.getInstance().getAvailableResidentialSkills(territoryId);
                    for (L2SkillLearn s : territorySkills) {
                        L2Skill sk = SkillTable.getInstance().getInfo(s.getSkillId(), s.getSkillLevel());
                        if (sk == null) continue;
                        for (L2PcInstance member : terOld.getOwnerClan().getOnlineMembers(0)) {
                            member.removeSkill(sk, false);
                        }
                    }
                    if (!terOld.getOwnedWardIds().isEmpty() && !terOld.getOwnedWardIds().contains((Object)(oldOwnerId + 80))) {
                        Iterator i$ = terOld.getOwnedWardIds().iterator();
                        while (i$.hasNext()) {
                            int wardId = (Integer)i$.next();
                            List<L2SkillLearn> wardSkills = SkillTreesData.getInstance().getAvailableResidentialSkills(wardId);
                            for (L2SkillLearn s : wardSkills) {
                                L2Skill sk = SkillTable.getInstance().getInfo(s.getSkillId(), s.getSkillLevel());
                                if (sk == null) continue;
                                for (L2PcInstance member : terOld.getOwnerClan().getOnlineMembers(0)) {
                                    member.removeSkill(sk, false);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            _log.warning(this.getClass().getSimpleName() + ": Missing territory for new Ward owner: " + newOwnerId + ";" + territoryId);
        }
        return ret;
    }

    public L2SiegeFlagInstance getHQForClan(L2Clan clan) {
        if (clan.getCastleId() > 0) {
            return ((Territory)this._territoryList.get(clan.getCastleId())).getHQ();
        }
        return null;
    }

    public L2SiegeFlagInstance getHQForTerritory(int territoryId) {
        if (this._territoryList.containsKey(territoryId - 80)) {
            return ((Territory)this._territoryList.get(territoryId - 80)).getHQ();
        }
        return null;
    }

    public void setHQForClan(L2Clan clan, L2SiegeFlagInstance hq) {
        if (clan.getCastleId() > 0) {
            ((Territory)this._territoryList.get(clan.getCastleId())).setHQ(hq);
        }
    }

    public void addClanFlag(L2Clan clan, L2SiegeFlagInstance flag) {
        this._clanFlags.put((Object)clan, (Object)flag);
    }

    public boolean isClanHasFlag(L2Clan clan) {
        return this._clanFlags.containsKey((Object)clan);
    }

    public L2SiegeFlagInstance getFlagForClan(L2Clan clan) {
        if (this._clanFlags.containsKey((Object)clan)) {
            return (L2SiegeFlagInstance)this._clanFlags.get((Object)clan);
        }
        return null;
    }

    public void removeClanFlag(L2Clan clan) {
        this._clanFlags.remove((Object)clan);
    }

    public List<TerritoryWard> getAllTerritoryWards() {
        return this._territoryWards;
    }

    public TerritoryWard getTerritoryWardForOwner(int castleId) {
        for (TerritoryWard twWard : this._territoryWards) {
            if (twWard.getTerritoryId() != castleId) continue;
            return twWard;
        }
        return null;
    }

    public TerritoryWard getTerritoryWard(int territoryId) {
        for (TerritoryWard twWard : this._territoryWards) {
            if (twWard.getTerritoryId() != territoryId) continue;
            return twWard;
        }
        return null;
    }

    public TerritoryWard getTerritoryWard(L2PcInstance player) {
        for (TerritoryWard twWard : this._territoryWards) {
            if (twWard.playerId != player.getObjectId()) continue;
            return twWard;
        }
        return null;
    }

    public void dropCombatFlag(L2PcInstance player, boolean isKilled, boolean isSpawnBack) {
        for (TerritoryWard twWard : this._territoryWards) {
            if (twWard.playerId != player.getObjectId()) continue;
            twWard.dropIt();
            if (this.isTWInProgress()) {
                if (isKilled) {
                    twWard.spawnMe();
                } else if (isSpawnBack) {
                    twWard.spawnBack();
                } else {
                    for (TerritoryNPCSpawn wardSpawn : ((Territory)this._territoryList.get(twWard.getOwnerCastleId())).getOwnedWard()) {
                        if (wardSpawn.getId() != twWard.getTerritoryId()) continue;
                        wardSpawn.setNPC(wardSpawn.getNpc().getSpawn().doSpawn());
                        twWard.unSpawnMe();
                        twWard.setNpc(wardSpawn.getNpc());
                    }
                }
            }
            if (!isKilled) continue;
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_CHAR_THAT_ACQUIRED_S1_WARD_HAS_BEEN_KILLED);
            sm.addCastleId(twWard.getTerritoryId());
            this.announceToParticipants(sm, 0, 0);
        }
    }

    public void giveTWQuestPoint(L2PcInstance player) {
        if (!this._participantPoints.containsKey(player.getObjectId())) {
            this._participantPoints.put(player.getObjectId(), (Object)new int[]{player.getSiegeSide(), 0, 0, 0, 0, 0, 0});
        }
        int[] nArray = (int[])this._participantPoints.get(player.getObjectId());
        nArray[2] = nArray[2] + 1;
    }

    public void giveTWPoint(L2PcInstance killer, int victimSide, int type) {
        if (victimSide == 0) {
            return;
        }
        if (killer.getParty() != null && type < 5) {
            for (L2PcInstance pl : killer.getParty().getMembers()) {
                if (pl.getSiegeSide() == victimSide || pl.getSiegeSide() == 0 || !Util.checkIfInRange(2000, killer, pl, false)) continue;
                if (!this._participantPoints.containsKey(pl.getObjectId())) {
                    this._participantPoints.put(pl.getObjectId(), (Object)new int[]{pl.getSiegeSide(), 0, 0, 0, 0, 0, 0});
                }
                int[] nArray = (int[])this._participantPoints.get(pl.getObjectId());
                int n = type;
                nArray[n] = nArray[n] + 1;
            }
        } else {
            if (killer.getSiegeSide() == victimSide || killer.getSiegeSide() == 0) {
                return;
            }
            if (!this._participantPoints.containsKey(killer.getObjectId())) {
                this._participantPoints.put(killer.getObjectId(), (Object)new int[]{killer.getSiegeSide(), 0, 0, 0, 0, 0, 0});
            }
            int[] nArray = (int[])this._participantPoints.get(killer.getObjectId());
            int n = type;
            nArray[n] = nArray[n] + 1;
        }
    }

    public int[] calcReward(L2PcInstance player) {
        if (this._participantPoints.containsKey(player.getObjectId())) {
            int[] reward = new int[2];
            int[] temp = (int[])this._participantPoints.get(player.getObjectId());
            reward[0] = temp[0];
            reward[1] = 0;
            if (temp[6] < 10) {
                return reward;
            }
            reward[1] = reward[1] + (temp[6] > 70 ? 7 : (int)((double)temp[6] * 0.1));
            reward[1] = reward[1] + temp[2] * 7;
            reward[1] = temp[1] < 50 ? (int)((double)reward[1] + (double)temp[1] * 0.1) : (temp[1] < 120 ? reward[1] + (5 + (temp[1] - 50) / 14) : reward[1] + 10);
            reward[1] = reward[1] + temp[3];
            reward[1] = reward[1] + temp[4] * 2;
            reward[1] = reward[1] + (temp[5] > 0 ? 5 : 0);
            reward[1] = reward[1] + Math.min(((Territory)this._territoryList.get(temp[0] - 80)).getQuestDone()[0], 10);
            reward[1] = reward[1] + ((Territory)this._territoryList.get(temp[0] - 80)).getQuestDone()[1];
            reward[1] = reward[1] + ((Territory)this._territoryList.get(temp[0] - 80)).getOwnedWardIds().size();
            return reward;
        }
        return new int[]{0, 0};
    }

    public void debugReward(L2PcInstance player) {
        player.sendMessage("Registred TerrId: " + player.getSiegeSide());
        if (this._participantPoints.containsKey(player.getObjectId())) {
            int[] temp = (int[])this._participantPoints.get(player.getObjectId());
            player.sendMessage("TerrId: " + temp[0]);
            player.sendMessage("PcKill: " + temp[1]);
            player.sendMessage("PcQuests: " + temp[2]);
            player.sendMessage("npcKill: " + temp[3]);
            player.sendMessage("CatatKill: " + temp[4]);
            player.sendMessage("WardKill: " + temp[5]);
            player.sendMessage("onlineTime: " + temp[6]);
        } else {
            player.sendMessage("No points for you!");
        }
        if (this._territoryList.containsKey(player.getSiegeSide() - 80)) {
            player.sendMessage("Your Territory's jobs:");
            player.sendMessage("npcKill: " + ((Territory)this._territoryList.get(player.getSiegeSide() - 80)).getQuestDone()[0]);
            player.sendMessage("WardCaptured: " + ((Territory)this._territoryList.get(player.getSiegeSide() - 80)).getQuestDone()[1]);
        }
    }

    public void resetReward(L2PcInstance player) {
        if (this._participantPoints.containsKey(player.getObjectId())) {
            ((int[])this._participantPoints.get((int)player.getObjectId()))[6] = 0;
        }
    }

    public L2Npc spawnNPC(int npcId, Location loc) {
        L2NpcTemplate template = NpcTable.getInstance().getTemplate(npcId);
        if (template != null) {
            try {
                L2Spawn spawnDat = new L2Spawn(template);
                spawnDat.setAmount(1);
                spawnDat.setX(loc.getX());
                spawnDat.setY(loc.getY());
                spawnDat.setZ(loc.getZ());
                spawnDat.setHeading(loc.getHeading());
                spawnDat.stopRespawn();
                return spawnDat.spawnOne(false);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": " + e.getMessage(), e);
            }
        } else {
            _log.warning(this.getClass().getSimpleName() + ": Data missing in NPC table for ID: " + npcId + ".");
        }
        return null;
    }

    private void changeRegistration(int castleId, int objId, boolean delete) {
        String query = delete ? DELETE : INSERT;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement(query);){
            ps.setInt(1, castleId);
            ps.setInt(2, objId);
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: Territory War registration: " + e.getMessage(), e);
        }
    }

    private void updateTerritoryData(Territory ter) {
        StringBuilder wardList = new StringBuilder(256);
        Iterator i$ = ter.getOwnedWardIds().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            wardList.append(i).append(';');
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("UPDATE territories SET ownedWardIds=? WHERE territoryId=?");){
            ps.setString(1, wardList.toString());
            ps.setInt(2, ter.getTerritoryId());
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: Territory Data update: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void load() {
        Throwable throwable;
        ResultSet rs;
        Throwable throwable2;
        Statement s;
        Throwable throwable3;
        Connection con;
        PropertiesParser territoryWarSettings = new PropertiesParser("./config/TerritoryWar.properties");
        DEFENDERMAXCLANS = territoryWarSettings.getInt("DefenderMaxClans", 500);
        DEFENDERMAXPLAYERS = territoryWarSettings.getInt("DefenderMaxPlayers", 500);
        CLANMINLEVEL = territoryWarSettings.getInt("ClanMinLevel", 0);
        PLAYERMINLEVEL = territoryWarSettings.getInt("PlayerMinLevel", 40);
        WARLENGTH = territoryWarSettings.getLong("WarLength", 120L) * 60000L;
        PLAYER_WITH_WARD_CAN_BE_KILLED_IN_PEACEZONE = territoryWarSettings.getBoolean("PlayerWithWardCanBeKilledInPeaceZone", false);
        SPAWN_WARDS_WHEN_TW_IS_NOT_IN_PROGRESS = territoryWarSettings.getBoolean("SpawnWardsWhenTWIsNotInProgress", false);
        RETURN_WARDS_WHEN_TW_STARTS = territoryWarSettings.getBoolean("ReturnWardsWhenTWStarts", false);
        MINTWBADGEFORNOBLESS = territoryWarSettings.getInt("MinTerritoryBadgeForNobless", 100);
        MINTWBADGEFORSTRIDERS = territoryWarSettings.getInt("MinTerritoryBadgeForStriders", 50);
        MINTWBADGEFORBIGSTRIDER = territoryWarSettings.getInt("MinTerritoryBadgeForBigStrider", 80);
        try {
            con = L2DatabaseFactory.getInstance().getConnectionFast();
            throwable3 = null;
            try {
                s = con.createStatement();
                throwable2 = null;
                try {
                    rs = s.executeQuery("SELECT * FROM territory_spawnlist");
                    throwable = null;
                    try {
                        block91: while (rs.next()) {
                            int castleId = rs.getInt("castleId");
                            int npcId = rs.getInt("npcId");
                            Location loc = new Location(rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getInt("heading"));
                            int spawnType = rs.getInt("spawnType");
                            if (!this._territoryList.containsKey(castleId)) {
                                this._territoryList.put(castleId, (Object)new Territory(castleId));
                            }
                            switch (spawnType) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    ((Territory)this._territoryList.get(castleId)).getSpawnList().add((Object)new TerritoryNPCSpawn(castleId, loc, npcId, spawnType, null));
                                    continue block91;
                                }
                                case 3: {
                                    ((Territory)this._territoryList.get(castleId)).addWardSpawnPlace(loc);
                                    continue block91;
                                }
                            }
                            _log.warning(this.getClass().getSimpleName() + ": Unknown npc type for " + rs.getInt("id"));
                        }
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (rs != null) {
                            if (throwable != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                }
                catch (Throwable x2) {
                    throwable2 = x2;
                    throw x2;
                }
                finally {
                    if (s != null) {
                        if (throwable2 != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                        } else {
                            s.close();
                        }
                    }
                }
            }
            catch (Throwable x2) {
                throwable3 = x2;
                throw x2;
            }
            finally {
                if (con != null) {
                    if (throwable3 != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable x2) {
                            throwable3.addSuppressed(x2);
                        }
                    } else {
                        con.close();
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": SpawnList error: " + e.getMessage(), e);
        }
        try {
            con = L2DatabaseFactory.getInstance().getConnectionFast();
            throwable3 = null;
            try {
                s = con.createStatement();
                throwable2 = null;
                try {
                    rs = s.executeQuery("SELECT * FROM territories");
                    throwable = null;
                    try {
                        while (rs.next()) {
                            int castleId = rs.getInt("castleId");
                            int fortId = rs.getInt("fortId");
                            String ownedWardIds = rs.getString("OwnedWardIds");
                            Territory t = (Territory)this._territoryList.get(castleId);
                            if (t == null) continue;
                            t._fortId = fortId;
                            if (CastleManager.getInstance().getCastleById(castleId).getOwnerId() > 0) {
                                t.setOwnerClan(ClanTable.getInstance().getClan(CastleManager.getInstance().getCastleById(castleId).getOwnerId()));
                                t.changeNPCsSpawn(0, true);
                            }
                            if (ownedWardIds.isEmpty()) continue;
                            for (String wardId : ownedWardIds.split(";")) {
                                if (Integer.parseInt(wardId) <= 0) continue;
                                this.addTerritoryWard(Integer.parseInt(wardId), castleId, 0, false);
                            }
                        }
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (rs != null) {
                            if (throwable != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                }
                catch (Throwable x2) {
                    throwable2 = x2;
                    throw x2;
                }
                finally {
                    if (s != null) {
                        if (throwable2 != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                        } else {
                            s.close();
                        }
                    }
                }
            }
            catch (Throwable x2) {
                throwable3 = x2;
                throw x2;
            }
            finally {
                if (con != null) {
                    if (throwable3 != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable x2) {
                            throwable3.addSuppressed(x2);
                        }
                    } else {
                        con.close();
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": territory list error(): " + e.getMessage(), e);
        }
        try {
            con = L2DatabaseFactory.getInstance().getConnectionFast();
            throwable3 = null;
            try {
                s = con.createStatement();
                throwable2 = null;
                try {
                    rs = s.executeQuery("SELECT * FROM territory_registrations");
                    throwable = null;
                    try {
                        while (rs.next()) {
                            int castleId = rs.getInt("castleId");
                            int registeredId = rs.getInt("registeredId");
                            if (ClanTable.getInstance().getClan(registeredId) != null) {
                                if (this._registeredClans.get((Object)castleId) == null) {
                                    this._registeredClans.put((Object)castleId, (Object)new FastList());
                                }
                                ((FastList)this._registeredClans.get((Object)castleId)).add((Object)ClanTable.getInstance().getClan(registeredId));
                                continue;
                            }
                            if (this._registeredMercenaries.get((Object)castleId) == null) {
                                this._registeredMercenaries.put((Object)castleId, (Object)new FastList());
                            }
                            ((FastList)this._registeredMercenaries.get((Object)castleId)).add((Object)registeredId);
                        }
                        return;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (rs != null) {
                            if (throwable != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (s != null) {
                        if (throwable2 != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                        } else {
                            s.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                throwable3 = throwable6;
                throw throwable6;
            }
            finally {
                if (con != null) {
                    if (throwable3 != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable x2) {
                            throwable3.addSuppressed(x2);
                        }
                    } else {
                        con.close();
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": registration list error: " + e.getMessage(), e);
        }
    }

    protected void startTerritoryWar() {
        Castle castle;
        if (this._territoryList == null) {
            _log.warning(this.getClass().getSimpleName() + ": TerritoryList is NULL!");
            return;
        }
        FastList activeTerritoryList = new FastList();
        for (Territory t : this._territoryList.values()) {
            castle = CastleManager.getInstance().getCastleById(t.getCastleId());
            if (castle != null) {
                if (castle.getOwnerId() <= 0) continue;
                activeTerritoryList.add((Object)t);
                continue;
            }
            _log.warning(this.getClass().getSimpleName() + ": Castle missing! CastleId: " + t.getCastleId());
        }
        if (activeTerritoryList.size() < 2) {
            return;
        }
        this._isTWInProgress = true;
        if (!this.updatePlayerTWStateFlags(false)) {
            return;
        }
        for (Territory t : activeTerritoryList) {
            castle = CastleManager.getInstance().getCastleById(t.getCastleId());
            Fort fort = FortManager.getInstance().getFortById(t.getFortId());
            if (castle != null) {
                t.changeNPCsSpawn(2, true);
                castle.spawnDoor();
                castle.getZone().setSiegeInstance(this);
                castle.getZone().setIsActive(true);
                castle.getZone().updateZoneStatusForCharactersInside();
            } else {
                _log.warning(this.getClass().getSimpleName() + ": Castle missing! CastleId: " + t.getCastleId());
            }
            if (fort != null) {
                t.changeNPCsSpawn(1, true);
                fort.resetDoors();
                fort.getZone().setSiegeInstance(this);
                fort.getZone().setIsActive(true);
                fort.getZone().updateZoneStatusForCharactersInside();
            } else {
                _log.warning(this.getClass().getSimpleName() + ": Fort missing! FortId: " + t.getFortId());
            }
            for (TerritoryNPCSpawn ward : t.getOwnedWard()) {
                if (ward.getNpc() == null || t.getOwnerClan() == null) continue;
                if (!ward.getNpc().isVisible()) {
                    ward.setNPC(ward.getNpc().getSpawn().doSpawn());
                }
                this._territoryWards.add((Object)new TerritoryWard(ward.getId(), ward.getLocation().getX(), ward.getLocation().getY(), ward.getLocation().getZ(), 0, ward.getId() + 13479, t.getCastleId(), ward.getNpc()));
            }
            t.getQuestDone()[0] = 0;
            t.getQuestDone()[1] = 0;
        }
        this._participantPoints.clear();
        if (RETURN_WARDS_WHEN_TW_STARTS) {
            for (TerritoryWard ward : this._territoryWards) {
                if (ward.getOwnerCastleId() == ward.getTerritoryId() - 80) continue;
                ward.unSpawnMe();
                ward.setNpc(this.addTerritoryWard(ward.getTerritoryId(), ward.getTerritoryId() - 80, ward.getOwnerCastleId(), false));
                ward.setOwnerCastleId(ward.getTerritoryId() - 80);
            }
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.TERRITORY_WAR_HAS_BEGUN);
        Announcements.getInstance().announceToAll(sm);
    }

    protected void endTerritoryWar() {
        Castle castle;
        this._isTWInProgress = false;
        if (this._territoryList == null) {
            _log.warning(this.getClass().getSimpleName() + ": TerritoryList is NULL!");
            return;
        }
        FastList activeTerritoryList = new FastList();
        for (Territory t : this._territoryList.values()) {
            castle = CastleManager.getInstance().getCastleById(t.getCastleId());
            if (castle != null) {
                if (castle.getOwnerId() <= 0) continue;
                activeTerritoryList.add((Object)t);
                continue;
            }
            _log.warning(this.getClass().getSimpleName() + ": Castle missing! CastleId: " + t.getCastleId());
        }
        if (activeTerritoryList.size() < 2) {
            return;
        }
        if (!this.updatePlayerTWStateFlags(true)) {
            return;
        }
        if (this._territoryWards != null) {
            for (TerritoryWard twWard : this._territoryWards) {
                twWard.unSpawnMe();
            }
            this._territoryWards.clear();
        }
        for (Territory t : activeTerritoryList) {
            castle = CastleManager.getInstance().getCastleById(t.getCastleId());
            Fort fort = FortManager.getInstance().getFortById(t.getFortId());
            if (castle != null) {
                castle.spawnDoor();
                t.changeNPCsSpawn(2, false);
                castle.getZone().setIsActive(false);
                castle.getZone().updateZoneStatusForCharactersInside();
                castle.getZone().setSiegeInstance(null);
            } else {
                _log.warning(this.getClass().getSimpleName() + ": Castle missing! CastleId: " + t.getCastleId());
            }
            if (fort != null) {
                t.changeNPCsSpawn(1, false);
                fort.getZone().setIsActive(false);
                fort.getZone().updateZoneStatusForCharactersInside();
                fort.getZone().setSiegeInstance(null);
            } else {
                _log.warning(this.getClass().getSimpleName() + ": Fort missing! FortId: " + t.getFortId());
            }
            if (t.getHQ() != null) {
                t.getHQ().deleteMe();
            }
            for (TerritoryNPCSpawn ward : t.getOwnedWard()) {
                if (ward.getNpc() == null) continue;
                if (!ward.getNpc().isVisible() && SPAWN_WARDS_WHEN_TW_IS_NOT_IN_PROGRESS) {
                    ward.setNPC(ward.getNpc().getSpawn().doSpawn());
                    continue;
                }
                if (!ward.getNpc().isVisible() || SPAWN_WARDS_WHEN_TW_IS_NOT_IN_PROGRESS) continue;
                ward.getNpc().decayMe();
            }
        }
        for (L2SiegeFlagInstance flag : this._clanFlags.values()) {
            flag.deleteMe();
        }
        this._clanFlags.clear();
        for (Integer castleId : this._registeredClans.keySet()) {
            for (L2Clan clan : (FastList)this._registeredClans.get((Object)castleId)) {
                this.changeRegistration(castleId, clan.getId(), true);
            }
        }
        for (Integer castleId : this._registeredMercenaries.keySet()) {
            for (Integer pl_objId : (FastList)this._registeredMercenaries.get((Object)castleId)) {
                this.changeRegistration(castleId, pl_objId, true);
            }
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.TERRITORY_WAR_HAS_ENDED);
        Announcements.getInstance().announceToAll(sm);
    }

    protected boolean updatePlayerTWStateFlags(boolean clear) {
        int castleId;
        Quest twQuest = QuestManager.getInstance().getQuest(qn);
        if (twQuest == null) {
            _log.warning(this.getClass().getSimpleName() + ": missing main Quest!");
            return false;
        }
        Iterator i$ = this._registeredClans.keySet().iterator();
        while (i$.hasNext()) {
            castleId = (Integer)i$.next();
            for (L2Clan clan : (FastList)this._registeredClans.get((Object)castleId)) {
                for (L2PcInstance player : clan.getOnlineMembers(0)) {
                    if (player == null) continue;
                    if (clear) {
                        player.setSiegeState((byte)0);
                        if (!this._isTWChannelOpen) {
                            player.setSiegeSide(0);
                        }
                    } else {
                        if (player.getLevel() < PLAYERMINLEVEL || player.getClassId().level() < 2) continue;
                        if (this._isTWInProgress) {
                            player.setSiegeState((byte)1);
                        }
                        player.setSiegeSide(80 + castleId);
                    }
                    player.broadcastUserInfo();
                }
            }
        }
        i$ = this._registeredMercenaries.keySet().iterator();
        while (i$.hasNext()) {
            castleId = (Integer)i$.next();
            Iterator i$2 = ((FastList)this._registeredMercenaries.get((Object)castleId)).iterator();
            while (i$2.hasNext()) {
                int objId = (Integer)i$2.next();
                L2PcInstance player = L2World.getInstance().getPlayer(objId);
                if (player == null) continue;
                if (clear) {
                    player.setSiegeState((byte)0);
                    if (!this._isTWChannelOpen) {
                        player.setSiegeSide(0);
                    }
                } else {
                    if (this._isTWInProgress) {
                        player.setSiegeState((byte)1);
                    }
                    player.setSiegeSide(80 + castleId);
                }
                player.broadcastUserInfo();
            }
        }
        for (Territory terr : this._territoryList.values()) {
            if (terr.getOwnerClan() == null) continue;
            for (L2PcInstance player : terr.getOwnerClan().getOnlineMembers(0)) {
                if (player == null) continue;
                if (clear) {
                    player.setSiegeState((byte)0);
                    if (!this._isTWChannelOpen) {
                        player.setSiegeSide(0);
                    }
                } else {
                    if (player.getLevel() < PLAYERMINLEVEL || player.getClassId().level() < 2) continue;
                    if (this._isTWInProgress) {
                        player.setSiegeState((byte)1);
                    }
                    player.setSiegeSide(80 + terr.getCastleId());
                }
                player.broadcastUserInfo();
            }
        }
        twQuest.setOnEnterWorld(this._isTWInProgress);
        return true;
    }

    public void announceToParticipants(L2GameServerPacket sm, int exp, int sp) {
        for (Territory ter : this._territoryList.values()) {
            if (ter.getOwnerClan() == null) continue;
            for (L2PcInstance member : ter.getOwnerClan().getOnlineMembers(0)) {
                member.sendPacket(sm);
                if (exp <= 0 && sp <= 0) continue;
                member.addExpAndSp(exp, sp);
            }
        }
        for (FastList list : this._registeredClans.values()) {
            for (L2Clan c : list) {
                for (L2PcInstance member : c.getOnlineMembers(0)) {
                    member.sendPacket(sm);
                    if (exp <= 0 && sp <= 0) continue;
                    member.addExpAndSp(exp, sp);
                }
            }
        }
        for (FastList list : this._registeredMercenaries.values()) {
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                int objId = (Integer)i$.next();
                L2PcInstance player = L2World.getInstance().getPlayer(objId);
                if (player == null || player.getClan() != null && this.checkIsRegistered(-1, player.getClan())) continue;
                player.sendPacket(sm);
                if (exp <= 0 && sp <= 0) continue;
                player.addExpAndSp(exp, sp);
            }
        }
    }

    @Override
    public void startSiege() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void endSiege() {
        throw new UnsupportedOperationException();
    }

    @Override
    public L2SiegeClan getAttackerClan(int clanId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public L2SiegeClan getAttackerClan(L2Clan clan) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<L2SiegeClan> getAttackerClans() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<L2PcInstance> getAttackersInZone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean checkIsAttacker(L2Clan clan) {
        throw new UnsupportedOperationException();
    }

    @Override
    public L2SiegeClan getDefenderClan(int clanId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public L2SiegeClan getDefenderClan(L2Clan clan) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<L2SiegeClan> getDefenderClans() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean checkIsDefender(L2Clan clan) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<L2Npc> getFlag(L2Clan clan) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Calendar getSiegeDate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean giveFame() {
        return true;
    }

    @Override
    public int getFameFrequency() {
        return Config.CASTLE_ZONE_FAME_TASK_FREQUENCY;
    }

    @Override
    public int getFameAmount() {
        return Config.CASTLE_ZONE_FAME_AQUIRE_POINTS;
    }

    @Override
    public void updateSiege() {
    }

    public static final TerritoryWarManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final TerritoryWarManager _instance = new TerritoryWarManager();

        private SingletonHolder() {
        }
    }

    public class Territory {
        private final Logger _log = Logger.getLogger(Territory.class.getName());
        private final int _territoryId;
        private final int _castleId;
        protected int _fortId;
        private L2Clan _ownerClan;
        private final FastList<TerritoryNPCSpawn> _spawnList;
        private final TerritoryNPCSpawn[] _territoryWardSpawnPlaces;
        private boolean _isInProgress = false;
        private L2SiegeFlagInstance _territoryHQ = null;
        private final int[] _questDone;

        public Territory(int castleId) {
            this._castleId = castleId;
            this._territoryId = castleId + 80;
            this._spawnList = new FastList();
            this._territoryWardSpawnPlaces = new TerritoryNPCSpawn[9];
            this._questDone = new int[2];
        }

        protected void addWardSpawnPlace(Location loc) {
            for (int i = 0; i < this._territoryWardSpawnPlaces.length; ++i) {
                if (this._territoryWardSpawnPlaces[i] != null) continue;
                this._territoryWardSpawnPlaces[i] = new TerritoryNPCSpawn(this._castleId, loc, 0, 4, null);
                return;
            }
        }

        protected TerritoryNPCSpawn getFreeWardSpawnPlace() {
            for (TerritoryNPCSpawn _territoryWardSpawnPlace : this._territoryWardSpawnPlaces) {
                if (_territoryWardSpawnPlace == null || _territoryWardSpawnPlace.getNpc() != null) continue;
                return _territoryWardSpawnPlace;
            }
            this._log.log(Level.WARNING, this.getClass().getSimpleName() + ": no free Ward spawn found for territory: " + this._territoryId);
            for (int i = 0; i < this._territoryWardSpawnPlaces.length; ++i) {
                if (this._territoryWardSpawnPlaces[i] == null) {
                    this._log.log(Level.WARNING, this.getClass().getSimpleName() + ": territory ward spawn place " + i + " is null!");
                    continue;
                }
                if (this._territoryWardSpawnPlaces[i].getNpc() != null) {
                    this._log.log(Level.WARNING, this.getClass().getSimpleName() + ": territory ward spawn place " + i + " has npc name: " + this._territoryWardSpawnPlaces[i].getNpc().getName());
                    continue;
                }
                this._log.log(Level.WARNING, this.getClass().getSimpleName() + ": territory ward spawn place " + i + " is empty!");
            }
            return null;
        }

        public FastList<TerritoryNPCSpawn> getSpawnList() {
            return this._spawnList;
        }

        protected void changeNPCsSpawn(int type, boolean isSpawn) {
            if (type < 0 || type > 3) {
                this._log.log(Level.WARNING, this.getClass().getSimpleName() + ": wrong type(" + type + ") for NPCs spawn change!");
                return;
            }
            for (TerritoryNPCSpawn twSpawn : this._spawnList) {
                if (twSpawn.getType() != type) continue;
                if (isSpawn) {
                    twSpawn.setNPC(TerritoryWarManager.this.spawnNPC(twSpawn.getId(), twSpawn.getLocation()));
                    continue;
                }
                L2Npc npc = twSpawn.getNpc();
                if (npc != null && !npc.isDead()) {
                    npc.deleteMe();
                }
                twSpawn.setNPC(null);
            }
        }

        protected void removeWard(int wardId) {
            for (TerritoryNPCSpawn wardSpawn : this._territoryWardSpawnPlaces) {
                if (wardSpawn.getId() != wardId) continue;
                wardSpawn.getNpc().deleteMe();
                wardSpawn.setNPC(null);
                wardSpawn._npcId = 0;
                return;
            }
            this._log.log(Level.WARNING, this.getClass().getSimpleName() + ": Can't delete wardId: " + wardId + " for territory: " + this._territoryId);
        }

        public int getTerritoryId() {
            return this._territoryId;
        }

        public int getCastleId() {
            return this._castleId;
        }

        public int getFortId() {
            return this._fortId;
        }

        public L2Clan getOwnerClan() {
            return this._ownerClan;
        }

        public void setOwnerClan(L2Clan newOwner) {
            this._ownerClan = newOwner;
        }

        public void setHQ(L2SiegeFlagInstance hq) {
            this._territoryHQ = hq;
        }

        public L2SiegeFlagInstance getHQ() {
            return this._territoryHQ;
        }

        public TerritoryNPCSpawn[] getOwnedWard() {
            return this._territoryWardSpawnPlaces;
        }

        public int[] getQuestDone() {
            return this._questDone;
        }

        public FastList<Integer> getOwnedWardIds() {
            FastList ret = new FastList();
            for (TerritoryNPCSpawn wardSpawn : this._territoryWardSpawnPlaces) {
                if (wardSpawn.getId() <= 0) continue;
                ret.add((Object)wardSpawn.getId());
            }
            return ret;
        }

        public boolean getIsInProgress() {
            return this._isInProgress;
        }

        public void setIsInProgress(boolean val) {
            this._isInProgress = val;
        }
    }

    public static class TerritoryNPCSpawn
    implements IIdentifiable {
        private final Location _location;
        protected int _npcId;
        private final int _castleId;
        private final int _type;
        private L2Npc _npc;

        public TerritoryNPCSpawn(int castle_id, Location loc, int npc_id, int type, L2Npc npc) {
            this._castleId = castle_id;
            this._location = loc;
            this._npcId = npc_id;
            this._type = type;
            this._npc = npc;
        }

        public int getCastleId() {
            return this._castleId;
        }

        @Override
        public int getId() {
            return this._npcId;
        }

        public int getNpcId() {
            return this.getId();
        }

        public int getType() {
            return this._type;
        }

        public void setNPC(L2Npc npc) {
            if (this._npc != null) {
                this._npc.deleteMe();
            }
            this._npc = npc;
        }

        public L2Npc getNpc() {
            return this._npc;
        }

        public Location getLocation() {
            return this._location;
        }
    }

    private class closeTerritoryChannelTask
    implements Runnable {
        @Override
        public void run() {
            TerritoryWarManager.this._isTWChannelOpen = false;
            TerritoryWarManager.this._disguisedPlayers.clear();
            TerritoryWarManager.this.updatePlayerTWStateFlags(true);
        }
    }

    private class ScheduleEndTWTask
    implements Runnable {
        private final Logger _log = Logger.getLogger(ScheduleEndTWTask.class.getName());

        protected ScheduleEndTWTask() {
        }

        @Override
        public void run() {
            try {
                TerritoryWarManager.this._scheduledEndTWTask.cancel(false);
                long timeRemaining = TerritoryWarManager.this._startTWDate.getTimeInMillis() + WARLENGTH - System.currentTimeMillis();
                if (timeRemaining > 3600000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_TERRITORY_WAR_WILL_END_IN_S1_HOURS);
                    sm.addNumber(2);
                    TerritoryWarManager.this.announceToParticipants(sm, 0, 0);
                    TerritoryWarManager.this._scheduledEndTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndTWTask(), timeRemaining - 3600000L);
                } else if (timeRemaining <= 3600000L && timeRemaining > 600000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_TERRITORY_WAR_WILL_END_IN_S1_MINUTES);
                    sm.addNumber((int)(timeRemaining / 60000L));
                    TerritoryWarManager.this.announceToParticipants(sm, 0, 0);
                    TerritoryWarManager.this._scheduledEndTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndTWTask(), timeRemaining - 600000L);
                } else if (timeRemaining <= 600000L && timeRemaining > 300000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_TERRITORY_WAR_WILL_END_IN_S1_MINUTES);
                    sm.addNumber((int)(timeRemaining / 60000L));
                    TerritoryWarManager.this.announceToParticipants(sm, 0, 0);
                    TerritoryWarManager.this._scheduledEndTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndTWTask(), timeRemaining - 300000L);
                } else if (timeRemaining <= 300000L && timeRemaining > 10000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_TERRITORY_WAR_WILL_END_IN_S1_MINUTES);
                    sm.addNumber((int)(timeRemaining / 60000L));
                    TerritoryWarManager.this.announceToParticipants(sm, 0, 0);
                    TerritoryWarManager.this._scheduledEndTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndTWTask(), timeRemaining - 10000L);
                } else if (timeRemaining <= 10000L && timeRemaining > 0L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_SECONDS_TO_THE_END_OF_TERRITORY_WAR);
                    sm.addNumber((int)(timeRemaining / 1000L));
                    TerritoryWarManager.this.announceToParticipants(sm, 0, 0);
                    TerritoryWarManager.this._scheduledEndTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndTWTask(), timeRemaining);
                } else {
                    TerritoryWarManager.this.endTerritoryWar();
                    ThreadPoolManager.getInstance().scheduleGeneral(new closeTerritoryChannelTask(), 600000L);
                }
            }
            catch (Exception e) {
                this._log.log(Level.SEVERE, "", e);
            }
        }
    }

    protected class ScheduleStartTWTask
    implements Runnable {
        private final Logger _log = Logger.getLogger(ScheduleStartTWTask.class.getName());

        protected ScheduleStartTWTask() {
        }

        @Override
        public void run() {
            TerritoryWarManager.this._scheduledStartTWTask.cancel(false);
            try {
                long timeRemaining = TerritoryWarManager.this._startTWDate.getTimeInMillis() - System.currentTimeMillis();
                if (timeRemaining > 0x6DDD00L) {
                    TerritoryWarManager.this._isRegistrationOver = false;
                    TerritoryWarManager.this._scheduledStartTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartTWTask(), timeRemaining - 0x6DDD00L);
                } else if (timeRemaining <= 0x6DDD00L && timeRemaining > 1200000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_TERRITORY_WAR_REGISTERING_PERIOD_ENDED);
                    Announcements.getInstance().announceToAll(sm);
                    TerritoryWarManager.this._isRegistrationOver = true;
                    TerritoryWarManager.this._scheduledStartTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartTWTask(), timeRemaining - 1200000L);
                } else if (timeRemaining <= 1200000L && timeRemaining > 600000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.TERRITORY_WAR_BEGINS_IN_20_MINUTES);
                    Announcements.getInstance().announceToAll(sm);
                    TerritoryWarManager.this._isTWChannelOpen = true;
                    TerritoryWarManager.this._isRegistrationOver = true;
                    TerritoryWarManager.this.updatePlayerTWStateFlags(false);
                    TerritoryWarManager.this._scheduledStartTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartTWTask(), timeRemaining - 600000L);
                } else if (timeRemaining <= 600000L && timeRemaining > 300000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.TERRITORY_WAR_BEGINS_IN_10_MINUTES);
                    Announcements.getInstance().announceToAll(sm);
                    TerritoryWarManager.this._isTWChannelOpen = true;
                    TerritoryWarManager.this._isRegistrationOver = true;
                    TerritoryWarManager.this.updatePlayerTWStateFlags(false);
                    TerritoryWarManager.this._scheduledStartTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartTWTask(), timeRemaining - 300000L);
                } else if (timeRemaining <= 300000L && timeRemaining > 60000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.TERRITORY_WAR_BEGINS_IN_5_MINUTES);
                    Announcements.getInstance().announceToAll(sm);
                    TerritoryWarManager.this._isTWChannelOpen = true;
                    TerritoryWarManager.this._isRegistrationOver = true;
                    TerritoryWarManager.this.updatePlayerTWStateFlags(false);
                    TerritoryWarManager.this._scheduledStartTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartTWTask(), timeRemaining - 60000L);
                } else if (timeRemaining <= 60000L && timeRemaining > 0L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.TERRITORY_WAR_BEGINS_IN_1_MINUTE);
                    Announcements.getInstance().announceToAll(sm);
                    TerritoryWarManager.this._isTWChannelOpen = true;
                    TerritoryWarManager.this._isRegistrationOver = true;
                    TerritoryWarManager.this.updatePlayerTWStateFlags(false);
                    TerritoryWarManager.this._scheduledStartTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartTWTask(), timeRemaining);
                } else if (timeRemaining + WARLENGTH > 0L) {
                    TerritoryWarManager.this._isTWChannelOpen = true;
                    TerritoryWarManager.this._isRegistrationOver = true;
                    TerritoryWarManager.this.startTerritoryWar();
                    TerritoryWarManager.this._scheduledEndTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndTWTask(), 1000L);
                    TerritoryWarManager.this._scheduledRewardOnlineTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new RewardOnlineParticipants(), 60000L, 60000L);
                }
            }
            catch (Exception e) {
                this._log.log(Level.SEVERE, "", e);
            }
        }
    }

    protected class RewardOnlineParticipants
    implements Runnable {
        protected RewardOnlineParticipants() {
        }

        @Override
        public void run() {
            if (TerritoryWarManager.this.isTWInProgress()) {
                for (L2PcInstance player : L2World.getInstance().getPlayers()) {
                    if (player == null || player.getSiegeSide() <= 0) continue;
                    TerritoryWarManager.this.giveTWPoint(player, 1000, 6);
                }
            } else {
                TerritoryWarManager.this._scheduledRewardOnlineTask.cancel(false);
            }
        }
    }
}

