/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class L2ClanMember {
    private static final Logger _log = Logger.getLogger(L2ClanMember.class.getName());
    private final L2Clan _clan;
    private int _objectId;
    private String _name;
    private String _title;
    private int _powerGrade;
    private int _level;
    private int _classId;
    private boolean _sex;
    private int _raceOrdinal;
    private L2PcInstance _player;
    private int _pledgeType;
    private int _apprentice;
    private int _sponsor;

    public L2ClanMember(L2Clan clan, ResultSet clanMember) throws SQLException {
        if (clan == null) {
            throw new IllegalArgumentException("Cannot create a Clan Member with a null clan.");
        }
        this._clan = clan;
        this._name = clanMember.getString("char_name");
        this._level = clanMember.getInt("level");
        this._classId = clanMember.getInt("classid");
        this._objectId = clanMember.getInt("charId");
        this._pledgeType = clanMember.getInt("subpledge");
        this._title = clanMember.getString("title");
        this._powerGrade = clanMember.getInt("power_grade");
        this._apprentice = clanMember.getInt("apprentice");
        this._sponsor = clanMember.getInt("sponsor");
        this._sex = clanMember.getInt("sex") != 0;
        this._raceOrdinal = clanMember.getInt("race");
    }

    public L2ClanMember(L2Clan clan, L2PcInstance player) {
        if (clan == null) {
            throw new IllegalArgumentException("Cannot create a Clan Member if player has a null clan.");
        }
        this._player = player;
        this._clan = clan;
        this._name = player.getName();
        this._level = player.getLevel();
        this._classId = player.getClassId().getId();
        this._objectId = player.getObjectId();
        this._pledgeType = player.getPledgeType();
        this._powerGrade = player.getPowerGrade();
        this._title = player.getTitle();
        this._sponsor = 0;
        this._apprentice = 0;
        this._sex = player.getAppearance().getSex();
        this._raceOrdinal = player.getRace().ordinal();
    }

    public void setPlayerInstance(L2PcInstance player) {
        if (player == null && this._player != null) {
            this._name = this._player.getName();
            this._level = this._player.getLevel();
            this._classId = this._player.getClassId().getId();
            this._objectId = this._player.getObjectId();
            this._powerGrade = this._player.getPowerGrade();
            this._pledgeType = this._player.getPledgeType();
            this._title = this._player.getTitle();
            this._apprentice = this._player.getApprentice();
            this._sponsor = this._player.getSponsor();
            this._sex = this._player.getAppearance().getSex();
            this._raceOrdinal = this._player.getRace().ordinal();
        }
        if (player != null) {
            this._clan.addSkillEffects(player);
            if (this._clan.getLevel() > 3 && player.isClanLeader()) {
                SiegeManager.getInstance().addSiegeSkills(player);
            }
            if (player.isClanLeader()) {
                this._clan.setLeader(this);
            }
        }
        this._player = player;
    }

    public L2PcInstance getPlayerInstance() {
        return this._player;
    }

    public boolean isOnline() {
        if (this._player == null || !this._player.isOnline()) {
            return false;
        }
        if (this._player.getClient() == null) {
            return false;
        }
        return !this._player.getClient().isDetached();
    }

    public int getClassId() {
        if (this._player != null) {
            return this._player.getClassId().getId();
        }
        return this._classId;
    }

    public int getLevel() {
        if (this._player != null) {
            return this._player.getLevel();
        }
        return this._level;
    }

    public String getName() {
        if (this._player != null) {
            return this._player.getName();
        }
        return this._name;
    }

    public int getObjectId() {
        if (this._player != null) {
            return this._player.getObjectId();
        }
        return this._objectId;
    }

    public String getTitle() {
        if (this._player != null) {
            return this._player.getTitle();
        }
        return this._title;
    }

    public int getPledgeType() {
        if (this._player != null) {
            return this._player.getPledgeType();
        }
        return this._pledgeType;
    }

    public void setPledgeType(int pledgeType) {
        this._pledgeType = pledgeType;
        if (this._player != null) {
            this._player.setPledgeType(pledgeType);
        } else {
            this.updatePledgeType();
        }
    }

    public void updatePledgeType() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("UPDATE characters SET subpledge=? WHERE charId=?");){
            ps.setLong(1, this._pledgeType);
            ps.setInt(2, this.getObjectId());
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not update pledge type: " + e.getMessage(), e);
        }
    }

    public int getPowerGrade() {
        if (this._player != null) {
            return this._player.getPowerGrade();
        }
        return this._powerGrade;
    }

    public void setPowerGrade(int powerGrade) {
        this._powerGrade = powerGrade;
        if (this._player != null) {
            this._player.setPowerGrade(powerGrade);
        } else {
            this.updatePowerGrade();
        }
    }

    public void updatePowerGrade() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("UPDATE characters SET power_grade=? WHERE charId=?");){
            ps.setLong(1, this._powerGrade);
            ps.setInt(2, this.getObjectId());
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not update power _grade: " + e.getMessage(), e);
        }
    }

    public void setApprenticeAndSponsor(int apprenticeID, int sponsorID) {
        this._apprentice = apprenticeID;
        this._sponsor = sponsorID;
    }

    public int getRaceOrdinal() {
        if (this._player != null) {
            return this._player.getRace().ordinal();
        }
        return this._raceOrdinal;
    }

    public boolean getSex() {
        if (this._player != null) {
            return this._player.getAppearance().getSex();
        }
        return this._sex;
    }

    public int getSponsor() {
        if (this._player != null) {
            return this._player.getSponsor();
        }
        return this._sponsor;
    }

    public int getApprentice() {
        if (this._player != null) {
            return this._player.getApprentice();
        }
        return this._apprentice;
    }

    public String getApprenticeOrSponsorName() {
        if (this._player != null) {
            this._apprentice = this._player.getApprentice();
            this._sponsor = this._player.getSponsor();
        }
        if (this._apprentice != 0) {
            L2ClanMember apprentice = this._clan.getClanMember(this._apprentice);
            if (apprentice != null) {
                return apprentice.getName();
            }
            return "Error";
        }
        if (this._sponsor != 0) {
            L2ClanMember sponsor = this._clan.getClanMember(this._sponsor);
            if (sponsor != null) {
                return sponsor.getName();
            }
            return "Error";
        }
        return "";
    }

    public L2Clan getClan() {
        return this._clan;
    }

    public static int calculatePledgeClass(L2PcInstance player) {
        int pledgeClass = 0;
        if (player == null) {
            return pledgeClass;
        }
        L2Clan clan = player.getClan();
        if (clan != null) {
            switch (clan.getLevel()) {
                case 4: {
                    if (!player.isClanLeader()) break;
                    pledgeClass = 3;
                    break;
                }
                case 5: {
                    if (player.isClanLeader()) {
                        pledgeClass = 4;
                        break;
                    }
                    pledgeClass = 2;
                    break;
                }
                case 6: {
                    block10 : switch (player.getPledgeType()) {
                        case -1: {
                            pledgeClass = 1;
                            break;
                        }
                        case 100: 
                        case 200: {
                            pledgeClass = 2;
                            break;
                        }
                        case 0: {
                            if (player.isClanLeader()) {
                                pledgeClass = 5;
                                break;
                            }
                            switch (clan.getLeaderSubPledge(player.getObjectId())) {
                                case 100: 
                                case 200: {
                                    pledgeClass = 4;
                                    break block10;
                                }
                            }
                            pledgeClass = 3;
                        }
                    }
                    break;
                }
                case 7: {
                    block18 : switch (player.getPledgeType()) {
                        case -1: {
                            pledgeClass = 1;
                            break;
                        }
                        case 100: 
                        case 200: {
                            pledgeClass = 3;
                            break;
                        }
                        case 1001: 
                        case 1002: 
                        case 2001: 
                        case 2002: {
                            pledgeClass = 2;
                            break;
                        }
                        case 0: {
                            if (player.isClanLeader()) {
                                pledgeClass = 7;
                                break;
                            }
                            switch (clan.getLeaderSubPledge(player.getObjectId())) {
                                case 100: 
                                case 200: {
                                    pledgeClass = 6;
                                    break block18;
                                }
                                case 1001: 
                                case 1002: 
                                case 2001: 
                                case 2002: {
                                    pledgeClass = 5;
                                    break block18;
                                }
                            }
                            pledgeClass = 4;
                        }
                    }
                    break;
                }
                case 8: {
                    block28 : switch (player.getPledgeType()) {
                        case -1: {
                            pledgeClass = 1;
                            break;
                        }
                        case 100: 
                        case 200: {
                            pledgeClass = 4;
                            break;
                        }
                        case 1001: 
                        case 1002: 
                        case 2001: 
                        case 2002: {
                            pledgeClass = 3;
                            break;
                        }
                        case 0: {
                            if (player.isClanLeader()) {
                                pledgeClass = 8;
                                break;
                            }
                            switch (clan.getLeaderSubPledge(player.getObjectId())) {
                                case 100: 
                                case 200: {
                                    pledgeClass = 7;
                                    break block28;
                                }
                                case 1001: 
                                case 1002: 
                                case 2001: 
                                case 2002: {
                                    pledgeClass = 6;
                                    break block28;
                                }
                            }
                            pledgeClass = 5;
                        }
                    }
                    break;
                }
                case 9: {
                    block38 : switch (player.getPledgeType()) {
                        case -1: {
                            pledgeClass = 1;
                            break;
                        }
                        case 100: 
                        case 200: {
                            pledgeClass = 5;
                            break;
                        }
                        case 1001: 
                        case 1002: 
                        case 2001: 
                        case 2002: {
                            pledgeClass = 4;
                            break;
                        }
                        case 0: {
                            if (player.isClanLeader()) {
                                pledgeClass = 9;
                                break;
                            }
                            switch (clan.getLeaderSubPledge(player.getObjectId())) {
                                case 100: 
                                case 200: {
                                    pledgeClass = 8;
                                    break block38;
                                }
                                case 1001: 
                                case 1002: 
                                case 2001: 
                                case 2002: {
                                    pledgeClass = 7;
                                    break block38;
                                }
                            }
                            pledgeClass = 6;
                        }
                    }
                    break;
                }
                case 10: {
                    block48 : switch (player.getPledgeType()) {
                        case -1: {
                            pledgeClass = 1;
                            break;
                        }
                        case 100: 
                        case 200: {
                            pledgeClass = 6;
                            break;
                        }
                        case 1001: 
                        case 1002: 
                        case 2001: 
                        case 2002: {
                            pledgeClass = 5;
                            break;
                        }
                        case 0: {
                            if (player.isClanLeader()) {
                                pledgeClass = 10;
                                break;
                            }
                            switch (clan.getLeaderSubPledge(player.getObjectId())) {
                                case 100: 
                                case 200: {
                                    pledgeClass = 9;
                                    break block48;
                                }
                                case 1001: 
                                case 1002: 
                                case 2001: 
                                case 2002: {
                                    pledgeClass = 8;
                                    break block48;
                                }
                            }
                            pledgeClass = 7;
                        }
                    }
                    break;
                }
                case 11: {
                    block58 : switch (player.getPledgeType()) {
                        case -1: {
                            pledgeClass = 1;
                            break;
                        }
                        case 100: 
                        case 200: {
                            pledgeClass = 7;
                            break;
                        }
                        case 1001: 
                        case 1002: 
                        case 2001: 
                        case 2002: {
                            pledgeClass = 6;
                            break;
                        }
                        case 0: {
                            if (player.isClanLeader()) {
                                pledgeClass = 11;
                                break;
                            }
                            switch (clan.getLeaderSubPledge(player.getObjectId())) {
                                case 100: 
                                case 200: {
                                    pledgeClass = 10;
                                    break block58;
                                }
                                case 1001: 
                                case 1002: 
                                case 2001: 
                                case 2002: {
                                    pledgeClass = 9;
                                    break block58;
                                }
                            }
                            pledgeClass = 8;
                        }
                    }
                    break;
                }
                default: {
                    pledgeClass = 1;
                }
            }
        }
        if (player.isNoble() && pledgeClass < 5) {
            pledgeClass = 5;
        }
        if (player.isHero() && pledgeClass < 8) {
            pledgeClass = 8;
        }
        return pledgeClass;
    }

    public void saveApprenticeAndSponsor(int apprentice, int sponsor) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("UPDATE characters SET apprentice=?,sponsor=? WHERE charId=?");){
            ps.setInt(1, apprentice);
            ps.setInt(2, sponsor);
            ps.setInt(3, this.getObjectId());
            ps.execute();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Could not save apprentice/sponsor: " + e.getMessage(), e);
        }
    }
}

