/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.datatables.EnchantSkillGroupsData;
import com.l2jserver.gameserver.model.L2EnchantSkillGroup;
import gnu.trove.map.hash.TIntIntHashMap;

public final class L2EnchantSkillLearn {
    private final int _id;
    private final int _baseLvl;
    private final TIntIntHashMap _enchantRoutes = new TIntIntHashMap();

    public L2EnchantSkillLearn(int id, int baseLvl) {
        this._id = id;
        this._baseLvl = baseLvl;
    }

    public void addNewEnchantRoute(int route, int group) {
        this._enchantRoutes.put(route, group);
    }

    public int getId() {
        return this._id;
    }

    public int getBaseLevel() {
        return this._baseLvl;
    }

    public static int getEnchantRoute(int level) {
        return (int)Math.floor(level / 100);
    }

    public static int getEnchantIndex(int level) {
        return level % 100 - 1;
    }

    public static int getEnchantType(int level) {
        return (level - 1) / 100 - 1;
    }

    public L2EnchantSkillGroup getFirstRouteGroup() {
        return EnchantSkillGroupsData.getInstance().getEnchantSkillGroupById(this._enchantRoutes.values()[0]);
    }

    public int[] getAllRoutes() {
        return this._enchantRoutes.keys();
    }

    public int getMinSkillLevel(int level) {
        if (level % 100 == 1) {
            return this._baseLvl;
        }
        return level - 1;
    }

    public boolean isMaxEnchant(int level) {
        int enchantType = L2EnchantSkillLearn.getEnchantRoute(level);
        if (enchantType < 1 || !this._enchantRoutes.contains(enchantType)) {
            return false;
        }
        int index = L2EnchantSkillLearn.getEnchantIndex(level);
        return index + 1 >= EnchantSkillGroupsData.getInstance().getEnchantSkillGroupById(this._enchantRoutes.get(enchantType)).getEnchantGroupDetails().size();
    }

    public L2EnchantSkillGroup.EnchantSkillHolder getEnchantSkillHolder(int level) {
        int enchantType = L2EnchantSkillLearn.getEnchantRoute(level);
        if (enchantType < 1 || !this._enchantRoutes.contains(enchantType)) {
            return null;
        }
        int index = L2EnchantSkillLearn.getEnchantIndex(level);
        L2EnchantSkillGroup group = EnchantSkillGroupsData.getInstance().getEnchantSkillGroupById(this._enchantRoutes.get(enchantType));
        if (index < 0) {
            return group.getEnchantGroupDetails().get(0);
        }
        if (index >= group.getEnchantGroupDetails().size()) {
            return group.getEnchantGroupDetails().get(EnchantSkillGroupsData.getInstance().getEnchantSkillGroupById(this._enchantRoutes.get(enchantType)).getEnchantGroupDetails().size() - 1);
        }
        return group.getEnchantGroupDetails().get(index);
    }
}

