/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.interfaces.IParserAdvUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class StatsSet
implements IParserAdvUtils {
    private static final Logger _log = Logger.getLogger(StatsSet.class.getName());
    private final Map<String, Object> _set;

    public StatsSet() {
        this((Map<String, Object>)new FastMap());
    }

    public StatsSet(Map<String, Object> map) {
        this._set = map;
    }

    public final Map<String, Object> getSet() {
        return this._set;
    }

    public void add(StatsSet newSet) {
        Map<String, Object> newMap = newSet.getSet();
        for (Map.Entry<String, Object> entry : newMap.entrySet()) {
            this._set.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean getBoolean(String key) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Boolean value required, but not specified");
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        try {
            return Boolean.parseBoolean((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Boolean value required, but found: " + val);
        }
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        try {
            return Boolean.parseBoolean((String)val);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public byte getByte(String key) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Byte value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        try {
            return Byte.parseByte((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Byte value required, but found: " + val);
        }
    }

    @Override
    public byte getByte(String key, byte defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        try {
            return Byte.parseByte((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Byte value required, but found: " + val);
        }
    }

    public byte[] getByteArray(String key, String splitOn) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Byte value required, but not specified");
        }
        if (val instanceof Number) {
            byte[] result = new byte[]{((Number)val).byteValue()};
            return result;
        }
        int c = 0;
        String[] vals = ((String)val).split(splitOn);
        byte[] result = new byte[vals.length];
        for (String v : vals) {
            try {
                result[c++] = Byte.parseByte(v);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Byte value required, but found: " + val);
            }
        }
        return result;
    }

    public List<Byte> getByteList(String key, String splitOn) {
        ArrayList<Byte> result = new ArrayList<Byte>();
        byte[] arr$ = this.getByteArray(key, splitOn);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Byte i = arr$[i$];
            result.add(i);
        }
        return result;
    }

    @Override
    public short getShort(String key) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Short value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).shortValue();
        }
        try {
            return Short.parseShort((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Short value required, but found: " + val);
        }
    }

    @Override
    public short getShort(String key, short defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).shortValue();
        }
        try {
            return Short.parseShort((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Short value required, but found: " + val);
        }
    }

    @Override
    public int getInt(String key) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Integer value required, but not specified: " + key + "!");
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        try {
            return Integer.parseInt((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Integer value required, but found: " + val + "!");
        }
    }

    @Override
    public int getInt(String key, int defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        try {
            return Integer.parseInt((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Integer value required, but found: " + val);
        }
    }

    public int[] getIntArray(String key, String splitOn) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Integer value required, but not specified");
        }
        if (val instanceof Number) {
            int[] result = new int[]{((Number)val).intValue()};
            return result;
        }
        int c = 0;
        String[] vals = ((String)val).split(splitOn);
        int[] result = new int[vals.length];
        for (String v : vals) {
            try {
                result[c++] = Integer.parseInt(v);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Integer value required, but found: " + val);
            }
        }
        return result;
    }

    public List<Integer> getIntegerList(String key, String splitOn) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i : this.getIntArray(key, splitOn)) {
            result.add(i);
        }
        return result;
    }

    @Override
    public long getLong(String key) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Integer value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        try {
            return Long.parseLong((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Integer value required, but found: " + val);
        }
    }

    @Override
    public long getLong(String key, long defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        try {
            return Long.parseLong((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Integer value required, but found: " + val);
        }
    }

    @Override
    public float getFloat(String key) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Float value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        try {
            return (float)Double.parseDouble((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + val);
        }
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        try {
            return (float)Double.parseDouble((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + val);
        }
    }

    @Override
    public double getDouble(String key) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Float value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        try {
            return Double.parseDouble((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + val);
        }
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        try {
            return Double.parseDouble((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + val);
        }
    }

    @Override
    public String getString(String key) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("String value \"" + key + "\" required, but not specified");
        }
        return String.valueOf(val);
    }

    @Override
    public String getString(String key, String defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        return String.valueOf(val);
    }

    @Override
    public <T extends Enum<T>> T getEnum(String key, Class<T> enumClass) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("getEnum(\"" + key + "\"," + enumClass.getSimpleName() + "):  <set name=\"" + key + "\" val=\"...\" /> \u306e\u8a18\u8ff0\u304c\u7121\u3044\u3002" + this.dump());
        }
        if (enumClass.isInstance(val)) {
            return (T)((Enum)val);
        }
        try {
            return Enum.valueOf(enumClass, String.valueOf(val));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("getEnum(\"" + key + "\"," + enumClass.getSimpleName() + "):  <set name=\"" + key + "\" val=\"" + val + "\" /> \u306e" + val + "\u306f\u7121\u52b9\u306a\u5024\u3002" + this.dump());
        }
    }

    private String dump() {
        if (this._set.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(256).append("\n _set = {\n");
        for (Map.Entry<String, Object> i : this._set.entrySet()) {
            sb.append("    {").append(i.getKey()).append("=>").append(i.getValue()).append("},\n");
        }
        sb.append(" };");
        return sb.toString();
    }

    @Override
    public <T extends Enum<T>> T getEnum(String key, Class<T> enumClass, T defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (enumClass.isInstance(val)) {
            return (T)((Enum)val);
        }
        try {
            return Enum.valueOf(enumClass, String.valueOf(val));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("getEnum(\"" + key + "\"," + enumClass.getSimpleName() + "," + defaultValue.name() + "):  <set name=\"" + key + "\" val=\"" + val + "\" /> \u306e" + val + "\u306f\u7121\u52b9\u306a\u5024\u3002" + this.dump());
        }
    }

    public void set(String name, Object value) {
        this._set.put(name, value);
    }

    public void set(String key, boolean value) {
        this._set.put(key, value);
    }

    public void set(String key, byte value) {
        this._set.put(key, value);
    }

    public void set(String key, short value) {
        this._set.put(key, value);
    }

    public void set(String key, int value) {
        this._set.put(key, value);
    }

    public void set(String key, long value) {
        this._set.put(key, value);
    }

    public void set(String key, float value) {
        this._set.put(key, Float.valueOf(value));
    }

    public void set(String key, double value) {
        this._set.put(key, value);
    }

    public void set(String key, String value) {
        this._set.put(key, value);
    }

    public void set(String key, Enum<?> value) {
        this._set.put(key, value);
    }

    public void safeSet(String key, int value, int min, int max, String reference) {
        assert (min > max || value >= min && value < max);
        if (min <= max && (value < min || value >= max)) {
            _log.log(Level.SEVERE, "Incorrect value: " + value + "for: " + key + "Ref: " + reference);
        }
        this.set(key, value);
    }

    public final <A> A getObject(String name, Class<A> type) {
        Object obj = this._set.get(name);
        if (obj == null || !type.isAssignableFrom(obj.getClass())) {
            return null;
        }
        return (A)obj;
    }
}

