/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.events;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.events.AbstractCharEvents;
import com.l2jserver.gameserver.model.actor.events.annotations.PlayerOnly;
import com.l2jserver.gameserver.model.actor.events.annotations.SkillId;
import com.l2jserver.gameserver.model.actor.events.annotations.SkillLevel;
import com.l2jserver.gameserver.model.actor.events.listeners.IAttackEventListener;
import com.l2jserver.gameserver.model.actor.events.listeners.IDamageDealtEventListener;
import com.l2jserver.gameserver.model.actor.events.listeners.IDamageReceivedEventListener;
import com.l2jserver.gameserver.model.actor.events.listeners.IDeathEventListener;
import com.l2jserver.gameserver.model.actor.events.listeners.ISkillUseEventListener;
import com.l2jserver.gameserver.model.actor.events.listeners.ITeleportedEventListener;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.util.Util;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CharEvents
extends AbstractCharEvents {
    protected static final Logger _log = Logger.getLogger(CharEvents.class.getName());
    private final L2Character _activeChar;

    public CharEvents(L2Character activeChar) {
        this._activeChar = activeChar;
    }

    public boolean onAttack(L2Character target) {
        if (this.hasListeners()) {
            for (IAttackEventListener listener : this.getEventListeners(IAttackEventListener.class)) {
                try {
                    if (listener.getClass().isAnnotationPresent(PlayerOnly.class) && !target.isPlayer() || listener.onAttack(this.getActingPlayer(), target)) continue;
                    return false;
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception caught: ", e);
                }
            }
        }
        return true;
    }

    public boolean onMagic(L2Skill skill, boolean simultaneously, L2Character target, L2Object[] targets) {
        if (this.hasListeners()) {
            for (ISkillUseEventListener listener : this.getEventListeners(ISkillUseEventListener.class)) {
                try {
                    SkillLevel skillLevelA;
                    SkillId skillIdA;
                    if (listener.getClass().isAnnotationPresent(PlayerOnly.class) && !target.isPlayer() || (skillIdA = listener.getClass().getAnnotation(SkillId.class)) != null && !Util.contains(skillIdA.value(), skill.getId()) || (skillLevelA = listener.getClass().getAnnotation(SkillLevel.class)) != null && !Util.contains(skillLevelA.value(), skill.getLevel()) || listener.onSkillUse(this.getActingPlayer(), skill, simultaneously, target, targets)) continue;
                    return false;
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception caught: ", e);
                }
            }
        }
        return true;
    }

    public boolean onDeath(L2Character killer) {
        if (this.hasListeners()) {
            for (IDeathEventListener listener : this.getEventListeners(IDeathEventListener.class)) {
                try {
                    if (listener.getClass().isAnnotationPresent(PlayerOnly.class) && !killer.isPlayer() || listener.onDeath(killer, this.getActingPlayer())) continue;
                    return false;
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception caught: ", e);
                }
            }
        }
        return true;
    }

    public void onDamageDealt(double damage, L2Character target, L2Skill skill, boolean crit, boolean damageOverTime) {
        if (this.hasListeners()) {
            for (IDamageDealtEventListener listener : this.getEventListeners(IDamageDealtEventListener.class)) {
                try {
                    if (listener.getClass().isAnnotationPresent(PlayerOnly.class) && !target.isPlayer()) continue;
                    listener.onDamageDealtEvent(this.getActingPlayer(), target, damage, skill, crit, damageOverTime);
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception caught: ", e);
                }
            }
        }
    }

    public void onDamageReceived(double damage, L2Character attacker, L2Skill skill, boolean crit, boolean damageOverTime) {
        if (this.hasListeners()) {
            for (IDamageReceivedEventListener listener : this.getEventListeners(IDamageReceivedEventListener.class)) {
                try {
                    if (listener.getClass().isAnnotationPresent(PlayerOnly.class) && !attacker.isPlayer()) continue;
                    listener.onDamageReceivedEvent(attacker, this.getActingPlayer(), damage, skill, crit, damageOverTime);
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception caught: ", e);
                }
            }
        }
    }

    public void onTeleported() {
        if (this.hasListeners()) {
            for (ITeleportedEventListener listener : this.getEventListeners(ITeleportedEventListener.class)) {
                try {
                    listener.onTeleported(this.getActingPlayer());
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception caught: ", e);
                }
            }
        }
    }

    public L2Character getActingPlayer() {
        return this._activeChar;
    }
}

