/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.events;

import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.events.CharEvents;
import com.l2jserver.gameserver.model.actor.events.annotations.PlayerOnly;
import com.l2jserver.gameserver.model.actor.events.listeners.IExperienceReceivedEventListener;
import com.l2jserver.gameserver.model.actor.events.listeners.ILevelChangeEventListener;
import java.util.logging.Level;

public class PlayableEvents
extends CharEvents {
    public PlayableEvents(L2Playable activeChar) {
        super(activeChar);
    }

    public boolean onExperienceReceived(long exp) {
        if (this.hasListeners()) {
            for (IExperienceReceivedEventListener listener : this.getEventListeners(IExperienceReceivedEventListener.class)) {
                try {
                    if (listener.getClass().isAnnotationPresent(PlayerOnly.class) && !this.getActingPlayer().isPlayer() || listener.onExperienceReceived(this.getActingPlayer(), exp)) continue;
                    return false;
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception caught: ", e);
                }
            }
        }
        return true;
    }

    public boolean onLevelChange(byte levels) {
        if (this.hasListeners()) {
            for (ILevelChangeEventListener listener : this.getEventListeners(ILevelChangeEventListener.class)) {
                try {
                    if (listener.getClass().isAnnotationPresent(PlayerOnly.class) && !this.getActingPlayer().isPlayer() || listener.onLevelChange(this.getActingPlayer(), levels)) continue;
                    return false;
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception caught: ", e);
                }
            }
        }
        return true;
    }

    @Override
    public L2Playable getActingPlayer() {
        return (L2Playable)super.getActingPlayer();
    }
}

