/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.events;

import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.model.actor.events.PlayableEvents;
import com.l2jserver.gameserver.model.actor.events.annotations.Message;
import com.l2jserver.gameserver.model.actor.events.annotations.UseAntiFeed;
import com.l2jserver.gameserver.model.actor.events.listeners.IDlgAnswerEventListener;
import com.l2jserver.gameserver.model.actor.events.listeners.IFamePointsChangeEventListener;
import com.l2jserver.gameserver.model.actor.events.listeners.IKarmaChangeEventListener;
import com.l2jserver.gameserver.model.actor.events.listeners.IPKPointsChangeEventListener;
import com.l2jserver.gameserver.model.actor.events.listeners.IPlayerLoginEventListener;
import com.l2jserver.gameserver.model.actor.events.listeners.IPlayerLogoutEventListener;
import com.l2jserver.gameserver.model.actor.events.listeners.IPvPKillEventListener;
import com.l2jserver.gameserver.model.actor.events.listeners.IPvPPointsEventChange;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.util.Util;
import java.util.logging.Level;

public class PlayerEvents
extends PlayableEvents {
    public PlayerEvents(L2PcInstance activeChar) {
        super(activeChar);
    }

    @Override
    public L2PcInstance getActingPlayer() {
        return (L2PcInstance)super.getActingPlayer();
    }

    public boolean onKarmaChange(int oldKarma, int newKarma) {
        if (this.hasListeners()) {
            for (IKarmaChangeEventListener listener : this.getEventListeners(IKarmaChangeEventListener.class)) {
                try {
                    if (listener.onKarmaChange(this.getActingPlayer(), oldKarma, newKarma)) continue;
                    return false;
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception caught: ", e);
                }
            }
        }
        return true;
    }

    public boolean onPKChange(int oldPKPoints, int newPKPoints) {
        if (this.hasListeners()) {
            for (IPKPointsChangeEventListener listener : this.getEventListeners(IPKPointsChangeEventListener.class)) {
                try {
                    if (listener.onPKPointsChange(this.getActingPlayer(), oldPKPoints, newPKPoints)) continue;
                    return false;
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception caught: ", e);
                }
            }
        }
        return true;
    }

    public boolean onPvPChange(int oldPvPPoints, int newPvPPoints) {
        if (this.hasListeners()) {
            for (IPvPPointsEventChange listener : this.getEventListeners(IPvPPointsEventChange.class)) {
                try {
                    if (listener.onPvPPointsChange(this.getActingPlayer(), oldPvPPoints, newPvPPoints)) continue;
                    return false;
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception caught: ", e);
                }
            }
        }
        return true;
    }

    public boolean onFameChange(int oldFamePoints, int newFamePoints) {
        if (this.hasListeners()) {
            for (IFamePointsChangeEventListener listener : this.getEventListeners(IFamePointsChangeEventListener.class)) {
                try {
                    if (listener.onFamePointsChange(this.getActingPlayer(), oldFamePoints, newFamePoints)) continue;
                    return false;
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception caught: ", e);
                }
            }
        }
        return true;
    }

    public boolean onDlgAnswer(int messageId, int answer, int requesterId) {
        if (this.hasListeners()) {
            for (IDlgAnswerEventListener listener : this.getEventListeners(IDlgAnswerEventListener.class)) {
                try {
                    Message messageA = listener.getClass().getAnnotation(Message.class);
                    if (messageA != null && !Util.contains(messageA.value(), messageId) || listener.onDlgAnswer(this.getActingPlayer(), messageId, answer, requesterId)) continue;
                    return false;
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception caught: ", e);
                }
            }
        }
        return true;
    }

    public void onPlayerLogin() {
        if (this.hasListeners()) {
            for (IPlayerLoginEventListener listener : this.getEventListeners(IPlayerLoginEventListener.class)) {
                try {
                    listener.onPlayerLogin(this.getActingPlayer());
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception caught: ", e);
                }
            }
        }
    }

    public void onPlayerLogout() {
        if (this.hasListeners()) {
            for (IPlayerLogoutEventListener listener : this.getEventListeners(IPlayerLogoutEventListener.class)) {
                try {
                    listener.onPlayerLogout(this.getActingPlayer());
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception caught: ", e);
                }
            }
        }
    }

    public void onPvPKill(L2PcInstance target) {
        if (this.hasListeners()) {
            for (IPvPKillEventListener listener : this.getEventListeners(IPvPKillEventListener.class)) {
                try {
                    UseAntiFeed useAntiFeed = listener.getClass().getAnnotation(UseAntiFeed.class);
                    if (useAntiFeed != null && !AntiFeedManager.getInstance().check(this.getActingPlayer(), target)) continue;
                    listener.onPvPKill(this.getActingPlayer(), target);
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception caught: ", e);
                }
            }
        }
    }
}

