/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.util.Rnd;

public final class L2ChestInstance
extends L2MonsterInstance {
    private volatile boolean _isInteracted;
    private volatile boolean _specialDrop;

    public L2ChestInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2ChestInstance);
        this.setIsNoRndWalk(true);
        this._isInteracted = false;
        this._specialDrop = false;
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this._isInteracted = false;
        this._specialDrop = false;
        this.setMustRewardExpSp(true);
    }

    public synchronized boolean isInteracted() {
        return this._isInteracted;
    }

    public synchronized void setInteracted() {
        this._isInteracted = true;
    }

    public synchronized boolean isSpecialDrop() {
        return this._specialDrop;
    }

    public synchronized void setSpecialDrop() {
        this._specialDrop = true;
    }

    @Override
    public void doItemDrop(L2NpcTemplate npcTemplate, L2Character lastAttacker) {
        int id = this.getTemplate().getId();
        if (!this._specialDrop) {
            if (id >= 18265 && id <= 18286) {
                id += 3536;
            } else if (id == 18287 || id == 18288) {
                id = 21671;
            } else if (id == 18289 || id == 18290) {
                id = 21694;
            } else if (id == 18291 || id == 18292) {
                id = 21717;
            } else if (id == 18293 || id == 18294) {
                id = 21740;
            } else if (id == 18295 || id == 18296) {
                id = 21763;
            } else if (id == 18297 || id == 18298) {
                id = 21786;
            }
        }
        super.doItemDrop(NpcTable.getInstance().getTemplate(id), lastAttacker);
    }

    public void chestTrap(L2Character player) {
        int trapSkillId = 0;
        int rnd = Rnd.get(120);
        trapSkillId = this.getTemplate().getLevel() >= 61 ? (rnd >= 90 ? 4139 : (rnd >= 50 ? 4118 : (rnd >= 20 ? 1167 : 223))) : (this.getTemplate().getLevel() >= 41 ? (rnd >= 90 ? 4139 : (rnd >= 60 ? 96 : (rnd >= 20 ? 1167 : 4118))) : (this.getTemplate().getLevel() >= 21 ? (rnd >= 80 ? 4139 : (rnd >= 50 ? 96 : (rnd >= 20 ? 1167 : 129))) : (rnd >= 80 ? 4139 : (rnd >= 50 ? 96 : 129))));
        player.sendMessage("There was a trap!");
        this.handleCast(player, trapSkillId);
    }

    private boolean handleCast(L2Character player, int skillId) {
        int skillLevel = 1;
        byte lvl = this.getTemplate().getLevel();
        if (lvl > 20 && lvl <= 40) {
            skillLevel = 3;
        } else if (lvl > 40 && lvl <= 60) {
            skillLevel = 5;
        } else if (lvl > 60) {
            skillLevel = 6;
        }
        if (player.isDead() || !player.isVisible() || !player.isInsideRadius(this, this.getDistanceToWatchObject(player), false, false)) {
            return false;
        }
        L2Skill skill = SkillTable.getInstance().getInfo(skillId, skillLevel);
        if (!player.isAffectedBySkill(skillId)) {
            skill.applyEffects(this, player);
            this.broadcastPacket(new MagicSkillUse(this, player, skillId, skillLevel, skill.getHitTime(), 0));
            return true;
        }
        return false;
    }

    @Override
    public boolean isMovementDisabled() {
        if (super.isMovementDisabled()) {
            return true;
        }
        return !this.isInteracted();
    }

    @Override
    public boolean hasRandomAnimation() {
        return false;
    }
}

