/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.TeleportLocationTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.CHSiegeManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.L2TeleportLocation;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.clanhall.AuctionableHall;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.skills.L2SkillType;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.AgitDecoInfo;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.util.Util;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;

public class L2ClanHallManagerInstance
extends L2MerchantInstance {
    protected static final int COND_OWNER_FALSE = 0;
    protected static final int COND_ALL_FALSE = 1;
    protected static final int COND_BUSY_BECAUSE_OF_SIEGE = 2;
    protected static final int COND_OWNER = 3;
    private int _clanHallId = -1;

    public L2ClanHallManagerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2ClanHallManagerInstance);
    }

    @Override
    public boolean isWarehouse() {
        return true;
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (this.getClanHall().isSiegableHall() && ((SiegableHall)this.getClanHall()).isInSiege()) {
            return;
        }
        int condition = this.validateCondition(player);
        if (condition <= 1) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("M/d H");
        if (condition == 3) {
            StringTokenizer st = new StringTokenizer(command, " ");
            String actualCommand = st.nextToken();
            String val = "";
            if (st.countTokens() >= 1) {
                val = st.nextToken();
            }
            if (actualCommand.equalsIgnoreCase("banish_foreigner")) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                if (player.hasClanPrivilege(ClanPrivilege.CH_DISMISS)) {
                    if (val.equalsIgnoreCase("list")) {
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/banish-list.htm");
                    } else if (val.equalsIgnoreCase("banish")) {
                        this.getClanHall().banishForeigners();
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/banish.htm");
                    }
                } else {
                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/not_authorized.htm");
                }
                this.sendHtmlMessage(player, html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("manage_vault")) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                if (player.hasClanPrivilege(ClanPrivilege.CL_VIEW_WAREHOUSE)) {
                    if (this.getClanHall().getLease() <= 0) {
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/vault-chs.htm");
                    } else {
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/vault.htm");
                        html.replace((CharSequence)"%rent%", Util.formatAdena(this.getClanHall().getLease()));
                        html.replace((CharSequence)"%date%", format.format(this.getClanHall().getPaidUntil()));
                    }
                    this.sendHtmlMessage(player, html);
                } else {
                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/not_authorized.htm");
                    this.sendHtmlMessage(player, html);
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("door")) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                if (player.hasClanPrivilege(ClanPrivilege.CH_OPEN_DOOR)) {
                    if (val.equalsIgnoreCase("open")) {
                        this.getClanHall().openCloseDoors(true);
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/door-open.htm");
                    } else if (val.equalsIgnoreCase("close")) {
                        this.getClanHall().openCloseDoors(false);
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/door-close.htm");
                    } else {
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/door.htm");
                    }
                    this.sendHtmlMessage(player, html);
                } else {
                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/not_authorized.htm");
                    this.sendHtmlMessage(player, html);
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("functions")) {
                if (val.equalsIgnoreCase("tele")) {
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    if (this.getClanHall().getFunction(1) == null) {
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/chamberlain-nac.htm");
                    } else {
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/tele" + this.getClanHall().getLocation() + this.getClanHall().getFunction(1).getLvl() + ".htm");
                    }
                    this.sendHtmlMessage(player, html);
                } else if (val.equalsIgnoreCase("item_creation")) {
                    if (this.getClanHall().getFunction(2) == null) {
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/chamberlain-nac.htm");
                        this.sendHtmlMessage(player, html);
                        return;
                    }
                    if (st.countTokens() < 1) {
                        return;
                    }
                    int valbuy = Integer.parseInt(st.nextToken()) + this.getClanHall().getFunction(2).getLvl() * 100000;
                    this.showBuyWindow(player, valbuy);
                } else if (val.equalsIgnoreCase("support")) {
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    if (this.getClanHall().getFunction(6) == null) {
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/chamberlain-nac.htm");
                    } else {
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/support" + this.getClanHall().getFunction(6).getLvl() + ".htm");
                        html.replace((CharSequence)"%mp%", (int)this.getCurrentMp());
                    }
                    this.sendHtmlMessage(player, html);
                } else if (val.equalsIgnoreCase("back")) {
                    this.showChatWindow(player);
                } else {
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions.htm");
                    if (this.getClanHall().getFunction(5) != null) {
                        html.replace((CharSequence)"%xp_regen%", this.getClanHall().getFunction(5).getLvl());
                    } else {
                        html.replace((CharSequence)"%xp_regen%", "0");
                    }
                    if (this.getClanHall().getFunction(3) != null) {
                        html.replace((CharSequence)"%hp_regen%", this.getClanHall().getFunction(3).getLvl());
                    } else {
                        html.replace((CharSequence)"%hp_regen%", "0");
                    }
                    if (this.getClanHall().getFunction(4) != null) {
                        html.replace((CharSequence)"%mp_regen%", this.getClanHall().getFunction(4).getLvl());
                    } else {
                        html.replace((CharSequence)"%mp_regen%", "0");
                    }
                    this.sendHtmlMessage(player, html);
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("manage")) {
                if (player.hasClanPrivilege(ClanPrivilege.CH_SET_FUNCTIONS)) {
                    if (val.equalsIgnoreCase("recovery")) {
                        int grade;
                        if (st.countTokens() >= 1) {
                            if (this.getClanHall().getOwnerId() == 0) {
                                player.sendMessage("This clan hall has no owner, you cannot change the configuration.");
                                return;
                            }
                            val = st.nextToken();
                            if (val.equalsIgnoreCase("hp_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "recovery hp 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("mp_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "recovery mp 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("exp_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "recovery exp 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_hp")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "\u30da\u30c1\u30ab(HP\u56de\u5fa9\u65bd\u8a2d)");
                                int percent = Integer.parseInt(val);
                                switch (percent) {
                                    case 20: {
                                        cost = Config.CH_HPREG1_FEE;
                                        break;
                                    }
                                    case 40: {
                                        cost = Config.CH_HPREG2_FEE;
                                        break;
                                    }
                                    case 80: {
                                        cost = Config.CH_HPREG3_FEE;
                                        break;
                                    }
                                    case 100: {
                                        cost = Config.CH_HPREG4_FEE;
                                        break;
                                    }
                                    case 120: {
                                        cost = Config.CH_HPREG5_FEE;
                                        break;
                                    }
                                    case 140: {
                                        cost = Config.CH_HPREG6_FEE;
                                        break;
                                    }
                                    case 160: {
                                        cost = Config.CH_HPREG7_FEE;
                                        break;
                                    }
                                    case 180: {
                                        cost = Config.CH_HPREG8_FEE;
                                        break;
                                    }
                                    case 200: {
                                        cost = Config.CH_HPREG9_FEE;
                                        break;
                                    }
                                    case 220: {
                                        cost = Config.CH_HPREG10_FEE;
                                        break;
                                    }
                                    case 240: {
                                        cost = Config.CH_HPREG11_FEE;
                                        break;
                                    }
                                    case 260: {
                                        cost = Config.CH_HPREG12_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.CH_HPREG13_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", Util.formatAdena(cost) + "</font>\u30a2\u30c7\u30ca/" + Config.CH_HPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + "\u65e5</font>");
                                html.replace((CharSequence)"%use%", "\u30a2\u30b8\u30c8\u5185\u306e\u8840\u76df\u54e1\u306eHP\u304c <font color=\"00FFFF\">" + percent + "%</font>" + " \u8ffd\u52a0\u56de\u5fa9");
                                html.replace((CharSequence)"%apply%", "recovery hp " + percent);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_mp")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "\u30ab\u30fc\u30da\u30c3\u30c8(MP\u56de\u5fa9\u6a5f\u80fd)");
                                int percent = Integer.parseInt(val);
                                switch (percent) {
                                    case 5: {
                                        cost = Config.CH_MPREG1_FEE;
                                        break;
                                    }
                                    case 10: {
                                        cost = Config.CH_MPREG2_FEE;
                                        break;
                                    }
                                    case 15: {
                                        cost = Config.CH_MPREG3_FEE;
                                        break;
                                    }
                                    case 30: {
                                        cost = Config.CH_MPREG4_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.CH_MPREG5_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", Util.formatAdena(cost) + "</font>\u30a2\u30c7\u30ca/" + Config.CH_MPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + "\u65e5</font>");
                                html.replace((CharSequence)"%use%", "\u30a2\u30b8\u30c8\u5185\u306e\u8840\u76df\u54e1\u306eMP\u304c <font color=\"00FFFF\">" + percent + "%</font>" + " \u8ffd\u52a0\u56de\u5fa9");
                                html.replace((CharSequence)"%apply%", "recovery mp " + percent);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_exp")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "\u30b7\u30e3\u30f3\u30c7\u30ea\u30a2(\u7d4c\u9a13\u5024\u56de\u5fa9\u65bd\u8a2d)");
                                int percent = Integer.parseInt(val);
                                switch (percent) {
                                    case 5: {
                                        cost = Config.CH_EXPREG1_FEE;
                                        break;
                                    }
                                    case 10: {
                                        cost = Config.CH_EXPREG2_FEE;
                                        break;
                                    }
                                    case 15: {
                                        cost = Config.CH_EXPREG3_FEE;
                                        break;
                                    }
                                    case 25: {
                                        cost = Config.CH_EXPREG4_FEE;
                                        break;
                                    }
                                    case 35: {
                                        cost = Config.CH_EXPREG5_FEE;
                                        break;
                                    }
                                    case 40: {
                                        cost = Config.CH_EXPREG6_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.CH_EXPREG7_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", Util.formatAdena(cost) + "</font>\u30a2\u30c7\u30ca/" + Config.CH_EXPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + "\u65e5</font>");
                                html.replace((CharSequence)"%use%", "\u8840\u76df\u54e1\u304c\u30a2\u30b8\u30c8\u3067\u8607\u308b\u5834\u5408\u3001\u7d4c\u9a13\u5024 <font color=\"00FFFF\">" + percent + "%</font>" + " \u56de\u5fa9");
                                html.replace((CharSequence)"%apply%", "recovery exp " + percent);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("hp")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Config.DEBUG) {
                                        _log.warning("Mp editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply_confirmed.htm");
                                    if (this.getClanHall().getFunction(3) != null && this.getClanHall().getFunction(3).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-used.htm");
                                        html.replace((CharSequence)"%val%", val + "%");
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int percent = Integer.parseInt(val);
                                    switch (percent) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 20: {
                                            fee = Config.CH_HPREG1_FEE;
                                            break;
                                        }
                                        case 40: {
                                            fee = Config.CH_HPREG2_FEE;
                                            break;
                                        }
                                        case 80: {
                                            fee = Config.CH_HPREG3_FEE;
                                            break;
                                        }
                                        case 100: {
                                            fee = Config.CH_HPREG4_FEE;
                                            break;
                                        }
                                        case 120: {
                                            fee = Config.CH_HPREG5_FEE;
                                            break;
                                        }
                                        case 140: {
                                            fee = Config.CH_HPREG6_FEE;
                                            break;
                                        }
                                        case 160: {
                                            fee = Config.CH_HPREG7_FEE;
                                            break;
                                        }
                                        case 180: {
                                            fee = Config.CH_HPREG8_FEE;
                                            break;
                                        }
                                        case 200: {
                                            fee = Config.CH_HPREG9_FEE;
                                            break;
                                        }
                                        case 220: {
                                            fee = Config.CH_HPREG10_FEE;
                                            break;
                                        }
                                        case 240: {
                                            fee = Config.CH_HPREG11_FEE;
                                            break;
                                        }
                                        case 260: {
                                            fee = Config.CH_HPREG12_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.CH_HPREG13_FEE;
                                        }
                                    }
                                    if (!this.getClanHall().updateFunctions(player, 3, percent, fee, Config.CH_HPREG_FEE_RATIO, this.getClanHall().getFunction(3) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.revalidateDeco(player);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                            if (val.equalsIgnoreCase("mp")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Config.DEBUG) {
                                        _log.warning("Mp editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply_confirmed.htm");
                                    if (this.getClanHall().getFunction(4) != null && this.getClanHall().getFunction(4).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-used.htm");
                                        html.replace((CharSequence)"%val%", val + "%");
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int percent = Integer.parseInt(val);
                                    switch (percent) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 5: {
                                            fee = Config.CH_MPREG1_FEE;
                                            break;
                                        }
                                        case 10: {
                                            fee = Config.CH_MPREG2_FEE;
                                            break;
                                        }
                                        case 15: {
                                            fee = Config.CH_MPREG3_FEE;
                                            break;
                                        }
                                        case 30: {
                                            fee = Config.CH_MPREG4_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.CH_MPREG5_FEE;
                                        }
                                    }
                                    if (!this.getClanHall().updateFunctions(player, 4, percent, fee, Config.CH_MPREG_FEE_RATIO, this.getClanHall().getFunction(4) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.revalidateDeco(player);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                            if (val.equalsIgnoreCase("exp")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Config.DEBUG) {
                                        _log.warning("Exp editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply_confirmed.htm");
                                    if (this.getClanHall().getFunction(5) != null && this.getClanHall().getFunction(5).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-used.htm");
                                        html.replace((CharSequence)"%val%", val + "%");
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int percent = Integer.parseInt(val);
                                    switch (percent) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 5: {
                                            fee = Config.CH_EXPREG1_FEE;
                                            break;
                                        }
                                        case 10: {
                                            fee = Config.CH_EXPREG2_FEE;
                                            break;
                                        }
                                        case 15: {
                                            fee = Config.CH_EXPREG3_FEE;
                                            break;
                                        }
                                        case 25: {
                                            fee = Config.CH_EXPREG4_FEE;
                                            break;
                                        }
                                        case 35: {
                                            fee = Config.CH_EXPREG5_FEE;
                                            break;
                                        }
                                        case 40: {
                                            fee = Config.CH_EXPREG6_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.CH_EXPREG7_FEE;
                                        }
                                    }
                                    if (!this.getClanHall().updateFunctions(player, 5, percent, fee, Config.CH_EXPREG_FEE_RATIO, this.getClanHall().getFunction(5) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.revalidateDeco(player);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                        }
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/edit_recovery.htm");
                        String hp_grade0 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 20\">20%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 40\">40%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 220\">220%</a>]";
                        String hp_grade1 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 40\">40%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 100\">100%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 160\">160%</a>]";
                        String hp_grade2 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 80\">80%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 140\">140%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 200\">200%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 260\">260%</a>]";
                        String hp_grade3 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 80\">80%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 120\">120%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 180\">180%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 240\">240%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 300\">300%</a>]";
                        String exp_grade0 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 5\">5%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 10\">10%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 25\">25%</a>]";
                        String exp_grade1 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 5\">5%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 15\">15%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 30\">30%</a>]";
                        String exp_grade2 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 5\">5%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 15\">15%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 25\">25%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 40\">40%</a>]";
                        String exp_grade3 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 15\">15%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 25\">25%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 35\">35%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 50\">50%</a>]";
                        String mp_grade0 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 5\">5%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 10\">10%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 25\">25%</a>]";
                        String mp_grade1 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 5\">5%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 15\">15%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 25\">25%</a>]";
                        String mp_grade2 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 5\">5%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 15\">15%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 30\">30%</a>]";
                        String mp_grade3 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 5\">5%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 15\">15%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 30\">30%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 40\">40%</a>]";
                        if (this.getClanHall().getFunction(3) != null) {
                            html.replace((CharSequence)"%hp_recovery%", this.getClanHall().getFunction(3).getLvl() + "%</font> (<font color=\"FFAABB\">" + this.getClanHall().getFunction(3).getLease() + "</font>\u30a2\u30c7\u30ca/" + Config.CH_HPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + "\u65e5)");
                            html.replace((CharSequence)"%hp_period%", format.format(this.getClanHall().getFunction(3).getEndTime()) + "\u6642\u306b\u6b21\u56de\u306e\u4f7f\u7528\u6599\u3092\u5f15\u304d\u51fa\u3059");
                            grade = this.getClanHall().getGrade();
                            switch (grade) {
                                case 0: {
                                    html.replace((CharSequence)"%change_hp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery hp_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + hp_grade0);
                                    break;
                                }
                                case 1: {
                                    html.replace((CharSequence)"%change_hp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery hp_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + hp_grade1);
                                    break;
                                }
                                case 2: {
                                    html.replace((CharSequence)"%change_hp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery hp_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + hp_grade2);
                                    break;
                                }
                                case 3: {
                                    html.replace((CharSequence)"%change_hp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery hp_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + hp_grade3);
                                }
                            }
                        } else {
                            html.replace((CharSequence)"%hp_recovery%", "\u975e\u6d3b\u6027\u5316");
                            html.replace((CharSequence)"%hp_period%", "\u975e\u6d3b\u6027\u5316");
                            grade = this.getClanHall().getGrade();
                            switch (grade) {
                                case 0: {
                                    html.replace((CharSequence)"%change_hp%", hp_grade0);
                                    break;
                                }
                                case 1: {
                                    html.replace((CharSequence)"%change_hp%", hp_grade1);
                                    break;
                                }
                                case 2: {
                                    html.replace((CharSequence)"%change_hp%", hp_grade2);
                                    break;
                                }
                                case 3: {
                                    html.replace((CharSequence)"%change_hp%", hp_grade3);
                                }
                            }
                        }
                        if (this.getClanHall().getFunction(5) != null) {
                            html.replace((CharSequence)"%exp_recovery%", this.getClanHall().getFunction(5).getLvl() + "%</font> (<font color=\"FFAABB\">" + this.getClanHall().getFunction(5).getLease() + "</font>\u30a2\u30c7\u30ca/" + Config.CH_EXPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + "\u65e5)");
                            html.replace((CharSequence)"%exp_period%", format.format(this.getClanHall().getFunction(5).getEndTime()) + "\u6642\u306b\u6b21\u56de\u306e\u4f7f\u7528\u6599\u3092\u5f15\u304d\u51fa\u3059");
                            grade = this.getClanHall().getGrade();
                            switch (grade) {
                                case 0: {
                                    html.replace((CharSequence)"%change_exp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery exp_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + exp_grade0);
                                    break;
                                }
                                case 1: {
                                    html.replace((CharSequence)"%change_exp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery exp_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + exp_grade1);
                                    break;
                                }
                                case 2: {
                                    html.replace((CharSequence)"%change_exp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery exp_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + exp_grade2);
                                    break;
                                }
                                case 3: {
                                    html.replace((CharSequence)"%change_exp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery exp_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + exp_grade3);
                                }
                            }
                        } else {
                            html.replace((CharSequence)"%exp_recovery%", "\u975e\u6d3b\u6027\u5316");
                            html.replace((CharSequence)"%exp_period%", "\u975e\u6d3b\u6027\u5316");
                            grade = this.getClanHall().getGrade();
                            switch (grade) {
                                case 0: {
                                    html.replace((CharSequence)"%change_exp%", exp_grade0);
                                    break;
                                }
                                case 1: {
                                    html.replace((CharSequence)"%change_exp%", exp_grade1);
                                    break;
                                }
                                case 2: {
                                    html.replace((CharSequence)"%change_exp%", exp_grade2);
                                    break;
                                }
                                case 3: {
                                    html.replace((CharSequence)"%change_exp%", exp_grade3);
                                }
                            }
                        }
                        if (this.getClanHall().getFunction(4) != null) {
                            html.replace((CharSequence)"%mp_recovery%", this.getClanHall().getFunction(4).getLvl() + "%</font> (<font color=\"FFAABB\">" + this.getClanHall().getFunction(4).getLease() + "</font>\u30a2\u30c7\u30ca/" + Config.CH_MPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + "\u65e5)");
                            html.replace((CharSequence)"%mp_period%", format.format(this.getClanHall().getFunction(4).getEndTime()) + "\u6642\u306b\u6b21\u56de\u306e\u4f7f\u7528\u6599\u3092\u5f15\u304d\u51fa\u3059");
                            grade = this.getClanHall().getGrade();
                            switch (grade) {
                                case 0: {
                                    html.replace((CharSequence)"%change_mp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery mp_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + mp_grade0);
                                    break;
                                }
                                case 1: {
                                    html.replace((CharSequence)"%change_mp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery mp_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + mp_grade1);
                                    break;
                                }
                                case 2: {
                                    html.replace((CharSequence)"%change_mp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery mp_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + mp_grade2);
                                    break;
                                }
                                case 3: {
                                    html.replace((CharSequence)"%change_mp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery mp_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + mp_grade3);
                                }
                            }
                        } else {
                            html.replace((CharSequence)"%mp_recovery%", "\u975e\u6d3b\u6027\u5316");
                            html.replace((CharSequence)"%mp_period%", "\u975e\u6d3b\u6027\u5316");
                            grade = this.getClanHall().getGrade();
                            switch (grade) {
                                case 0: {
                                    html.replace((CharSequence)"%change_mp%", mp_grade0);
                                    break;
                                }
                                case 1: {
                                    html.replace((CharSequence)"%change_mp%", mp_grade1);
                                    break;
                                }
                                case 2: {
                                    html.replace((CharSequence)"%change_mp%", mp_grade2);
                                    break;
                                }
                                case 3: {
                                    html.replace((CharSequence)"%change_mp%", mp_grade3);
                                }
                            }
                        }
                        this.sendHtmlMessage(player, html);
                    } else if (val.equalsIgnoreCase("other")) {
                        if (st.countTokens() >= 1) {
                            if (this.getClanHall().getOwnerId() == 0) {
                                player.sendMessage("This clan hall has no owner, you cannot change the configuration.");
                                return;
                            }
                            val = st.nextToken();
                            if (val.equalsIgnoreCase("item_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "other item 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("tele_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "other tele 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("support_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "other support 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_item")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "\u9b54\u6cd5\u306e\u6a5f\u68b0(\u30a2\u30a4\u30c6\u30e0\u306e\u751f\u7523\u65bd\u8a2d)");
                                int stage = Integer.parseInt(val);
                                switch (stage) {
                                    case 1: {
                                        cost = Config.CH_ITEM1_FEE;
                                        break;
                                    }
                                    case 2: {
                                        cost = Config.CH_ITEM2_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.CH_ITEM3_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", Util.formatAdena(cost) + "</font>\u30a2\u30c7\u30ca/" + Config.CH_ITEM_FEE_RATIO / 1000L / 60L / 60L / 24L + "\u65e5</font>");
                                html.replace((CharSequence)"%use%", "\u4e00\u5b9a\u6642\u9593\u3054\u3068\u306b\u3001\u7279\u6b8a\u306a\u30a2\u30a4\u30c6\u30e0\u304c\u8cb7\u3048\u307e\u3059\u3002");
                                html.replace((CharSequence)"%apply%", "other item " + stage);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_support")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "\u8a18\u7ae0(\u88dc\u52a9\u9b54\u6cd5\u65bd\u8a2d)");
                                int stage = Integer.parseInt(val);
                                switch (stage) {
                                    case 1: {
                                        cost = Config.CH_SUPPORT1_FEE;
                                        break;
                                    }
                                    case 2: {
                                        cost = Config.CH_SUPPORT2_FEE;
                                        break;
                                    }
                                    case 3: {
                                        cost = Config.CH_SUPPORT3_FEE;
                                        break;
                                    }
                                    case 4: {
                                        cost = Config.CH_SUPPORT4_FEE;
                                        break;
                                    }
                                    case 5: {
                                        cost = Config.CH_SUPPORT5_FEE;
                                        break;
                                    }
                                    case 6: {
                                        cost = Config.CH_SUPPORT6_FEE;
                                        break;
                                    }
                                    case 7: {
                                        cost = Config.CH_SUPPORT7_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.CH_SUPPORT8_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", Util.formatAdena(cost) + "</font>\u30a2\u30c7\u30ca/" + Config.CH_SUPPORT_FEE_RATIO / 1000L / 60L / 60L / 24L + "\u65e5</font>");
                                html.replace((CharSequence)"%use%", "\u5f79\u7acb\u3064\u88dc\u52a9\u9b54\u6cd5\u304c\u5229\u7528\u53ef\u80fd");
                                html.replace((CharSequence)"%apply%", "other support " + stage);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_tele")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "\u93e1(\u30c6\u30ec\u30dd\u30fc\u30c8\u65bd\u8a2d)");
                                int stage = Integer.parseInt(val);
                                switch (stage) {
                                    case 1: {
                                        cost = Config.CH_TELE1_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.CH_TELE2_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", Util.formatAdena(cost) + "</font>\u30a2\u30c7\u30ca/" + Config.CH_TELE_FEE_RATIO / 1000L / 60L / 60L / 24L + "\u65e5</font>");
                                html.replace((CharSequence)"%use%", "\u30a2\u30b8\u30c8\u5185\u306e\u8840\u76df\u54e1\u304c <font color=\"00FFFF\">Stage " + stage + "</font>" + "\u306e\u30a8\u30ea\u30a2\u306b\u30c6\u30ec\u30dd\u30fc\u30c8\u3067\u304d\u307e\u3059\u3002");
                                html.replace((CharSequence)"%apply%", "other tele " + stage);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("item")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (this.getClanHall().getOwnerId() == 0) {
                                        player.sendMessage("This clan hall has no owner, you cannot change the configuration.");
                                        return;
                                    }
                                    if (Config.DEBUG) {
                                        _log.warning("Item editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply_confirmed.htm");
                                    if (this.getClanHall().getFunction(2) != null && this.getClanHall().getFunction(2).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-used.htm");
                                        html.replace((CharSequence)"%val%", val + "\u6bb5\u968e");
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int lvl = Integer.parseInt(val);
                                    switch (lvl) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 1: {
                                            fee = Config.CH_ITEM1_FEE;
                                            break;
                                        }
                                        case 2: {
                                            fee = Config.CH_ITEM2_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.CH_ITEM3_FEE;
                                        }
                                    }
                                    if (!this.getClanHall().updateFunctions(player, 2, lvl, fee, Config.CH_ITEM_FEE_RATIO, this.getClanHall().getFunction(2) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.revalidateDeco(player);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                            if (val.equalsIgnoreCase("tele")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Config.DEBUG) {
                                        _log.warning("Tele editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply_confirmed.htm");
                                    if (this.getClanHall().getFunction(1) != null && this.getClanHall().getFunction(1).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-used.htm");
                                        html.replace((CharSequence)"%val%", val + "\u6bb5\u968e");
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int lvl = Integer.parseInt(val);
                                    switch (lvl) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 1: {
                                            fee = Config.CH_TELE1_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.CH_TELE2_FEE;
                                        }
                                    }
                                    if (!this.getClanHall().updateFunctions(player, 1, lvl, fee, Config.CH_TELE_FEE_RATIO, this.getClanHall().getFunction(1) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.revalidateDeco(player);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                            if (val.equalsIgnoreCase("support")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Config.DEBUG) {
                                        _log.warning("Support editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply_confirmed.htm");
                                    if (this.getClanHall().getFunction(6) != null && this.getClanHall().getFunction(6).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-used.htm");
                                        html.replace((CharSequence)"%val%", val + "\u6bb5\u968e");
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int lvl = Integer.parseInt(val);
                                    switch (lvl) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 1: {
                                            fee = Config.CH_SUPPORT1_FEE;
                                            break;
                                        }
                                        case 2: {
                                            fee = Config.CH_SUPPORT2_FEE;
                                            break;
                                        }
                                        case 3: {
                                            fee = Config.CH_SUPPORT3_FEE;
                                            break;
                                        }
                                        case 4: {
                                            fee = Config.CH_SUPPORT4_FEE;
                                            break;
                                        }
                                        case 5: {
                                            fee = Config.CH_SUPPORT5_FEE;
                                            break;
                                        }
                                        case 6: {
                                            fee = Config.CH_SUPPORT6_FEE;
                                            break;
                                        }
                                        case 7: {
                                            fee = Config.CH_SUPPORT7_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.CH_SUPPORT8_FEE;
                                        }
                                    }
                                    if (!this.getClanHall().updateFunctions(player, 6, lvl, fee, Config.CH_SUPPORT_FEE_RATIO, this.getClanHall().getFunction(6) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.revalidateDeco(player);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                        }
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/edit_other.htm");
                        String tele = "[<a action=\"bypass -h npc_%objectId%_manage other edit_tele 1\">1\u6bb5\u968e</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_tele 2\">2\u6bb5\u968e</a>]";
                        String support_grade0 = "[<a action=\"bypass -h npc_%objectId%_manage other edit_support 1\">1\u6bb5\u968e</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 2\">2\u6bb5\u968e</a>]";
                        String support_grade1 = "[<a action=\"bypass -h npc_%objectId%_manage other edit_support 1\">1\u6bb5\u968e</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 2\">2\u6bb5\u968e</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 4\">4\u6bb5\u968e</a>]";
                        String support_grade2 = "[<a action=\"bypass -h npc_%objectId%_manage other edit_support 3\">3\u6bb5\u968e</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 4\">4\u6bb5\u968e</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 5\">5\u6bb5\u968e</a>]";
                        String support_grade3 = "[<a action=\"bypass -h npc_%objectId%_manage other edit_support 3\">3\u6bb5\u968e</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 5\">5\u6bb5\u968e</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 7\">7\u6bb5\u968e</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 8\">8\u6bb5\u968e</a>]";
                        String item = "[<a action=\"bypass -h npc_%objectId%_manage other edit_item 1\">1\u6bb5\u968e</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_item 2\">2\u6bb5\u968e</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_item 3\">3\u6bb5\u968e</a>]";
                        if (this.getClanHall().getFunction(1) != null) {
                            html.replace((CharSequence)"%tele%", this.getClanHall().getFunction(1).getLvl() + "\u6bb5\u968e" + "</font> (<font color=\"FFAABB\">" + this.getClanHall().getFunction(1).getLease() + "</font>\u30a2\u30c7\u30ca/" + Config.CH_TELE_FEE_RATIO / 1000L / 60L / 60L / 24L + "\u65e5)");
                            html.replace((CharSequence)"%tele_period%", format.format(this.getClanHall().getFunction(1).getEndTime()) + "\u6642\u306b\u6b21\u56de\u306e\u4f7f\u7528\u6599\u3092\u5f15\u304d\u51fa\u3059");
                            html.replace((CharSequence)"%change_tele%", "[<a action=\"bypass -h npc_%objectId%_manage other tele_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + tele);
                        } else {
                            html.replace((CharSequence)"%tele%", "\u975e\u6d3b\u6027\u5316");
                            html.replace((CharSequence)"%tele_period%", "\u975e\u6d3b\u6027\u5316");
                            html.replace((CharSequence)"%change_tele%", tele);
                        }
                        if (this.getClanHall().getFunction(6) != null) {
                            html.replace((CharSequence)"%support%", this.getClanHall().getFunction(6).getLvl() + "\u6bb5\u968e" + "</font> (<font color=\"FFAABB\">" + this.getClanHall().getFunction(6).getLease() + "</font>\u30a2\u30c7\u30ca/" + Config.CH_SUPPORT_FEE_RATIO / 1000L / 60L / 60L / 24L + "\u65e5)");
                            html.replace((CharSequence)"%support_period%", format.format(this.getClanHall().getFunction(6).getEndTime()) + "\u6642\u306b\u6b21\u56de\u306e\u4f7f\u7528\u6599\u3092\u5f15\u304d\u51fa\u3059");
                            int grade = this.getClanHall().getGrade();
                            switch (grade) {
                                case 0: {
                                    html.replace((CharSequence)"%change_support%", "[<a action=\"bypass -h npc_%objectId%_manage other support_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + support_grade0);
                                    break;
                                }
                                case 1: {
                                    html.replace((CharSequence)"%change_support%", "[<a action=\"bypass -h npc_%objectId%_manage other support_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + support_grade1);
                                    break;
                                }
                                case 2: {
                                    html.replace((CharSequence)"%change_support%", "[<a action=\"bypass -h npc_%objectId%_manage other support_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + support_grade2);
                                    break;
                                }
                                case 3: {
                                    html.replace((CharSequence)"%change_support%", "[<a action=\"bypass -h npc_%objectId%_manage other support_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + support_grade3);
                                }
                            }
                        } else {
                            html.replace((CharSequence)"%support%", "\u975e\u6d3b\u6027\u5316");
                            html.replace((CharSequence)"%support_period%", "\u975e\u6d3b\u6027\u5316");
                            int grade = this.getClanHall().getGrade();
                            switch (grade) {
                                case 0: {
                                    html.replace((CharSequence)"%change_support%", support_grade0);
                                    break;
                                }
                                case 1: {
                                    html.replace((CharSequence)"%change_support%", support_grade1);
                                    break;
                                }
                                case 2: {
                                    html.replace((CharSequence)"%change_support%", support_grade2);
                                    break;
                                }
                                case 3: {
                                    html.replace((CharSequence)"%change_support%", support_grade3);
                                }
                            }
                        }
                        if (this.getClanHall().getFunction(2) != null) {
                            html.replace((CharSequence)"%item%", this.getClanHall().getFunction(2).getLvl() + "\u6bb5\u968e" + "</font> (<font color=\"FFAABB\">" + this.getClanHall().getFunction(2).getLease() + "</font>\u30a2\u30c7\u30ca/" + Config.CH_ITEM_FEE_RATIO / 1000L / 60L / 60L / 24L + "\u65e5)");
                            html.replace((CharSequence)"%item_period%", format.format(this.getClanHall().getFunction(2).getEndTime()) + "\u6642\u306b\u6b21\u56de\u306e\u4f7f\u7528\u6599\u3092\u5f15\u304d\u51fa\u3059");
                            html.replace((CharSequence)"%change_item%", "[<a action=\"bypass -h npc_%objectId%_manage other item_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + item);
                        } else {
                            html.replace((CharSequence)"%item%", "\u975e\u6d3b\u6027\u5316");
                            html.replace((CharSequence)"%item_period%", "\u975e\u6d3b\u6027\u5316");
                            html.replace((CharSequence)"%change_item%", item);
                        }
                        this.sendHtmlMessage(player, html);
                    } else if (val.equalsIgnoreCase("deco") && !this.getClanHall().isSiegableHall()) {
                        if (st.countTokens() >= 1) {
                            if (this.getClanHall().getOwnerId() == 0) {
                                player.sendMessage("This clan hall has no owner, you cannot change the configuration.");
                                return;
                            }
                            val = st.nextToken();
                            if (val.equalsIgnoreCase("curtains_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "deco curtains 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("fixtures_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "deco fixtures 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_curtains")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "\u30ab\u30fc\u30c6\u30f3(\u88c5\u98fe)");
                                int stage = Integer.parseInt(val);
                                switch (stage) {
                                    case 1: {
                                        cost = Config.CH_CURTAIN1_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.CH_CURTAIN2_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", Util.formatAdena(cost) + "</font>\u30a2\u30c7\u30ca/" + Config.CH_CURTAIN_FEE_RATIO / 1000L / 60L / 60L / 24L + "\u65e5</font>");
                                html.replace((CharSequence)"%use%", "\u30ab\u30fc\u30c6\u30f3\u3067\u30a2\u30b8\u30c8\u306e\u98fe\u308a\u4ed8\u3051\u304c\u3067\u304d\u307e\u3059\u3002");
                                html.replace((CharSequence)"%apply%", "deco curtains " + stage);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_fixtures")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "\u6b63\u9762\u58c7(\u88c5\u98fe)");
                                int stage = Integer.parseInt(val);
                                switch (stage) {
                                    case 1: {
                                        cost = Config.CH_FRONT1_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.CH_FRONT2_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", Util.formatAdena(cost) + "</font>\u30a2\u30c7\u30ca/" + Config.CH_FRONT_FEE_RATIO / 1000L / 60L / 60L / 24L + "\u65e5</font>");
                                html.replace((CharSequence)"%use%", "\u30a2\u30b8\u30c8\u306e\u98fe\u308a\u4ed8\u3051\u304c\u3067\u304d\u307e\u3059\u3002");
                                html.replace((CharSequence)"%apply%", "deco fixtures " + stage);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("curtains")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Config.DEBUG) {
                                        _log.warning("Deco curtains editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply_confirmed.htm");
                                    if (this.getClanHall().getFunction(8) != null && this.getClanHall().getFunction(8).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-used.htm");
                                        html.replace((CharSequence)"%val%", val + "\u6bb5\u968e");
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int lvl = Integer.parseInt(val);
                                    switch (lvl) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 1: {
                                            fee = Config.CH_CURTAIN1_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.CH_CURTAIN2_FEE;
                                        }
                                    }
                                    if (!this.getClanHall().updateFunctions(player, 8, lvl, fee, Config.CH_CURTAIN_FEE_RATIO, this.getClanHall().getFunction(8) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.revalidateDeco(player);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                            if (val.equalsIgnoreCase("fixtures")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Config.DEBUG) {
                                        _log.warning("Deco fixtures editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply_confirmed.htm");
                                    if (this.getClanHall().getFunction(7) != null && this.getClanHall().getFunction(7).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-used.htm");
                                        html.replace((CharSequence)"%val%", val + "\u6bb5\u968e");
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int lvl = Integer.parseInt(val);
                                    switch (lvl) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 1: {
                                            fee = Config.CH_FRONT1_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.CH_FRONT2_FEE;
                                        }
                                    }
                                    if (!this.getClanHall().updateFunctions(player, 7, lvl, fee, Config.CH_FRONT_FEE_RATIO, this.getClanHall().getFunction(7) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.revalidateDeco(player);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                        }
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/deco.htm");
                        String curtains = "[<a action=\"bypass -h npc_%objectId%_manage deco edit_curtains 1\">1\u6bb5\u968e</a>][<a action=\"bypass -h npc_%objectId%_manage deco edit_curtains 2\">2\u6bb5\u968e</a>]";
                        String fixtures = "[<a action=\"bypass -h npc_%objectId%_manage deco edit_fixtures 1\">1\u6bb5\u968e</a>][<a action=\"bypass -h npc_%objectId%_manage deco edit_fixtures 2\">2\u6bb5\u968e</a>]";
                        if (this.getClanHall().getFunction(8) != null) {
                            html.replace((CharSequence)"%curtain%", this.getClanHall().getFunction(8).getLvl() + "\u6bb5\u968e" + "</font> (<font color=\"FFAABB\">" + this.getClanHall().getFunction(8).getLease() + "</font>\u30a2\u30c7\u30ca/" + Config.CH_CURTAIN_FEE_RATIO / 1000L / 60L / 60L / 24L + "\u65e5)");
                            html.replace((CharSequence)"%curtain_period%", format.format(this.getClanHall().getFunction(8).getEndTime()) + "\u6642\u306b\u6b21\u56de\u306e\u4f7f\u7528\u6599\u3092\u5f15\u304d\u51fa\u3059");
                            html.replace((CharSequence)"%change_curtain%", "[<a action=\"bypass -h npc_%objectId%_manage deco curtains_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + curtains);
                        } else {
                            html.replace((CharSequence)"%curtain%", "\u975e\u6d3b\u6027\u5316");
                            html.replace((CharSequence)"%curtain_period%", "\u975e\u6d3b\u6027\u5316");
                            html.replace((CharSequence)"%change_curtain%", curtains);
                        }
                        if (this.getClanHall().getFunction(7) != null) {
                            html.replace((CharSequence)"%fixture%", this.getClanHall().getFunction(7).getLvl() + "\u6bb5\u968e" + "</font> (<font color=\"FFAABB\">" + this.getClanHall().getFunction(7).getLease() + "</font>\u30a2\u30c7\u30ca/" + Config.CH_FRONT_FEE_RATIO / 1000L / 60L / 60L / 24L + "\u65e5)");
                            html.replace((CharSequence)"%fixture_period%", format.format(this.getClanHall().getFunction(7).getEndTime()) + "\u6642\u306b\u6b21\u56de\u306e\u4f7f\u7528\u6599\u3092\u5f15\u304d\u51fa\u3059");
                            html.replace((CharSequence)"%change_fixture%", "[<a action=\"bypass -h npc_%objectId%_manage deco fixtures_cancel\">\u975e\u6d3b\u6027\u5316</a>]" + fixtures);
                        } else {
                            html.replace((CharSequence)"%fixture%", "\u975e\u6d3b\u6027\u5316");
                            html.replace((CharSequence)"%fixture_period%", "\u975e\u6d3b\u6027\u5316");
                            html.replace((CharSequence)"%change_fixture%", fixtures);
                        }
                        this.sendHtmlMessage(player, html);
                    } else if (val.equalsIgnoreCase("back")) {
                        this.showChatWindow(player);
                    } else {
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), this.getClanHall().isSiegableHall() ? "data/html/clanHallManager/manage_siegable.htm" : "data/html/clanHallManager/manage.htm");
                        this.sendHtmlMessage(player, html);
                    }
                } else {
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/not_authorized.htm");
                    this.sendHtmlMessage(player, html);
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("support")) {
                if (player.isCursedWeaponEquipped()) {
                    player.sendMessage("The wielder of a cursed weapon cannot receive outside heals or buffs");
                    return;
                }
                this.setTarget(player);
                if (val.isEmpty()) {
                    return;
                }
                try {
                    int skill_id = Integer.parseInt(val);
                    try {
                        L2Skill skill;
                        int skill_lvl = 0;
                        if (st.countTokens() >= 1) {
                            skill_lvl = Integer.parseInt(st.nextToken());
                        }
                        if ((skill = SkillTable.getInstance().getInfo(skill_id, skill_lvl)).getSkillType() == L2SkillType.SUMMON) {
                            player.doSimultaneousCast(skill);
                        } else if (Config.CH_BUFF_FREE || this.getCurrentMp() >= (double)(skill.getMpConsume() + skill.getMpInitialConsume())) {
                            this.doCast(skill);
                        } else {
                            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                            html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/support-no_mana.htm");
                            html.replace((CharSequence)"%mp%", (int)this.getCurrentMp());
                            this.sendHtmlMessage(player, html);
                            return;
                        }
                        if (this.getClanHall().getFunction(6) == null) {
                            return;
                        }
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        if (this.getClanHall().getFunction(6).getLvl() == 0) {
                            return;
                        }
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/support-done.htm");
                        html.replace((CharSequence)"%mp%", (int)this.getCurrentMp());
                        this.sendHtmlMessage(player, html);
                    }
                    catch (Exception e) {
                        player.sendMessage("Invalid skill level, contact your admin!");
                    }
                }
                catch (Exception e) {
                    player.sendMessage("Invalid skill level, contact your admin!");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("list_back")) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                String file = "data/html/clanHallManager/chamberlain-" + this.getId() + ".htm";
                String content = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), file);
                if (content == null) {
                    file = "data/html/clanHallManager/chamberlain.htm";
                    content = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), file);
                }
                html.setHtml(content);
                html.replace((CharSequence)"%objectId%", this.getObjectId());
                html.replace((CharSequence)"%npcname%", this.getName());
                this.sendHtmlMessage(player, html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("support_back")) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                if (this.getClanHall().getFunction(6).getLvl() == 0) {
                    return;
                }
                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/support" + this.getClanHall().getFunction(6).getLvl() + ".htm");
                html.replace((CharSequence)"%mp%", (int)this.getStatus().getCurrentMp());
                this.sendHtmlMessage(player, html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("goto")) {
                int whereTo = Integer.parseInt(val);
                this.doTeleport(player, whereTo);
                return;
            }
        }
        super.onBypassFeedback(player, command);
    }

    private void sendHtmlMessage(L2PcInstance player, NpcHtmlMessage html) {
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%npcId%", this.getId());
        player.sendPacket(html);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        String content = null;
        int condition = this.validateCondition(player);
        if (condition == 3) {
            content = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/clanHallManager/chamberlain-" + this.getId() + ".htm");
            if (content == null) {
                content = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/clanHallManager/chamberlain.htm");
            }
        } else if (condition == 0) {
            content = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/clanHallManager/chamberlain-of.htm");
        }
        if (content == null) {
            content = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/clanHallManager/chamberlain-no.htm");
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setHtml(content);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%npcId%", this.getId());
        player.sendPacket(html);
    }

    protected int validateCondition(L2PcInstance player) {
        if (this.getClanHall() == null) {
            return 1;
        }
        if (player.canOverrideCond(PcCondOverride.CLANHALL_CONDITIONS)) {
            return 3;
        }
        if (player.getClan() != null) {
            if (this.getClanHall().getOwnerId() == player.getClanId()) {
                return 3;
            }
            return 0;
        }
        return 1;
    }

    public final ClanHall getClanHall() {
        if (this._clanHallId < 0) {
            ClanHall temp = ClanHallManager.getInstance().getNearbyClanHall(this.getX(), this.getY(), 500);
            if (temp == null) {
                temp = CHSiegeManager.getInstance().getNearbyClanHall(this);
            }
            if (temp != null) {
                this._clanHallId = temp.getId();
            }
            if (this._clanHallId < 0) {
                return null;
            }
        }
        return ClanHallManager.getInstance().getClanHallById(this._clanHallId);
    }

    private void doTeleport(L2PcInstance player, int val) {
        L2TeleportLocation list;
        if (Config.DEBUG) {
            _log.warning("doTeleport(L2PcInstance player, int val) is called");
        }
        if ((list = TeleportLocationTable.getInstance().getTemplate(val)) != null) {
            if (player.isCombatFlagEquipped()) {
                player.sendPacket(SystemMessageId.YOU_CANNOT_TELEPORT_WHILE_IN_POSSESSION_OF_A_WARD);
                return;
            }
            if (player.destroyItemByItemId("Teleport", list.getItemId(), list.getPrice(), this, true)) {
                if (Config.DEBUG) {
                    _log.warning("Teleporting player " + player.getName() + " for CH to new location: " + list.getLocX() + ":" + list.getLocY() + ":" + list.getLocZ());
                }
                player.teleToLocation(list.getLocX(), list.getLocY(), list.getLocZ());
            }
        } else {
            _log.warning("No teleport destination with id:" + val);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    private void revalidateDeco(L2PcInstance player) {
        AuctionableHall ch = ClanHallManager.getInstance().getClanHallByOwner(player.getClan());
        if (ch == null) {
            return;
        }
        AgitDecoInfo bl = new AgitDecoInfo(ch);
        player.sendPacket(bl);
    }
}

