/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.ai.L2ControllableMobAI;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;

public class L2ControllableMobInstance
extends L2MonsterInstance {
    private boolean _isInvul;
    private L2ControllableMobAI _aiBackup;

    @Override
    public boolean isAggressive() {
        return true;
    }

    @Override
    public int getAggroRange() {
        return 500;
    }

    public L2ControllableMobInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2ControllableMobInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public L2CharacterAI getAI() {
        L2CharacterAI ai = this._ai;
        if (ai == null) {
            L2ControllableMobInstance l2ControllableMobInstance = this;
            synchronized (l2ControllableMobInstance) {
                if (this._ai == null && this._aiBackup == null) {
                    this._ai = new L2ControllableMobAI(new ControllableAIAcessor());
                    this._aiBackup = (L2ControllableMobAI)this._ai;
                } else {
                    this._ai = this._aiBackup;
                }
                return this._ai;
            }
        }
        return ai;
    }

    @Override
    public boolean isInvul() {
        return this._isInvul;
    }

    public void setInvul(boolean isInvul) {
        this._isInvul = isInvul;
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        this.removeAI();
        return true;
    }

    @Override
    public boolean deleteMe() {
        this.removeAI();
        return super.deleteMe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAI() {
        L2ControllableMobInstance l2ControllableMobInstance = this;
        synchronized (l2ControllableMobInstance) {
            if (this._aiBackup != null) {
                this._aiBackup.setIntention(CtrlIntention.AI_INTENTION_IDLE);
                this._aiBackup = null;
                this._ai = null;
            }
        }
    }

    protected class ControllableAIAcessor
    extends L2Character.AIAccessor {
        protected ControllableAIAcessor() {
        }

        @Override
        public void detachAI() {
        }
    }
}

