/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.ai.L2DoorAI;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2DefenderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeSummonInstance;
import com.l2jserver.gameserver.model.actor.knownlist.DoorKnownList;
import com.l2jserver.gameserver.model.actor.stat.DoorStat;
import com.l2jserver.gameserver.model.actor.status.DoorStatus;
import com.l2jserver.gameserver.model.actor.templates.L2DoorTemplate;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.DoorStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.OnEventTrigger;
import com.l2jserver.gameserver.network.serverpackets.StaticObject;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Rnd;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javolution.util.FastList;

public class L2DoorInstance
extends L2Character {
    public static final byte OPEN_BY_CLICK = 1;
    public static final byte OPEN_BY_TIME = 2;
    public static final byte OPEN_BY_ITEM = 4;
    public static final byte OPEN_BY_SKILL = 8;
    public static final byte OPEN_BY_CYCLE = 16;
    private int _castleIndex = -2;
    private int _fortIndex = -2;
    private ClanHall _clanHall;
    private boolean _open = false;
    private boolean _isAttackableDoor = false;
    private boolean _isTargetable;
    private int _meshindex = 1;
    private Future<?> _autoCloseTask;

    public L2DoorInstance(int objectId, L2DoorTemplate template) {
        super(objectId, template);
        ClanHall hall;
        int clanhallId;
        this.setInstanceType(InstanceType.L2DoorInstance);
        this.setIsInvul(false);
        this.setLethalable(false);
        this._open = template.isOpenByDefault();
        this._isAttackableDoor = template.isAttackable();
        this._isTargetable = template.isTargetable();
        if (this.getGroupName() != null) {
            DoorTable.addDoorGroup(this.getGroupName(), this.getId());
        }
        if (this.isOpenableByTime()) {
            this.startTimerOpen();
        }
        if ((clanhallId = template.getClanHallId()) > 0 && (hall = ClanHallManager.getAllClanHalls().get(clanhallId)) != null) {
            this.setClanHall(hall);
            hall.getDoors().add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public L2CharacterAI getAI() {
        L2CharacterAI ai = this._ai;
        if (ai == null) {
            L2DoorInstance l2DoorInstance = this;
            synchronized (l2DoorInstance) {
                if (this._ai == null) {
                    this._ai = new L2DoorAI(new AIAccessor());
                }
                return this._ai;
            }
        }
        return ai;
    }

    private void startTimerOpen() {
        int delay;
        int n = delay = this._open ? this.getTemplate().getOpenTime() : this.getTemplate().getCloseTime();
        if (this.getTemplate().getRandomTime() > 0) {
            delay += Rnd.get(this.getTemplate().getRandomTime());
        }
        ThreadPoolManager.getInstance().scheduleGeneral(new TimerOpen(), delay * 1000);
    }

    @Override
    public final DoorKnownList getKnownList() {
        return (DoorKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new DoorKnownList(this));
    }

    @Override
    public L2DoorTemplate getTemplate() {
        return (L2DoorTemplate)super.getTemplate();
    }

    @Override
    public final DoorStatus getStatus() {
        return (DoorStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new DoorStatus(this));
    }

    @Override
    public void initCharStat() {
        this.setStat(new DoorStat(this));
    }

    @Override
    public DoorStat getStat() {
        return (DoorStat)super.getStat();
    }

    public final boolean isOpenableBySkill() {
        return (this.getTemplate().getOpenType() & 8) != 0;
    }

    public final boolean isOpenableByItem() {
        return (this.getTemplate().getOpenType() & 4) != 0;
    }

    public final boolean isOpenableByClick() {
        return (this.getTemplate().getOpenType() & 1) != 0;
    }

    public final boolean isOpenableByTime() {
        return (this.getTemplate().getOpenType() & 2) != 0;
    }

    public final boolean isOpenableByCycle() {
        return (this.getTemplate().getOpenType() & 0x10) != 0;
    }

    @Override
    public final int getLevel() {
        return this.getTemplate().getLevel();
    }

    @Override
    public int getId() {
        return this.getTemplate().getId();
    }

    public int getDoorId() {
        return this.getId();
    }

    public boolean getOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        this._open = open;
        if (this.getChildId() > 0) {
            L2DoorInstance sibling = this.getSiblingDoor(this.getChildId());
            if (sibling != null) {
                sibling.notifyChildEvent(open);
            } else {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": cannot find child id: " + this.getChildId());
            }
        }
    }

    public boolean getIsAttackableDoor() {
        return this._isAttackableDoor;
    }

    public boolean getIsShowHp() {
        return this.getTemplate().isShowHp();
    }

    public void setIsAttackableDoor(boolean val) {
        this._isAttackableDoor = val;
    }

    public int getDamage() {
        int dmg = 6 - (int)Math.ceil(this.getCurrentHp() / (double)this.getMaxHp() * 6.0);
        if (dmg > 6) {
            return 6;
        }
        if (dmg < 0) {
            return 0;
        }
        return dmg;
    }

    public final Castle getCastle() {
        if (this._castleIndex < 0) {
            this._castleIndex = CastleManager.getInstance().getCastleIndex(this);
        }
        if (this._castleIndex < 0) {
            return null;
        }
        return CastleManager.getInstance().getCastles().get(this._castleIndex);
    }

    public final Fort getFort() {
        if (this._fortIndex < 0) {
            this._fortIndex = FortManager.getInstance().getFortIndex(this);
        }
        if (this._fortIndex < 0) {
            return null;
        }
        return FortManager.getInstance().getForts().get(this._fortIndex);
    }

    public void setClanHall(ClanHall clanhall) {
        this._clanHall = clanhall;
    }

    public ClanHall getClanHall() {
        return this._clanHall;
    }

    public boolean isEnemy() {
        if (this.getCastle() != null && this.getCastle().getResidenceId() > 0 && this.getCastle().getZone().isActive() && this.getIsShowHp()) {
            return true;
        }
        if (this.getFort() != null && this.getFort().getResidenceId() > 0 && this.getFort().getZone().isActive() && this.getIsShowHp()) {
            return true;
        }
        return this.getClanHall() != null && this.getClanHall().isSiegableHall() && ((SiegableHall)this.getClanHall()).getSiegeZone().isActive() && this.getIsShowHp();
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        L2Clan clan;
        int activeSiegeId;
        boolean isFort;
        if (!(attacker instanceof L2Playable)) {
            return false;
        }
        if (this.getIsAttackableDoor()) {
            return true;
        }
        if (!this.getIsShowHp()) {
            return false;
        }
        L2PcInstance actingPlayer = attacker.getActingPlayer();
        if (this.getClanHall() != null) {
            SiegableHall hall = (SiegableHall)this.getClanHall();
            if (!hall.isSiegableHall()) {
                return false;
            }
            return hall.isInSiege() && hall.getSiege().doorIsAutoAttackable() && hall.getSiege().checkIsAttacker(actingPlayer.getClan());
        }
        boolean isCastle = this.getCastle() != null && this.getCastle().getResidenceId() > 0 && this.getCastle().getZone().isActive();
        boolean bl = isFort = this.getFort() != null && this.getFort().getResidenceId() > 0 && this.getFort().getZone().isActive();
        int n = this.getFort() != null ? this.getFort().getResidenceId() : (activeSiegeId = this.getCastle() != null ? this.getCastle().getResidenceId() : 0);
        if (TerritoryWarManager.getInstance().isTWInProgress()) {
            return !TerritoryWarManager.getInstance().isAllyField(actingPlayer, activeSiegeId);
        }
        if (isFort ? (clan = actingPlayer.getClan()) != null && clan == this.getFort().getOwnerClan() : isCastle && (clan = actingPlayer.getClan()) != null && clan.getId() == this.getCastle().getOwnerId()) {
            return false;
        }
        return isCastle || isFort;
    }

    @Override
    public void updateAbnormalEffect() {
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        return null;
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    @Override
    public void broadcastStatusUpdate() {
        Collection knownPlayers = this.getKnownList().getKnownPlayers().values();
        if (knownPlayers == null || knownPlayers.isEmpty()) {
            return;
        }
        StaticObject su = new StaticObject(this, false);
        StaticObject targetableSu = new StaticObject(this, true);
        DoorStatusUpdate dsu = new DoorStatusUpdate(this);
        OnEventTrigger oe = null;
        if (this.getEmitter() > 0) {
            oe = new OnEventTrigger(this, this.getOpen());
        }
        for (L2PcInstance player : knownPlayers) {
            if (player == null) continue;
            if (player.isGM() || this.getCastle() != null && this.getCastle().getResidenceId() > 0 || this.getFort() != null && this.getFort().getResidenceId() > 0) {
                player.sendPacket(targetableSu);
            } else {
                player.sendPacket(su);
            }
            player.sendPacket(dsu);
            if (oe == null) continue;
            player.sendPacket(oe);
        }
    }

    public final void openMe() {
        if (this.getGroupName() != null) {
            this.manageGroupOpen(true, this.getGroupName());
            return;
        }
        this.setOpen(true);
        this.broadcastStatusUpdate();
        this.startAutoCloseTask();
    }

    public final void closeMe() {
        Future<?> oldTask = this._autoCloseTask;
        if (oldTask != null) {
            this._autoCloseTask = null;
            oldTask.cancel(false);
        }
        if (this.getGroupName() != null) {
            this.manageGroupOpen(false, this.getGroupName());
            return;
        }
        this.setOpen(false);
        this.broadcastStatusUpdate();
    }

    private void manageGroupOpen(boolean open, String groupName) {
        Set<Integer> set = DoorTable.getDoorsByGroup(groupName);
        L2DoorInstance first = null;
        for (Integer id : set) {
            L2DoorInstance door = this.getSiblingDoor(id);
            if (first == null) {
                first = door;
            }
            if (door.getOpen() == open) continue;
            door.setOpen(open);
            door.broadcastStatusUpdate();
        }
        if (first != null && open) {
            super.startAutoCloseTask();
        }
    }

    private void notifyChildEvent(boolean open) {
        byte openThis;
        byte by = openThis = open ? this.getTemplate().getMasterDoorOpen() : this.getTemplate().getMasterDoorClose();
        if (openThis == 0) {
            return;
        }
        if (openThis == 1) {
            this.openMe();
        } else if (openThis == -1) {
            this.closeMe();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getTemplate().getId() + "](" + this.getObjectId() + ")";
    }

    public String getDoorName() {
        return this.getTemplate().getName();
    }

    public int getX(int i) {
        return this.getTemplate().getNodeX()[i];
    }

    public int getY(int i) {
        return this.getTemplate().getNodeY()[i];
    }

    public int getZMin() {
        return this.getTemplate().getNodeZ();
    }

    public int getZMax() {
        return this.getTemplate().getNodeZ() + this.getTemplate().getHeight();
    }

    public Collection<L2DefenderInstance> getKnownDefenders() {
        FastList result = new FastList();
        Collection objs = this.getKnownList().getKnownObjects().values();
        for (L2Object obj : objs) {
            if (!(obj instanceof L2DefenderInstance)) continue;
            result.add((Object)((L2DefenderInstance)obj));
        }
        return result;
    }

    public void setMeshIndex(int mesh) {
        this._meshindex = mesh;
    }

    public int getMeshIndex() {
        return this._meshindex;
    }

    public int getEmitter() {
        return this.getTemplate().getEmmiter();
    }

    public boolean isWall() {
        return this.getTemplate().isWall();
    }

    public String getGroupName() {
        return this.getTemplate().getGroupName();
    }

    public int getChildId() {
        return this.getTemplate().getChildDoorId();
    }

    @Override
    public void reduceCurrentHp(double damage, L2Character attacker, boolean awake, boolean isDOT, L2Skill skill) {
        if (this.isWall() && !(attacker instanceof L2SiegeSummonInstance) && this.getInstanceId() == 0) {
            return;
        }
        super.reduceCurrentHp(damage, attacker, awake, isDOT, skill);
    }

    @Override
    public void reduceCurrentHpByDOT(double i, L2Character attacker, L2Skill skill) {
    }

    @Override
    public boolean doDie(L2Character killer) {
        boolean isHall;
        if (!super.doDie(killer)) {
            return false;
        }
        boolean isFort = this.getFort() != null && this.getFort().getResidenceId() > 0 && this.getFort().getSiege().getIsInProgress();
        boolean isCastle = this.getCastle() != null && this.getCastle().getResidenceId() > 0 && this.getCastle().getSiege().getIsInProgress();
        boolean bl = isHall = this.getClanHall() != null && this.getClanHall().isSiegableHall() && ((SiegableHall)this.getClanHall()).isInSiege();
        if (isFort || isCastle || isHall) {
            this.broadcastPacket(SystemMessage.getSystemMessage(SystemMessageId.CASTLE_GATE_BROKEN_DOWN));
        }
        return true;
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (this.getEmitter() > 0) {
            activeChar.sendPacket(new OnEventTrigger(this, this.getOpen()));
        }
        activeChar.sendPacket(new StaticObject(this, activeChar.isGM()));
    }

    public void setTargetable(boolean b) {
        this._isTargetable = b;
        this.broadcastStatusUpdate();
    }

    @Override
    public boolean isTargetable() {
        return this._isTargetable;
    }

    public boolean checkCollision() {
        return this.getTemplate().isCheckCollision();
    }

    private L2DoorInstance getSiblingDoor(int doorId) {
        if (this.getInstanceId() == 0) {
            return DoorTable.getInstance().getDoor(doorId);
        }
        Instance inst = InstanceManager.getInstance().getInstance(this.getInstanceId());
        if (inst != null) {
            return inst.getDoor(doorId);
        }
        return null;
    }

    private void startAutoCloseTask() {
        if (this.getTemplate().getCloseTime() < 0 || this.isOpenableByTime()) {
            return;
        }
        Future<?> oldTask = this._autoCloseTask;
        if (oldTask != null) {
            this._autoCloseTask = null;
            oldTask.cancel(false);
        }
        this._autoCloseTask = ThreadPoolManager.getInstance().scheduleGeneral(new AutoClose(), this.getTemplate().getCloseTime() * 1000);
    }

    @Override
    public boolean isDoor() {
        return true;
    }

    class TimerOpen
    implements Runnable {
        TimerOpen() {
        }

        @Override
        public void run() {
            int delay;
            boolean open = L2DoorInstance.this.getOpen();
            if (open) {
                L2DoorInstance.this.closeMe();
            } else {
                L2DoorInstance.this.openMe();
            }
            int n = delay = open ? L2DoorInstance.this.getTemplate().getCloseTime() : L2DoorInstance.this.getTemplate().getOpenTime();
            if (L2DoorInstance.this.getTemplate().getRandomTime() > 0) {
                delay += Rnd.get(L2DoorInstance.this.getTemplate().getRandomTime());
            }
            ThreadPoolManager.getInstance().scheduleGeneral(this, delay * 1000);
        }
    }

    class AutoClose
    implements Runnable {
        AutoClose() {
        }

        @Override
        public void run() {
            if (L2DoorInstance.this.getOpen()) {
                L2DoorInstance.this.closeMe();
            }
        }
    }

    public class AIAccessor
    extends L2Character.AIAccessor {
        @Override
        public L2DoorInstance getActor() {
            return L2DoorInstance.this;
        }

        @Override
        public void moveTo(int x, int y, int z, int offset) {
        }

        @Override
        public void moveTo(int x, int y, int z) {
        }

        @Override
        public void stopMove(Location loc) {
        }

        @Override
        public void doAttack(L2Character target) {
        }

        @Override
        public void doCast(L2Skill skill) {
        }
    }
}

