/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2EventMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.util.Rnd;
import java.util.Collection;

public final class L2EventChestInstance
extends L2EventMonsterInstance {
    private final boolean _isVisible = false;
    boolean _isTriggered = false;
    private static final int TRANSFORMATION_ID = 105;
    private static final int BONUS_RATE = 20;
    boolean _bonus;
    Runnable _hideTask = null;
    long _lastSocialBroadcast = 0L;
    private static final int _minimalSocialInterval = 5000;
    static final int[] TRIGGERE_SAY = new int[]{1600008, 1600009};
    private static final int[] RANDAM_SAY = new int[]{1600007, 1600010, 1600022};
    static final int[] HIDE_SAY = new int[]{1600004, 1600005};

    void autoChat(int[] stringId, int type) {
        L2EventChestInstance.autoChat(this, stringId, type);
    }

    public static void autoChat(L2Npc npc, int[] stringId, int type) {
        NpcSay packet = new NpcSay(npc.getObjectId(), type, npc.getTemplate().getIdTemplate(), stringId[Rnd.get(stringId.length)]);
        for (L2PcInstance player : npc.getKnownList().getKnownPlayers().values()) {
            if (player == null || player.getTransformationId() != 105) continue;
            player.sendPacket(packet);
        }
    }

    public boolean isTriggered() {
        return this._isTriggered;
    }

    public boolean hasBonus() {
        return this._bonus;
    }

    public L2EventChestInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setIsNoRndWalk(true);
        this.disableCoreAI(true);
        this.eventSetDropOnGround(true);
        this.eventSetBlockOffensiveSkills(true);
    }

    public boolean canSee(L2Character cha) {
        if (cha == null) {
            return false;
        }
        return cha.isGM();
    }

    public void trigger() {
        if (this._isTriggered) {
            return;
        }
        this._isTriggered = true;
        this.broadcastPacket(new AbstractNpcInfo.NpcInfo(this, null));
        this._hideTask = new Runnable(){
            private int _sequenceId = 0;

            @Override
            public void run() {
                if (L2EventChestInstance.this._hideTask != this) {
                    return;
                }
                if (!L2EventChestInstance.this._isTriggered || L2EventChestInstance.this.isDecayed() || L2EventChestInstance.this.isDead()) {
                    L2EventChestInstance.this._hideTask = null;
                    return;
                }
                switch (++this._sequenceId) {
                    case 1: {
                        boolean bl = L2EventChestInstance.this._bonus = Rnd.get(100) <= 20;
                        if (L2EventChestInstance.this._bonus) {
                            L2EventChestInstance me = L2EventChestInstance.this;
                            L2Skill firework = SkillTable.FrequentSkill.FIREWORK.getSkill();
                            L2EventChestInstance.this.broadcastPacket(new MagicSkillUse(me, me, firework.getId(), firework.getLevel(), firework.getHitTime(), firework.getReuseDelay()));
                        }
                        L2EventChestInstance.this.autoChat(TRIGGERE_SAY, 0);
                        L2EventChestInstance.this._lastSocialBroadcast = System.currentTimeMillis();
                        L2EventChestInstance.this.startRandomAnimationTimer();
                        ThreadPoolManager.getInstance().scheduleGeneral(this, Rnd.get(15000, 20000));
                        return;
                    }
                    case 2: {
                        L2EventChestInstance.this.stopRandomAnimationTimer();
                        L2EventChestInstance.this.autoChat(HIDE_SAY, 0);
                        ThreadPoolManager.getInstance().scheduleGeneral(this, 1000L);
                        return;
                    }
                    case 3: {
                        L2EventChestInstance.this.decayMe();
                        L2EventChestInstance.this._isTriggered = false;
                        L2EventChestInstance.this.spawnMe();
                        L2EventChestInstance.this._hideTask = null;
                        return;
                    }
                }
            }
        };
        ThreadPoolManager.getInstance().executeTask(this._hideTask);
    }

    @Override
    public void onRandomAnimation(int animationId) {
        if (!this._isTriggered || this.isDecayed() || this.isDead()) {
            this.stopRandomAnimationTimer();
        } else {
            long now = System.currentTimeMillis();
            if (now - this._lastSocialBroadcast > 5000L) {
                this._lastSocialBroadcast = now;
                this.autoChat(RANDAM_SAY, 0);
            }
        }
    }

    @Override
    public boolean hasRandomAnimation() {
        return this._isTriggered;
    }

    public void stopRandomAnimationTimer() {
        this._rAniTask = null;
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (this._isTriggered || this.canSee(activeChar)) {
            activeChar.sendPacket(new AbstractNpcInfo.NpcInfo(this, activeChar));
        }
    }

    @Override
    public void broadcastPacket(L2GameServerPacket mov) {
        Collection plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || !this._isTriggered && !this.canSee(player)) continue;
            player.sendPacket(mov);
        }
    }

    @Override
    public void broadcastPacket(L2GameServerPacket mov, int radiusInKnownlist) {
        Collection plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || !this.isInsideRadius(player, radiusInKnownlist, false, false) || !this._isTriggered && !this.canSee(player)) continue;
            player.sendPacket(mov);
        }
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }
}

