/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;

public class L2FestivalMonsterInstance
extends L2MonsterInstance {
    protected int _bonusMultiplier = 1;

    public L2FestivalMonsterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2FestivalMonsterInstance);
    }

    public void setOfferingBonus(int bonusMultiplier) {
        this._bonusMultiplier = bonusMultiplier;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return !(attacker instanceof L2FestivalMonsterInstance);
    }

    @Override
    public boolean isAggressive() {
        return true;
    }

    @Override
    public boolean hasRandomAnimation() {
        return false;
    }

    @Override
    public void doItemDrop(L2Character lastAttacker) {
        L2PcInstance killingChar = null;
        if (!(lastAttacker instanceof L2PcInstance)) {
            return;
        }
        killingChar = (L2PcInstance)lastAttacker;
        L2Party associatedParty = killingChar.getParty();
        if (associatedParty == null) {
            return;
        }
        L2PcInstance partyLeader = associatedParty.getLeader();
        L2ItemInstance addedOfferings = partyLeader.getInventory().addItem("Sign", 5901, this._bonusMultiplier, partyLeader, this);
        InventoryUpdate iu = new InventoryUpdate();
        if (addedOfferings.getCount() != (long)this._bonusMultiplier) {
            iu.addModifiedItem(addedOfferings);
        } else {
            iu.addNewItem(addedOfferings);
        }
        partyLeader.sendPacket(iu);
        super.doItemDrop(lastAttacker);
    }
}

