/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.enums.TrapAction;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.TrapKnownList;
import com.l2jserver.gameserver.model.actor.tasks.npc.trap.TrapTask;
import com.l2jserver.gameserver.model.actor.tasks.npc.trap.TrapTriggerTask;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameManager;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import java.util.ArrayList;
import java.util.List;

public final class L2TrapInstance
extends L2Npc {
    private static final int TICK = 1000;
    private boolean _hasLifeTime;
    private boolean _isInArena = false;
    private boolean _isTriggered;
    private final int _lifeTime;
    private L2PcInstance _owner;
    private final List<Integer> _playersWhoDetectedMe = new ArrayList<Integer>();
    private final SkillHolder _skill;
    private int _remainingTime;

    public L2TrapInstance(int objectId, L2NpcTemplate template, int instanceId, int lifeTime) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2TrapInstance);
        this.setInstanceId(instanceId);
        this.setName(template.getName());
        this.setIsInvul(false);
        this._owner = null;
        this._isTriggered = false;
        this._skill = this.getTemplate().getParameters().getObject("trap_skill", SkillHolder.class);
        this._hasLifeTime = lifeTime >= 0;
        this._remainingTime = this._lifeTime = lifeTime != 0 ? lifeTime : 30000;
        if (this._skill != null) {
            ThreadPoolManager.getInstance().scheduleGeneral(new TrapTask(this), 1000L);
        }
    }

    public L2TrapInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, int lifeTime) {
        this(objectId, template, owner.getInstanceId(), lifeTime);
        this._owner = owner;
    }

    @Override
    public void broadcastPacket(L2GameServerPacket mov) {
        for (L2PcInstance player : this.getKnownList().getKnownPlayers().values()) {
            if (player == null || !this._isTriggered && !this.canBeSeen(player)) continue;
            player.sendPacket(mov);
        }
    }

    @Override
    public void broadcastPacket(L2GameServerPacket mov, int radiusInKnownlist) {
        for (L2PcInstance player : this.getKnownList().getKnownPlayers().values()) {
            if (player == null || !this.isInsideRadius(player, radiusInKnownlist, false, false) || !this._isTriggered && !this.canBeSeen(player)) continue;
            player.sendPacket(mov);
        }
    }

    public boolean canBeSeen(L2Character cha) {
        if (cha != null && this._playersWhoDetectedMe.contains(cha.getObjectId())) {
            return true;
        }
        if (this._owner == null || cha == null) {
            return false;
        }
        if (cha == this._owner) {
            return true;
        }
        if (cha instanceof L2PcInstance) {
            if (((L2PcInstance)cha).inObserverMode()) {
                return false;
            }
            if (this._owner.isInOlympiadMode() && ((L2PcInstance)cha).isInOlympiadMode() && ((L2PcInstance)cha).getOlympiadSide() != this._owner.getOlympiadSide()) {
                return false;
            }
        }
        if (this._isInArena) {
            return true;
        }
        return this._owner.isInParty() && cha.isInParty() && this._owner.getParty().getLeaderObjectId() == cha.getParty().getLeaderObjectId();
    }

    public boolean checkTarget(L2Character target) {
        L2PcInstance player;
        if (!L2Skill.checkForAreaOffensiveSkills(this, target, this._skill.getSkill(), this._isInArena)) {
            return false;
        }
        if (target instanceof L2PcInstance && ((L2PcInstance)target).inObserverMode()) {
            return false;
        }
        if (this._owner != null && this._owner.isInOlympiadMode() && (player = target.getActingPlayer()) != null && player.isInOlympiadMode() && player.getOlympiadSide() == this._owner.getOlympiadSide()) {
            return false;
        }
        if (this._isInArena) {
            return true;
        }
        if (this._owner != null) {
            if (target instanceof L2Attackable) {
                return true;
            }
            player = target.getActingPlayer();
            if (player == null || player.getPvpFlag() == 0 && player.getKarma() == 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean deleteMe() {
        if (this._owner != null) {
            this._owner.setTrap(null);
            this._owner = null;
        }
        return super.deleteMe();
    }

    @Override
    public L2PcInstance getActingPlayer() {
        return this._owner;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        return null;
    }

    public int getKarma() {
        return this._owner != null ? this._owner.getKarma() : 0;
    }

    @Override
    public TrapKnownList getKnownList() {
        return (TrapKnownList)super.getKnownList();
    }

    public L2PcInstance getOwner() {
        return this._owner;
    }

    public byte getPvpFlag() {
        return this._owner != null ? this._owner.getPvpFlag() : (byte)0;
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    public L2Skill getSkill() {
        return this._skill.getSkill();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new TrapKnownList(this));
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return !this.canBeSeen(attacker);
    }

    @Override
    public boolean isTrap() {
        return true;
    }

    public boolean isTriggered() {
        return this._isTriggered;
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this._isInArena = this.isInsideZone(ZoneId.PVP) && !this.isInsideZone(ZoneId.SIEGE);
        this._playersWhoDetectedMe.clear();
    }

    @Override
    public void sendDamageMessage(L2Character target, int damage, boolean mcrit, boolean pcrit, boolean miss) {
        if (miss || this._owner == null) {
            return;
        }
        if (this._owner.isInOlympiadMode() && target instanceof L2PcInstance && ((L2PcInstance)target).isInOlympiadMode() && ((L2PcInstance)target).getOlympiadGameId() == this._owner.getOlympiadGameId()) {
            OlympiadGameManager.getInstance().notifyCompetitorDamage(this.getOwner(), damage);
        }
        if (target.isInvul() && !(target instanceof L2NpcInstance)) {
            this._owner.sendPacket(SystemMessageId.ATTACK_WAS_BLOCKED);
        } else {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_DONE_S3_DAMAGE_TO_C2);
            sm.addCharName(this);
            sm.addCharName(target);
            sm.addNumber(damage);
            this._owner.sendPacket(sm);
        }
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (this._isTriggered || this.canBeSeen(activeChar)) {
            activeChar.sendPacket(new AbstractNpcInfo.TrapInfo(this, activeChar));
        }
    }

    public void setDetected(L2Character detector) {
        if (this._isInArena) {
            if (detector.isPlayable()) {
                this.sendInfo(detector.getActingPlayer());
            }
            return;
        }
        if (this._owner != null && this._owner.getPvpFlag() == 0 && this._owner.getKarma() == 0) {
            return;
        }
        this._playersWhoDetectedMe.add(detector.getObjectId());
        List<Quest> eventQuests = this.getTemplate().getEventQuests(QuestEventType.ON_TRAP_ACTION);
        if (eventQuests != null) {
            for (Quest quest : eventQuests) {
                quest.notifyTrapAction(this, detector, TrapAction.TRAP_DETECTED);
            }
        }
        if (detector.isPlayable()) {
            this.sendInfo(detector.getActingPlayer());
        }
    }

    public void stopDecay() {
        DecayTaskManager.getInstance().cancelDecayTask(this);
    }

    public void triggerTrap(L2Character target) {
        this._isTriggered = true;
        this.broadcastPacket(new AbstractNpcInfo.TrapInfo(this, null));
        this.setTarget(target);
        List<Quest> eventQuests = this.getTemplate().getEventQuests(QuestEventType.ON_TRAP_ACTION);
        if (eventQuests != null) {
            for (Quest quest : eventQuests) {
                quest.notifyTrapAction(this, target, TrapAction.TRAP_TRIGGERED);
            }
        }
        ThreadPoolManager.getInstance().scheduleGeneral(new TrapTriggerTask(this), 300L);
    }

    public void unSummon() {
        if (this._owner != null) {
            this._owner.setTrap(null);
            this._owner = null;
        }
        if (this.isVisible() && !this.isDead()) {
            if (this.getWorldRegion() != null) {
                this.getWorldRegion().removeFromZones(this);
            }
            this.deleteMe();
        }
    }

    @Override
    public void updateAbnormalEffect() {
    }

    public boolean hasLifeTime() {
        return this._hasLifeTime;
    }

    public void setHasLifeTime(boolean val) {
        this._hasLifeTime = val;
    }

    public int getRemainingTime() {
        return this._remainingTime;
    }

    public void setRemainingTime(int time) {
        this._remainingTime = time;
    }

    public int getLifeTime() {
        return this._lifeTime;
    }
}

