/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.tasks.player;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.AdminTable;
import com.l2jserver.gameserver.enums.IllegalActionPunishmentType;
import com.l2jserver.gameserver.instancemanager.PunishmentManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.punishment.PunishmentAffect;
import com.l2jserver.gameserver.model.punishment.PunishmentTask;
import com.l2jserver.gameserver.model.punishment.PunishmentType;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class IllegalPlayerActionTask
implements Runnable {
    private static final Logger _log = Logger.getLogger("audit");
    private final String _message;
    private final IllegalActionPunishmentType _punishment;
    private final L2PcInstance _actor;

    public IllegalPlayerActionTask(L2PcInstance actor, String message, IllegalActionPunishmentType punishment) {
        this._message = message;
        this._punishment = punishment;
        this._actor = actor;
        switch (punishment) {
            case KICK: {
                this._actor.sendMessage("You will be kicked for illegal action, GM informed.");
                break;
            }
            case KICKBAN: {
                if (!this._actor.isGM()) {
                    this._actor.setAccessLevel(-1);
                    this._actor.setAccountAccesslevel(-1);
                }
                this._actor.sendMessage("You are banned for illegal action, GM informed.");
                break;
            }
            case JAIL: {
                this._actor.sendMessage("Illegal action performed!");
                this._actor.sendMessage("You will be teleported to GM Consultation Service area and jailed.");
            }
        }
    }

    @Override
    public void run() {
        LogRecord record = new LogRecord(Level.INFO, "AUDIT:" + this._message);
        record.setLoggerName("audit");
        record.setParameters(new Object[]{this._actor, this._punishment});
        _log.log(record);
        AdminTable.getInstance().broadcastMessageToGMs(this._message);
        if (!this._actor.isGM()) {
            switch (this._punishment) {
                case BROADCAST: {
                    return;
                }
                case KICK: {
                    this._actor.logout(false);
                    break;
                }
                case KICKBAN: {
                    PunishmentManager.getInstance().startPunishment(new PunishmentTask(this._actor.getObjectId(), PunishmentAffect.CHARACTER, PunishmentType.BAN, System.currentTimeMillis() + (long)(Config.DEFAULT_PUNISH_PARAM * 1000), this._message, this.getClass().getSimpleName()));
                    break;
                }
                case JAIL: {
                    PunishmentManager.getInstance().startPunishment(new PunishmentTask(this._actor.getObjectId(), PunishmentAffect.CHARACTER, PunishmentType.JAIL, System.currentTimeMillis() + (long)(Config.DEFAULT_PUNISH_PARAM * 1000), this._message, this.getClass().getSimpleName()));
                }
            }
        }
    }
}

