/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.stats.Env;

public class ConditionPetType
extends Condition {
    private final int petType;

    public ConditionPetType(int petType) {
        this.petType = petType;
    }

    @Override
    public boolean testImpl(Env env) {
        if (!(env.getCharacter() instanceof L2PetInstance)) {
            return false;
        }
        int npcId = env.getCharacter().getId();
        if (PetDataTable.isStrider(npcId) && this.petType == 1) {
            return true;
        }
        if (PetDataTable.isGrowUpWolfGroup(npcId) && this.petType == 2) {
            return true;
        }
        if (PetDataTable.isHatchlingGroup(npcId) && this.petType == 4) {
            return true;
        }
        if (PetDataTable.isAllWolfGroup(npcId) && this.petType == 8) {
            return true;
        }
        if (PetDataTable.isBabyPetGroup(npcId) && this.petType == 22) {
            return true;
        }
        if (PetDataTable.isUpgradeBabyPetGroup(npcId) && this.petType == 50) {
            return true;
        }
        return PetDataTable.isItemEquipPetGroup(npcId) && this.petType == 100;
    }
}

