/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;

public class ConditionPlayerCanPossessHolything
extends Condition {
    private final boolean _val;

    public ConditionPlayerCanPossessHolything(boolean val) {
        this._val = val;
    }

    @Override
    public boolean testImpl(Env env) {
        boolean canPossessHolything = true;
        if (env.getPlayer() == null || env.getPlayer().isAlikeDead() || env.getPlayer().isCursedWeaponEquipped()) {
            canPossessHolything = false;
        } else if (env.getPlayer().getClan() == null || env.getPlayer().getClan().getLeaderId() != env.getPlayer().getObjectId()) {
            canPossessHolything = false;
        }
        Castle castle = CastleManager.getInstance().getCastle(env.getPlayer());
        if (castle == null || castle.getResidenceId() <= 0 || !castle.getSiege().getIsInProgress() || castle.getSiege().getAttackerClan(env.getPlayer().getClan()) == null) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(env.getSkill());
            env.getPlayer().sendPacket(sm);
            canPossessHolything = false;
        } else if (!castle.getArtefacts().contains(env.getTarget())) {
            env.getPlayer().sendPacket(SystemMessageId.INCORRECT_TARGET);
            canPossessHolything = false;
        } else if (!Util.checkIfInRange(200, env.getPlayer(), env.getTarget(), true)) {
            env.getPlayer().sendPacket(SystemMessageId.DIST_TOO_FAR_CASTING_STOPPED);
            canPossessHolything = false;
        }
        return this._val == canPossessHolything;
    }
}

