/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.serverpackets.Earthquake;
import com.l2jserver.util.Rnd;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Future;
import javolution.util.FastList;

public class DimensionalRift {
    protected byte _type;
    protected L2Party _party;
    protected FastList<Byte> _completedRooms = new FastList();
    private static final long seconds_5 = 5000L;
    protected byte jumps_current = 0;
    private Timer teleporterTimer;
    private TimerTask teleporterTimerTask;
    private Timer spawnTimer;
    private TimerTask spawnTimerTask;
    private Future<?> earthQuakeTask;
    protected byte _choosenRoom = (byte)-1;
    private boolean _hasJumped = false;
    protected FastList<L2PcInstance> deadPlayers = new FastList();
    protected FastList<L2PcInstance> revivedInWaitingRoom = new FastList();
    private boolean isBossRoom = false;

    public DimensionalRift(L2Party party, byte type, byte room) {
        DimensionalRiftManager.getInstance().getRoom(type, room).setPartyInside(true);
        this._type = type;
        this._party = party;
        this._choosenRoom = room;
        int[] coords = this.getRoomCoord(room);
        party.setDimensionalRift(this);
        for (L2PcInstance p : party.getMembers()) {
            Quest riftQuest = QuestManager.getInstance().getQuest(635);
            if (riftQuest != null) {
                QuestState qs = p.getQuestState(riftQuest.getName());
                if (qs == null) {
                    qs = riftQuest.newQuestState(p);
                }
                if (!qs.isStarted()) {
                    qs.startQuest();
                }
            }
            p.teleToLocation(coords[0], coords[1], coords[2]);
        }
        this.createSpawnTimer(this._choosenRoom);
        this.createTeleporterTimer(true);
    }

    public byte getType() {
        return this._type;
    }

    public byte getCurrentRoom() {
        return this._choosenRoom;
    }

    protected void createTeleporterTimer(final boolean reasonTP) {
        if (this._party == null) {
            return;
        }
        if (this.teleporterTimerTask != null) {
            this.teleporterTimerTask.cancel();
            this.teleporterTimerTask = null;
        }
        if (this.teleporterTimer != null) {
            this.teleporterTimer.cancel();
            this.teleporterTimer = null;
        }
        if (this.earthQuakeTask != null) {
            this.earthQuakeTask.cancel(false);
            this.earthQuakeTask = null;
        }
        this.teleporterTimer = new Timer();
        this.teleporterTimerTask = new TimerTask(){

            @Override
            public void run() {
                if (DimensionalRift.this._choosenRoom > -1) {
                    DimensionalRiftManager.getInstance().getRoom(DimensionalRift.this._type, DimensionalRift.this._choosenRoom).unspawn().setPartyInside(false);
                }
                if (reasonTP && DimensionalRift.this.jumps_current < DimensionalRift.this.getMaxJumps() && DimensionalRift.this._party.getMemberCount() > DimensionalRift.this.deadPlayers.size()) {
                    DimensionalRift.this.jumps_current = (byte)(DimensionalRift.this.jumps_current + 1);
                    DimensionalRift.this._completedRooms.add((Object)DimensionalRift.this._choosenRoom);
                    DimensionalRift.this._choosenRoom = (byte)-1;
                    for (L2PcInstance p : DimensionalRift.this._party.getMembers()) {
                        if (DimensionalRift.this.revivedInWaitingRoom.contains((Object)p)) continue;
                        DimensionalRift.this.teleportToNextRoom(p);
                    }
                    DimensionalRift.this.createTeleporterTimer(true);
                    DimensionalRift.this.createSpawnTimer(DimensionalRift.this._choosenRoom);
                } else {
                    for (L2PcInstance p : DimensionalRift.this._party.getMembers()) {
                        if (DimensionalRift.this.revivedInWaitingRoom.contains((Object)p)) continue;
                        DimensionalRift.this.teleportToWaitingRoom(p);
                    }
                    DimensionalRift.this.killRift();
                    this.cancel();
                }
            }
        };
        if (reasonTP) {
            long jumpTime = this.calcTimeToNextJump();
            this.teleporterTimer.schedule(this.teleporterTimerTask, jumpTime);
            this.earthQuakeTask = ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

                @Override
                public void run() {
                    for (L2PcInstance p : DimensionalRift.this._party.getMembers()) {
                        if (DimensionalRift.this.revivedInWaitingRoom.contains((Object)p)) continue;
                        p.sendPacket(new Earthquake(p.getX(), p.getY(), p.getZ(), 65, 9));
                    }
                }
            }, jumpTime - 7000L);
        } else {
            this.teleporterTimer.schedule(this.teleporterTimerTask, 5000L);
        }
    }

    public void createSpawnTimer(final byte room) {
        if (this.spawnTimerTask != null) {
            this.spawnTimerTask.cancel();
            this.spawnTimerTask = null;
        }
        if (this.spawnTimer != null) {
            this.spawnTimer.cancel();
            this.spawnTimer = null;
        }
        this.spawnTimer = new Timer();
        this.spawnTimerTask = new TimerTask(){

            @Override
            public void run() {
                DimensionalRiftManager.getInstance().getRoom(DimensionalRift.this._type, room).spawn();
            }
        };
        this.spawnTimer.schedule(this.spawnTimerTask, Config.RIFT_SPAWN_DELAY);
    }

    public void partyMemberInvited() {
        this.createTeleporterTimer(false);
    }

    public void partyMemberExited(L2PcInstance player) {
        if (this.deadPlayers.contains((Object)player)) {
            this.deadPlayers.remove((Object)player);
        }
        if (this.revivedInWaitingRoom.contains((Object)player)) {
            this.revivedInWaitingRoom.remove((Object)player);
        }
        if (this._party.getMemberCount() < Config.RIFT_MIN_PARTY_SIZE || this._party.getMemberCount() == 1) {
            for (L2PcInstance p : this._party.getMembers()) {
                this.teleportToWaitingRoom(p);
            }
            this.killRift();
        }
    }

    public void manualTeleport(L2PcInstance player, L2Npc npc) {
        if (!player.isInParty() || !player.getParty().isInDimensionalRift()) {
            return;
        }
        if (player.getObjectId() != player.getParty().getLeaderObjectId()) {
            DimensionalRiftManager.getInstance().showHtmlFile(player, "data/html/seven_signs/rift/NotPartyLeader.htm", npc);
            return;
        }
        if (this._hasJumped) {
            DimensionalRiftManager.getInstance().showHtmlFile(player, "data/html/seven_signs/rift/AlreadyTeleported.htm", npc);
            return;
        }
        this._hasJumped = true;
        DimensionalRiftManager.getInstance().getRoom(this._type, this._choosenRoom).unspawn().setPartyInside(false);
        this._completedRooms.add((Object)this._choosenRoom);
        this._choosenRoom = (byte)-1;
        for (L2PcInstance p : this._party.getMembers()) {
            this.teleportToNextRoom(p);
        }
        DimensionalRiftManager.getInstance().getRoom(this._type, this._choosenRoom).setPartyInside(true);
        this.createSpawnTimer(this._choosenRoom);
        this.createTeleporterTimer(true);
    }

    public void manualExitRift(L2PcInstance player, L2Npc npc) {
        if (!player.isInParty() || !player.getParty().isInDimensionalRift()) {
            return;
        }
        if (player.getObjectId() != player.getParty().getLeaderObjectId()) {
            DimensionalRiftManager.getInstance().showHtmlFile(player, "data/html/seven_signs/rift/NotPartyLeader.htm", npc);
            return;
        }
        for (L2PcInstance p : player.getParty().getMembers()) {
            this.teleportToWaitingRoom(p);
        }
        this.killRift();
    }

    protected void teleportToNextRoom(L2PcInstance player) {
        if (this._choosenRoom == -1) {
            do {
                FastList<Byte> emptyRooms = DimensionalRiftManager.getInstance().getFreeRooms(this._type);
                emptyRooms.removeAll(this._completedRooms);
                if (emptyRooms.isEmpty()) {
                    emptyRooms = DimensionalRiftManager.getInstance().getFreeRooms(this._type);
                }
                this._choosenRoom = (Byte)emptyRooms.get(Rnd.get(1, emptyRooms.size()) - 1);
            } while (DimensionalRiftManager.getInstance().getRoom(this._type, this._choosenRoom).isPartyInside());
        }
        DimensionalRiftManager.getInstance().getRoom(this._type, this._choosenRoom).setPartyInside(true);
        this.checkBossRoom(this._choosenRoom);
        int[] coords = this.getRoomCoord(this._choosenRoom);
        player.teleToLocation(coords[0], coords[1], coords[2]);
    }

    protected void teleportToWaitingRoom(L2PcInstance player) {
        QuestState qs;
        DimensionalRiftManager.getInstance().teleportToWaitingRoom(player);
        Quest riftQuest = QuestManager.getInstance().getQuest(635);
        if (riftQuest != null && (qs = player.getQuestState(riftQuest.getName())) != null && qs.isCond(1)) {
            qs.exitQuest(true, true);
        }
    }

    public void killRift() {
        this._completedRooms = null;
        if (this._party != null) {
            this._party.setDimensionalRift(null);
        }
        this._party = null;
        this.revivedInWaitingRoom = null;
        this.deadPlayers = null;
        if (this.earthQuakeTask != null) {
            this.earthQuakeTask.cancel(false);
            this.earthQuakeTask = null;
        }
        DimensionalRiftManager.getInstance().getRoom(this._type, this._choosenRoom).unspawn().setPartyInside(false);
        DimensionalRiftManager.getInstance().killRift(this);
    }

    public Timer getTeleportTimer() {
        return this.teleporterTimer;
    }

    public TimerTask getTeleportTimerTask() {
        return this.teleporterTimerTask;
    }

    public Timer getSpawnTimer() {
        return this.spawnTimer;
    }

    public TimerTask getSpawnTimerTask() {
        return this.spawnTimerTask;
    }

    public void setTeleportTimer(Timer t) {
        this.teleporterTimer = t;
    }

    public void setTeleportTimerTask(TimerTask tt) {
        this.teleporterTimerTask = tt;
    }

    public void setSpawnTimer(Timer t) {
        this.spawnTimer = t;
    }

    public void setSpawnTimerTask(TimerTask st) {
        this.spawnTimerTask = st;
    }

    private long calcTimeToNextJump() {
        int time = Rnd.get(Config.RIFT_AUTO_JUMPS_TIME_MIN, Config.RIFT_AUTO_JUMPS_TIME_MAX) * 1000;
        if (this.isBossRoom) {
            return (long)((float)time * Config.RIFT_BOSS_ROOM_TIME_MUTIPLY);
        }
        return time;
    }

    public void memberDead(L2PcInstance player) {
        if (!this.deadPlayers.contains((Object)player)) {
            this.deadPlayers.add((Object)player);
        }
    }

    public void memberRessurected(L2PcInstance player) {
        if (this.deadPlayers.contains((Object)player)) {
            this.deadPlayers.remove((Object)player);
        }
    }

    public void usedTeleport(L2PcInstance player) {
        if (!this.revivedInWaitingRoom.contains((Object)player)) {
            this.revivedInWaitingRoom.add((Object)player);
        }
        if (!this.deadPlayers.contains((Object)player)) {
            this.deadPlayers.add((Object)player);
        }
        if (this._party.getMemberCount() - this.revivedInWaitingRoom.size() < Config.RIFT_MIN_PARTY_SIZE) {
            for (L2PcInstance p : this._party.getMembers()) {
                if (p == null || this.revivedInWaitingRoom.contains((Object)p)) continue;
                this.teleportToWaitingRoom(p);
            }
            this.killRift();
        }
    }

    public FastList<L2PcInstance> getDeadMemberList() {
        return this.deadPlayers;
    }

    public FastList<L2PcInstance> getRevivedAtWaitingRoom() {
        return this.revivedInWaitingRoom;
    }

    public void checkBossRoom(byte room) {
        this.isBossRoom = DimensionalRiftManager.getInstance().getRoom(this._type, room).isBossRoom();
    }

    public int[] getRoomCoord(byte room) {
        return DimensionalRiftManager.getInstance().getRoom(this._type, room).getTeleportCoorinates();
    }

    public byte getMaxJumps() {
        if (Config.RIFT_MAX_JUMPS <= 8 && Config.RIFT_MAX_JUMPS >= 1) {
            return (byte)Config.RIFT_MAX_JUMPS;
        }
        return 4;
    }
}

