/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.options;

import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.options.OptionsSkillHolder;
import com.l2jserver.gameserver.model.options.OptionsSkillType;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.skills.funcs.Func;
import com.l2jserver.gameserver.model.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.network.serverpackets.SkillCoolTime;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Options {
    private final int _id;
    private static final FuncTemplate[] EMPTY_FUNC_TEMPLATES = new FuncTemplate[0];
    private FuncTemplate[] _funcs = EMPTY_FUNC_TEMPLATES;
    private int _activeSkill = 0;
    private int _passiveSkill = 0;
    private static final OptionsSkillHolder[] EMPTY_OPTIONS_SKILL_HOLDERS = new OptionsSkillHolder[0];
    private OptionsSkillHolder[] _activationSkills = EMPTY_OPTIONS_SKILL_HOLDERS;

    public Options(int id) {
        this._id = id;
    }

    public final int getId() {
        return this._id;
    }

    public boolean hasFuncs() {
        return this._funcs.length > 0;
    }

    public List<Func> getStatFuncs(L2ItemInstance item, L2Character player) {
        if (this._funcs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Func> funcs = new ArrayList<Func>(this._funcs.length);
        Env env = new Env();
        env.setCharacter(player);
        env.setTarget(player);
        env.setItem(item);
        for (FuncTemplate t : this._funcs) {
            Func f = t.getFunc(env, this);
            if (f != null) {
                funcs.add(f);
            }
            player.sendDebugMessage("Adding stats: " + (Object)((Object)t.stat) + " val: " + t.lambda.calc(env));
        }
        return funcs;
    }

    public void addFunc(FuncTemplate template) {
        this._funcs = Util.append(this._funcs, template);
    }

    public boolean hasActiveSkill() {
        return this._activeSkill != 0;
    }

    public L2Skill getActiveSkill() {
        return SkillTable.getSkill(this._activeSkill);
    }

    public void setActiveSkill(int id, int level) {
        this._activeSkill = SkillTable.getSkillHashCode(id, level);
    }

    public boolean hasPassiveSkill() {
        return this._passiveSkill != 0;
    }

    public L2Skill getPassiveSkill() {
        return SkillTable.getSkill(this._passiveSkill);
    }

    public void setPassiveSkill(int id, int level) {
        this._passiveSkill = SkillTable.getSkillHashCode(id, level);
    }

    public boolean hasActivationSkills() {
        return this._activationSkills.length > 0;
    }

    public boolean hasActivationSkills(OptionsSkillType type) {
        for (OptionsSkillHolder holder : this._activationSkills) {
            if (holder.getSkillType() != type) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public OptionsSkillHolder[] getActivationsSkills() {
        return this._activationSkills;
    }

    public List<OptionsSkillHolder> getActivationsSkills(OptionsSkillType type) {
        ArrayList<OptionsSkillHolder> temp = new ArrayList<OptionsSkillHolder>();
        for (OptionsSkillHolder holder : this._activationSkills) {
            if (holder.getSkillType() != type) continue;
            temp.add(holder);
        }
        return temp;
    }

    public void addActivationSkill(OptionsSkillHolder holder) {
        this._activationSkills = Util.append(this._activationSkills, holder);
    }

    public void apply(L2PcInstance player) {
        player.sendDebugMessage("Activating option id: " + this._id);
        if (this.hasFuncs()) {
            player.addStatFuncs(this.getStatFuncs(null, player));
        }
        if (this.hasActiveSkill()) {
            this.addSkill(player, this.getActiveSkill());
            player.sendDebugMessage("Adding active skill: " + this.getActiveSkill());
        }
        if (this.hasPassiveSkill()) {
            this.addSkill(player, this.getPassiveSkill());
            player.sendDebugMessage("Adding passive skill: " + this.getPassiveSkill());
        }
        if (this.hasActivationSkills()) {
            for (OptionsSkillHolder holder : this._activationSkills) {
                player.addTriggerSkill(holder);
                player.sendDebugMessage("Adding trigger skill: " + holder);
            }
        }
        player.sendSkillList();
    }

    public void remove(L2PcInstance player) {
        player.sendDebugMessage("Deactivating option id: " + this._id);
        if (this.hasFuncs()) {
            player.removeStatsOwner(this);
        }
        if (this.hasActiveSkill()) {
            player.removeSkill(this.getActiveSkill(), false, false);
            player.sendDebugMessage("Removing active skill: " + this.getActiveSkill());
        }
        if (this.hasPassiveSkill()) {
            player.removeSkill(this.getPassiveSkill(), false, true);
            player.sendDebugMessage("Removing passive skill: " + this.getPassiveSkill());
        }
        if (this.hasActivationSkills()) {
            for (OptionsSkillHolder holder : this._activationSkills) {
                player.removeTriggerSkill(holder);
                player.sendDebugMessage("Removing trigger skill: " + holder);
            }
        }
        player.sendSkillList();
    }

    private final void addSkill(L2PcInstance player, L2Skill skill) {
        boolean updateTimeStamp = false;
        player.addSkill(skill, false);
        if (skill.isActive()) {
            long remainingTime = player.getSkillRemainingReuseTime(skill.getReuseHashCode());
            if (remainingTime > 0L) {
                player.addTimeStamp(skill, remainingTime);
                player.disableSkill(skill, remainingTime);
            }
            updateTimeStamp = true;
        }
        if (updateTimeStamp) {
            player.sendPacket(new SkillCoolTime(player));
        }
    }
}

