/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.punishment;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.handler.IPunishmentHandler;
import com.l2jserver.gameserver.handler.PunishmentHandler;
import com.l2jserver.gameserver.instancemanager.PunishmentManager;
import com.l2jserver.gameserver.model.punishment.PunishmentAffect;
import com.l2jserver.gameserver.model.punishment.PunishmentType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PunishmentTask
implements Runnable {
    protected static final Logger _log = Logger.getLogger(PunishmentTask.class.getName());
    private static final String INSERT_QUERY = "INSERT INTO punishments (`key`, `affect`, `type`, `expiration`, `reason`, `punishedBy`) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_QUERY = "UPDATE punishments SET expiration = ? WHERE id = ?";
    private int _id;
    private final String _key;
    private final PunishmentAffect _affect;
    private final PunishmentType _type;
    private final long _expirationTime;
    private final String _reason;
    private final String _punishedBy;
    private boolean _isStored;
    private ScheduledFuture<?> _task = null;

    public PunishmentTask(Object key, PunishmentAffect affect, PunishmentType type, long expirationTime, String reason, String punishedBy) {
        this(0, key, affect, type, expirationTime, reason, punishedBy, false);
    }

    public PunishmentTask(int id, Object key, PunishmentAffect affect, PunishmentType type, long expirationTime, String reason, String punishedBy, boolean isStored) {
        this._id = id;
        this._key = String.valueOf(key);
        this._affect = affect;
        this._type = type;
        this._expirationTime = expirationTime;
        this._reason = reason;
        this._punishedBy = punishedBy;
        this._isStored = isStored;
        this.startPunishment();
    }

    public Object getKey() {
        return this._key;
    }

    public PunishmentAffect getAffect() {
        return this._affect;
    }

    public PunishmentType getType() {
        return this._type;
    }

    public final long getExpirationTime() {
        return this._expirationTime;
    }

    public String getReason() {
        return this._reason;
    }

    public String getPunishedBy() {
        return this._punishedBy;
    }

    public boolean isStored() {
        return this._isStored;
    }

    public final boolean isExpired() {
        return this._expirationTime > 0L && System.currentTimeMillis() > this._expirationTime;
    }

    private void startPunishment() {
        if (this.isExpired()) {
            return;
        }
        this.onStart();
        if (this._expirationTime > 0L) {
            this._task = ThreadPoolManager.getInstance().scheduleGeneral(this, this._expirationTime - System.currentTimeMillis());
        }
    }

    public final void stopPunishment() {
        this.abortTask();
        this.onEnd();
    }

    private void abortTask() {
        if (this._task != null) {
            if (!this._task.isCancelled() && !this._task.isDone()) {
                this._task.cancel(false);
            }
            this._task = null;
        }
    }

    private void onStart() {
        IPunishmentHandler handler;
        if (!this._isStored) {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement st = con.prepareStatement(INSERT_QUERY, 1);){
                st.setString(1, this._key);
                st.setString(2, this._affect.name());
                st.setString(3, this._type.name());
                st.setLong(4, this._expirationTime);
                st.setString(5, this._reason);
                st.setString(6, this._punishedBy);
                st.execute();
                try (ResultSet rset = st.getGeneratedKeys();){
                    if (rset.next()) {
                        this._id = rset.getInt(1);
                    }
                }
                this._isStored = true;
            }
            catch (SQLException e) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Couldn't store punishment task for: " + (Object)((Object)this._affect) + " " + this._key, e);
            }
        }
        if ((handler = PunishmentHandler.getInstance().getHandler(this._type)) != null) {
            handler.onStart(this);
        }
    }

    private void onEnd() {
        IPunishmentHandler handler;
        if (this._isStored) {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement st = con.prepareStatement(UPDATE_QUERY);){
                st.setLong(1, System.currentTimeMillis());
                st.setLong(2, this._id);
                st.execute();
            }
            catch (SQLException e) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Couldn't update punishment task for: " + (Object)((Object)this._affect) + " " + this._key + " id: " + this._id, e);
            }
        }
        if ((handler = PunishmentHandler.getInstance().getHandler(this._type)) != null) {
            handler.onEnd(this);
        }
    }

    @Override
    public final void run() {
        PunishmentManager.getInstance().stopPunishment(this._key, this._affect, this._type);
    }
}

