/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.skills;

import com.l2jserver.gameserver.model.actor.L2Character;
import jp.sf.l2j.troja.FastIntObjectMap;

public final class SkillChannelized {
    private final FastIntObjectMap<FastIntObjectMap<L2Character>> _channelizers = new FastIntObjectMap().shared();

    public void addChannelizer(int skillId, L2Character channelizer) {
        FastIntObjectMap c = (FastIntObjectMap)this._channelizers.get(skillId);
        if (c == null) {
            c = new FastIntObjectMap().shared();
            this._channelizers.put(skillId, (Object)c);
        }
        c.put(channelizer.getObjectId(), (Object)channelizer);
    }

    public void removeChannelizer(int skillId, L2Character channelizer) {
        FastIntObjectMap c = (FastIntObjectMap)this._channelizers.get(skillId);
        if (c != null) {
            c.remove(channelizer.getObjectId());
        }
    }

    public int getChannerlizersSize(int skillId) {
        FastIntObjectMap c = (FastIntObjectMap)this._channelizers.get(skillId);
        return c != null ? c.size() : 0;
    }

    public FastIntObjectMap<L2Character> getChannelizers(int skillId) {
        return (FastIntObjectMap)this._channelizers.get(skillId);
    }

    public void abortChannelization() {
        for (FastIntObjectMap map : this._channelizers.values()) {
            for (L2Character channelizer : map.values()) {
                channelizer.abortCast();
            }
        }
        this._channelizers.clear();
    }

    public boolean isChannelized() {
        for (FastIntObjectMap map : this._channelizers.values()) {
            if (map == null || map.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

