/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.skills.funcs.formulas;

import com.l2jserver.gameserver.datatables.ArmorSetsData;
import com.l2jserver.gameserver.model.L2ArmorSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.funcs.Func;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.model.stats.Stats;
import java.util.HashMap;
import java.util.Map;

public class FuncArmorSet
extends Func {
    private static final Map<Stats, FuncArmorSet> _fh_instance = new HashMap<Stats, FuncArmorSet>();

    public static Func getInstance(Stats st) {
        FuncArmorSet instance = _fh_instance.get((Object)st);
        if (instance == null) {
            instance = new FuncArmorSet(st);
            _fh_instance.put(st, instance);
        }
        return instance;
    }

    private FuncArmorSet(Stats stat) {
        super(stat, 16, null);
    }

    @Override
    public void calc(Env env) {
        L2ArmorSet set;
        L2ItemInstance chest;
        L2PcInstance player = env.getPlayer();
        if (player != null && (chest = player.getChestArmorInstance()) != null && (set = ArmorSetsData.getInstance().getSet(chest.getId())) != null && set.containAll(player)) {
            switch (this.stat) {
                case STAT_STR: {
                    env.addValue(set.getSTR());
                    break;
                }
                case STAT_DEX: {
                    env.addValue(set.getDEX());
                    break;
                }
                case STAT_INT: {
                    env.addValue(set.getINT());
                    break;
                }
                case STAT_MEN: {
                    env.addValue(set.getMEN());
                    break;
                }
                case STAT_CON: {
                    env.addValue(set.getCON());
                    break;
                }
                case STAT_WIT: {
                    env.addValue(set.getWIT());
                }
            }
        }
    }
}

