/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.skills.l2skills;

import com.l2jserver.gameserver.datatables.ExperienceTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2ServitorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeSummonInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.skills.L2Skill;

public class L2SkillSummon
extends L2Skill {
    private final float _expPenalty;
    private final int _summonTotalLifeTime;
    private final int _summonTimeLostIdle;
    private final int _summonTimeLostActive;
    private final int _itemConsumeOT;
    private final int _itemConsumeIdOT;
    private final int _itemConsumeSteps;
    private final boolean _inheritElementals;
    private final double _elementalSharePercent;

    public L2SkillSummon(StatsSet set) {
        super(set);
        this._expPenalty = set.getFloat("expPenalty", 0.0f);
        this._summonTotalLifeTime = set.getInt("summonTotalLifeTime", 1200000);
        this._summonTimeLostIdle = set.getInt("summonTimeLostIdle", 0);
        this._summonTimeLostActive = set.getInt("summonTimeLostActive", 0);
        this._itemConsumeOT = set.getInt("itemConsumeCountOT", 0);
        this._itemConsumeIdOT = set.getInt("itemConsumeIdOT", 0);
        this._itemConsumeSteps = set.getInt("itemConsumeSteps", 0);
        this._inheritElementals = set.getBoolean("inheritElementals", false);
        this._elementalSharePercent = set.getDouble("inheritPercent", 1.0);
    }

    @Override
    public void useSkill(L2Character caster, L2Object[] targets) {
        if (caster == null || caster.isAlikeDead() || !caster.isPlayer()) {
            return;
        }
        L2PcInstance activeChar = caster.getActingPlayer();
        if (this.getNpcId() <= 0) {
            activeChar.sendMessage("Summon skill " + this.getId() + " not implemented yet.");
            return;
        }
        L2NpcTemplate summonTemplate = NpcTable.getInstance().getTemplate(this.getNpcId());
        if (summonTemplate == null) {
            _log.warning("Summon attempt for nonexisting NPC ID:" + this.getNpcId() + ", skill ID:" + this.getId());
            return;
        }
        int id = IdFactory.getInstance().getNextId();
        L2ServitorInstance summon = summonTemplate.isType("L2SiegeSummon") ? new L2SiegeSummonInstance(id, summonTemplate, activeChar, this) : new L2ServitorInstance(id, summonTemplate, activeChar, this);
        summon.setName(summonTemplate.getName());
        summon.setTitle(activeChar.getName());
        summon.setExpPenalty(this._expPenalty);
        summon.setSharedElementals(this._inheritElementals);
        summon.setSharedElementalsValue(this._elementalSharePercent);
        if (summon.getLevel() >= ExperienceTable.getInstance().getMaxPetLevel()) {
            summon.getStat().setExp(ExperienceTable.getInstance().getExpForLevel(ExperienceTable.getInstance().getMaxPetLevel() - 1));
            _log.warning("Summon (" + summon.getName() + ") NpcID: " + summon.getId() + " has a level above " + ExperienceTable.getInstance().getMaxPetLevel() + ". Please rectify.");
        } else {
            summon.getStat().setExp(ExperienceTable.getInstance().getExpForLevel(summon.getLevel() % ExperienceTable.getInstance().getMaxPetLevel()));
        }
        summon.setCurrentHp(summon.getMaxHp());
        summon.setCurrentMp(summon.getMaxMp());
        summon.setHeading(activeChar.getHeading());
        summon.setRunning();
        activeChar.setPet(summon);
        summon.spawnMe(activeChar.getX() + 20, activeChar.getY() + 20, activeChar.getZ());
    }

    public final int getTotalLifeTime() {
        return this._summonTotalLifeTime;
    }

    public final int getTimeLostIdle() {
        return this._summonTimeLostIdle;
    }

    public final int getTimeLostActive() {
        return this._summonTimeLostActive;
    }

    public final int getItemConsumeOT() {
        return this._itemConsumeOT;
    }

    public final int getItemConsumeIdOT() {
        return this._itemConsumeIdOT;
    }

    public final int getItemConsumeSteps() {
        return this._itemConsumeSteps;
    }

    public final float getExpPenalty() {
        return this._expPenalty;
    }

    public final boolean getInheritElementals() {
        return this._inheritElementals;
    }

    public final double getElementalSharePercent() {
        return this._elementalSharePercent;
    }
}

