/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.variables;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.variables.AbstractVariables;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlayerVariables
extends AbstractVariables {
    private static final Logger _log = Logger.getLogger(PlayerVariables.class.getName());
    private static final String SELECT_QUERY = "SELECT * FROM character_variables WHERE charId = ?";
    private static final String DELETE_QUERY = "DELETE FROM character_variables WHERE charId = ?";
    private static final String INSERT_QUERY = "INSERT INTO character_variables (charId, var, val) VALUES (?, ?, ?)";
    private final int _objectId;

    public PlayerVariables(int objectId) {
        this._objectId = objectId;
        this.restoreMe();
    }

    @Override
    public boolean restoreMe() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement st = con.prepareStatement(SELECT_QUERY);){
            st.setInt(1, this._objectId);
            try (ResultSet rset = st.executeQuery();){
                while (rset.next()) {
                    this.set(rset.getString("var"), rset.getString("val"));
                }
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Couldn't restore variables for: " + this.getPlayer(), e);
            return false;
        }
        return true;
    }

    @Override
    public boolean storeMe() {
        if (!this.getAndResetChanges()) {
            return false;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            try (PreparedStatement st = con.prepareStatement(DELETE_QUERY);){
                st.setInt(1, this._objectId);
                st.execute();
            }
            st = con.prepareStatement(INSERT_QUERY);
            var4_7 = null;
            try {
                st.setInt(1, this._objectId);
                for (Map.Entry<String, Object> entry : this.getSet().entrySet()) {
                    st.setString(2, entry.getKey());
                    st.setString(3, String.valueOf(entry.getValue()));
                    st.addBatch();
                }
                st.executeBatch();
            }
            catch (Throwable throwable) {
                var4_7 = throwable;
                throw throwable;
            }
            finally {
                if (st != null) {
                    if (var4_7 != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable x2) {
                            var4_7.addSuppressed(x2);
                        }
                    } else {
                        st.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Couldn't update variables for: " + this.getPlayer(), e);
            return false;
        }
        return true;
    }

    public L2PcInstance getPlayer() {
        return L2World.getInstance().getPlayer(this._objectId);
    }
}

