/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.ServerObjectInfo;
import java.util.Collection;

public class L2WaterZone
extends L2ZoneType {
    public L2WaterZone(int id) {
        super(id);
    }

    @Override
    protected void onEnter(L2Character character) {
        character.setInsideZone(ZoneId.WATER, true);
        if (character.isPlayer()) {
            L2PcInstance player = character.getActingPlayer();
            if (player.isTransformed() && !player.getTransformation().canSwim()) {
                character.stopTransformation(true);
            } else {
                player.broadcastUserInfo();
            }
        } else if (character.isNpc()) {
            Collection plrs = character.getKnownList().getKnownPlayers().values();
            for (L2PcInstance player : plrs) {
                if (character.getRunSpeed() == 0) {
                    player.sendPacket(new ServerObjectInfo((L2Npc)character, player));
                    continue;
                }
                player.sendPacket(new AbstractNpcInfo.NpcInfo((L2Npc)character, player));
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        character.setInsideZone(ZoneId.WATER, false);
        if (character.isPlayer()) {
            character.getActingPlayer().broadcastUserInfo();
        } else if (character.isNpc()) {
            Collection plrs = character.getKnownList().getKnownPlayers().values();
            for (L2PcInstance player : plrs) {
                if (character.getRunSpeed() == 0) {
                    player.sendPacket(new ServerObjectInfo((L2Npc)character, player));
                    continue;
                }
                player.sendPacket(new AbstractNpcInfo.NpcInfo((L2Npc)character, player));
            }
        }
    }

    public int getWaterZ() {
        return this.getZone().getHighZ();
    }
}

