/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.instancemanager.DuelManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestDuelAnswerStart
extends L2GameClientPacket {
    private static final String _C__D0_1C_REQUESTDUELANSWERSTART = "[C] D0:1C RequestDuelAnswerStart";
    private int _partyDuel;
    private int _unk1;
    private int _response;

    @Override
    protected void readImpl() {
        this._partyDuel = this.readD();
        this._unk1 = this.readD();
        this._response = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        L2PcInstance requestor = player.getActiveRequester();
        if (requestor == null) {
            return;
        }
        if (this._response == 1) {
            SystemMessage msg1 = null;
            SystemMessage msg2 = null;
            if (requestor.isInDuel()) {
                msg1 = SystemMessage.getSystemMessage(SystemMessageId.C1_CANNOT_DUEL_BECAUSE_C1_IS_ALREADY_ENGAGED_IN_A_DUEL);
                msg1.addString(requestor.getName());
                player.sendPacket(msg1);
                return;
            }
            if (player.isInDuel()) {
                player.sendPacket(SystemMessageId.YOU_ARE_UNABLE_TO_REQUEST_A_DUEL_AT_THIS_TIME);
                return;
            }
            if (this._partyDuel == 1) {
                msg1 = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_ACCEPTED_C1_CHALLENGE_TO_A_PARTY_DUEL_THE_DUEL_WILL_BEGIN_IN_A_FEW_MOMENTS);
                msg1.addString(requestor.getName());
                msg2 = SystemMessage.getSystemMessage(SystemMessageId.S1_HAS_ACCEPTED_YOUR_CHALLENGE_TO_DUEL_AGAINST_THEIR_PARTY_THE_DUEL_WILL_BEGIN_IN_A_FEW_MOMENTS);
                msg2.addString(player.getName());
            } else {
                msg1 = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_ACCEPTED_C1_CHALLENGE_TO_A_DUEL_THE_DUEL_WILL_BEGIN_IN_A_FEW_MOMENTS);
                msg1.addString(requestor.getName());
                msg2 = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_ACCEPTED_YOUR_CHALLENGE_TO_A_DUEL_THE_DUEL_WILL_BEGIN_IN_A_FEW_MOMENTS);
                msg2.addString(player.getName());
            }
            player.sendPacket(msg1);
            requestor.sendPacket(msg2);
            DuelManager.getInstance().addDuel(requestor, player, this._partyDuel);
        } else if (this._response == -1) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_SET_TO_REFUSE_DUEL_REQUEST);
            sm.addPcName(player);
            requestor.sendPacket(sm);
        } else {
            SystemMessage msg = null;
            if (this._partyDuel == 1) {
                msg = SystemMessage.getSystemMessage(SystemMessageId.THE_OPPOSING_PARTY_HAS_DECLINED_YOUR_CHALLENGE_TO_A_DUEL);
            } else {
                msg = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_DECLINED_YOUR_CHALLENGE_TO_A_DUEL);
                msg.addPcName(player);
            }
            requestor.sendPacket(msg);
        }
        player.setActiveRequester(null);
        requestor.onTransactionResponse();
    }

    @Override
    public String getType() {
        return _C__D0_1C_REQUESTDUELANSWERSTART;
    }
}

