/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SiegeInfo;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Broadcast;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;

public class RequestSetCastleSiegeTime
extends L2GameClientPacket {
    private int _castleId;
    private long _time;

    @Override
    protected void readImpl() {
        this._castleId = this.readD();
        this._time = this.readD();
        this._time *= 1000L;
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        Castle castle = CastleManager.getInstance().getCastleById(this._castleId);
        if (activeChar == null || castle == null) {
            _log.log(Level.WARNING, this.getType() + ": activeChar: " + activeChar + " castle: " + castle + " castleId: " + this._castleId);
            return;
        }
        if (castle.getOwnerId() > 0 && castle.getOwnerId() != activeChar.getClanId()) {
            _log.log(Level.WARNING, this.getType() + ": activeChar: " + activeChar + " castle: " + castle + " castleId: " + this._castleId + " is trying to change siege date of not his own castle!");
            return;
        }
        if (!activeChar.isClanLeader()) {
            _log.log(Level.WARNING, this.getType() + ": activeChar: " + activeChar + " castle: " + castle + " castleId: " + this._castleId + " is trying to change siege date but is not clan leader!");
            return;
        }
        if (!castle.getIsTimeRegistrationOver() && !castle.getIsTimeRegistrationOver()) {
            if (RequestSetCastleSiegeTime.isSiegeTimeValid(castle.getSiegeDate().getTimeInMillis(), this._time)) {
                castle.getSiegeDate().setTimeInMillis(this._time);
                castle.setIsTimeRegistrationOver(true);
                castle.getSiege().saveSiegeDate();
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.S1_ANNOUNCED_SIEGE_TIME);
                msg.addCastleId(this._castleId);
                Broadcast.toAllOnlinePlayers(msg);
                activeChar.sendPacket(new SiegeInfo(castle));
            } else {
                _log.log(Level.WARNING, this.getType() + ": activeChar: " + activeChar + " castle: " + castle + " castleId: " + this._castleId + " is trying to an invalid time (" + new Date(this._time) + " !");
            }
        } else {
            _log.log(Level.WARNING, this.getType() + ": activeChar: " + activeChar + " castle: " + castle + " castleId: " + this._castleId + " is trying to change siege date but currently not possible!");
        }
    }

    private static boolean isSiegeTimeValid(long siegeDate, long choosenDate) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTimeInMillis(siegeDate);
        cal1.set(12, 0);
        cal1.set(13, 0);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTimeInMillis(choosenDate);
        for (int hour : Config.SIEGE_HOUR_LIST) {
            cal1.set(11, hour);
            if (!RequestSetCastleSiegeTime.isEqual(cal1, cal2, 1, 2, 5, 10, 12, 13)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEqual(Calendar cal1, Calendar cal2, int ... fields) {
        for (int field : fields) {
            if (cal1.get(field) == cal2.get(field)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getType() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

