/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.base.AcquireSkillType;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.ArrayList;
import java.util.List;

public class AcquireSkillInfo
extends L2GameServerPacket {
    private final AcquireSkillType _type;
    private final int _id;
    private final int _level;
    private final int _spCost;
    private final List<Req> _reqs;

    public AcquireSkillInfo(AcquireSkillType skillType, L2SkillLearn skillLearn) {
        this._id = skillLearn.getSkillId();
        this._level = skillLearn.getSkillLevel();
        this._spCost = skillLearn.getLevelUpSp();
        this._type = skillType;
        this._reqs = new ArrayList<Req>();
        if (skillType != AcquireSkillType.PLEDGE || Config.LIFE_CRYSTAL_NEEDED) {
            for (ItemHolder item : skillLearn.getRequiredItems()) {
                if (!Config.DIVINE_SP_BOOK_NEEDED && this._id == 1405) continue;
                this._reqs.add(new Req(99, item.getId(), item.getCount(), 50));
            }
        }
    }

    public AcquireSkillInfo(AcquireSkillType skillType, L2SkillLearn skillLearn, int sp) {
        this._id = skillLearn.getSkillId();
        this._level = skillLearn.getSkillLevel();
        this._spCost = sp;
        this._type = skillType;
        this._reqs = new ArrayList<Req>();
        for (ItemHolder item : skillLearn.getRequiredItems()) {
            this._reqs.add(new Req(99, item.getId(), item.getCount(), 50));
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(145);
        this.writeD(this._id);
        this.writeD(this._level);
        this.writeD(this._spCost);
        this.writeD(this._type.ordinal());
        this.writeD(this._reqs.size());
        for (Req temp : this._reqs) {
            this.writeD(temp.type);
            this.writeD(temp.itemId);
            this.writeQ(temp.count);
            this.writeD(temp.unk);
        }
    }

    private static class Req {
        public int itemId;
        public long count;
        public int type;
        public int unk;

        public Req(int pType, int pItemId, long itemCount, int pUnk) {
            this.itemId = pItemId;
            this.type = pType;
            this.count = itemCount;
            this.unk = pUnk;
        }
    }
}

