/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;

public class ExShowCastleInfo
extends L2GameServerPacket {
    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(20);
        List<Castle> castles = CastleManager.getInstance().getCastles();
        this.writeD(castles.size());
        for (Castle castle : castles) {
            this.writeD(castle.getResidenceId());
            if (castle.getOwnerId() > 0) {
                if (ClanTable.getInstance().getClan(castle.getOwnerId()) != null) {
                    this.writeS(ClanTable.getInstance().getClan(castle.getOwnerId()).getName());
                } else {
                    _log.warning("Castle owner with no name! Castle: " + castle.getName() + " has an OwnerId = " + castle.getOwnerId() + " who does not have a  name!");
                    this.writeS("");
                }
            } else {
                this.writeS("");
            }
            this.writeD(castle.getTaxPercent());
            this.writeD((int)(castle.getSiege().getSiegeDate().getTimeInMillis() / 1000L));
        }
    }
}

