/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.RecipeData;
import com.l2jserver.gameserver.model.L2RecipeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.L2WarehouseItem;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.L2EtcItemType;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javolution.util.FastList;

public class SortedWareHouseWithdrawalList
extends L2GameServerPacket {
    public static final int PRIVATE = 1;
    public static final int CLAN = 2;
    public static final int CASTLE = 3;
    public static final int FREIGHT = 4;
    private L2PcInstance _activeChar;
    private long _playerAdena;
    private List<L2WarehouseItem> _objects = new FastList();
    private int _whType;
    private byte _sortorder;
    private WarehouseListType _itemtype;
    public static final byte A2Z = 1;
    public static final byte Z2A = -1;
    public static final byte GRADE = 2;
    public static final byte LEVEL = 3;
    public static final byte TYPE = 4;
    public static final byte WEAR = 5;
    public static final int MAX_SORT_LIST_ITEMS = 300;

    public SortedWareHouseWithdrawalList(L2PcInstance player, int type, WarehouseListType itemtype, byte sortorder) {
        this._activeChar = player;
        this._whType = type;
        this._itemtype = itemtype;
        this._sortorder = sortorder;
        this._playerAdena = this._activeChar.getAdena();
        if (this._activeChar.getActiveWarehouse() == null) {
            _log.warning("error while sending withdraw request to: " + this._activeChar.getName());
            return;
        }
        switch (this._itemtype) {
            case WEAPON: {
                this._objects = this.createWeaponList(this._activeChar.getActiveWarehouse().getItems());
                break;
            }
            case ARMOR: {
                this._objects = this.createArmorList(this._activeChar.getActiveWarehouse().getItems());
                break;
            }
            case ETCITEM: {
                this._objects = this.createEtcItemList(this._activeChar.getActiveWarehouse().getItems());
                break;
            }
            case MATERIAL: {
                this._objects = this.createMatList(this._activeChar.getActiveWarehouse().getItems());
                break;
            }
            case RECIPE: {
                this._objects = this.createRecipeList(this._activeChar.getActiveWarehouse().getItems());
                break;
            }
            case AMULETT: {
                this._objects = this.createAmulettList(this._activeChar.getActiveWarehouse().getItems());
                break;
            }
            case SPELLBOOK: {
                this._objects = this.createSpellbookList(this._activeChar.getActiveWarehouse().getItems());
                break;
            }
            case CONSUMABLE: {
                this._objects = this.createConsumableList(this._activeChar.getActiveWarehouse().getItems());
                break;
            }
            case SHOT: {
                this._objects = this.createShotList(this._activeChar.getActiveWarehouse().getItems());
                break;
            }
            case SCROLL: {
                this._objects = this.createScrollList(this._activeChar.getActiveWarehouse().getItems());
                break;
            }
            case SEED: {
                this._objects = this.createSeedList(this._activeChar.getActiveWarehouse().getItems());
                break;
            }
            case OTHER: {
                this._objects = this.createOtherList(this._activeChar.getActiveWarehouse().getItems());
                break;
            }
            default: {
                this._objects = this.createAllList(this._activeChar.getActiveWarehouse().getItems());
            }
        }
        try {
            switch (this._sortorder) {
                case -1: 
                case 1: {
                    Collections.sort(this._objects, new WarehouseItemNameComparator(this._sortorder));
                    break;
                }
                case 2: {
                    if (this._itemtype != WarehouseListType.ARMOR && this._itemtype != WarehouseListType.WEAPON) break;
                    Collections.sort(this._objects, new WarehouseItemNameComparator(1));
                    Collections.sort(this._objects, new WarehouseItemGradeComparator(1));
                    break;
                }
                case 3: {
                    if (this._itemtype != WarehouseListType.RECIPE) break;
                    Collections.sort(this._objects, new WarehouseItemNameComparator(1));
                    Collections.sort(this._objects, new WarehouseItemRecipeComparator(1));
                    break;
                }
                case 4: {
                    if (this._itemtype != WarehouseListType.MATERIAL) break;
                    Collections.sort(this._objects, new WarehouseItemNameComparator(1));
                    Collections.sort(this._objects, new WarehouseItemTypeComparator(1));
                    break;
                }
                case 5: {
                    if (this._itemtype != WarehouseListType.ARMOR) break;
                    Collections.sort(this._objects, new WarehouseItemNameComparator(1));
                    Collections.sort(this._objects, new WarehouseItemBodypartComparator(1));
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static byte getOrder(String order) {
        if (order == null) {
            return 1;
        }
        if (order.startsWith("A2Z")) {
            return 1;
        }
        if (order.startsWith("Z2A")) {
            return -1;
        }
        if (order.startsWith("GRADE")) {
            return 2;
        }
        if (order.startsWith("TYPE")) {
            return 4;
        }
        if (order.startsWith("WEAR")) {
            return 5;
        }
        try {
            return Byte.parseByte(order);
        }
        catch (NumberFormatException ex) {
            return 1;
        }
    }

    private List<L2WarehouseItem> createWeaponList(L2ItemInstance[] _items) {
        FastList _list = new FastList();
        for (L2ItemInstance item : _items) {
            if (!item.isWeapon() && item.getItem().getType2() != 0 && (!item.isEtcItem() || item.getItemType() != L2EtcItemType.ARROW) && item.getItem().getType2() != 4 || _list.size() >= 300) continue;
            _list.add(new L2WarehouseItem(item));
        }
        return _list;
    }

    private List<L2WarehouseItem> createArmorList(L2ItemInstance[] _items) {
        FastList _list = new FastList();
        for (L2ItemInstance item : _items) {
            if (!item.isArmor() && item.getItem().getType2() != 4 || _list.size() >= 300) continue;
            _list.add(new L2WarehouseItem(item));
        }
        return _list;
    }

    private List<L2WarehouseItem> createEtcItemList(L2ItemInstance[] _items) {
        FastList _list = new FastList();
        for (L2ItemInstance item : _items) {
            if (!item.isEtcItem() && item.getItem().getType2() != 4 || _list.size() >= 300) continue;
            _list.add(new L2WarehouseItem(item));
        }
        return _list;
    }

    private List<L2WarehouseItem> createMatList(L2ItemInstance[] _items) {
        FastList _list = new FastList();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || item.getEtcItem().getItemType() != L2EtcItemType.MATERIAL) && item.getItem().getType2() != 4 || _list.size() >= 300) continue;
            _list.add(new L2WarehouseItem(item));
        }
        return _list;
    }

    private List<L2WarehouseItem> createRecipeList(L2ItemInstance[] _items) {
        FastList _list = new FastList();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || item.getEtcItem().getItemType() != L2EtcItemType.RECIPE) && item.getItem().getType2() != 4 || _list.size() >= 300) continue;
            _list.add(new L2WarehouseItem(item));
        }
        return _list;
    }

    private List<L2WarehouseItem> createAmulettList(L2ItemInstance[] _items) {
        FastList _list = new FastList();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || !item.getItemName().toUpperCase().startsWith("AMULET")) && item.getItem().getType2() != 4 || _list.size() >= 300) continue;
            _list.add(new L2WarehouseItem(item));
        }
        return _list;
    }

    private List<L2WarehouseItem> createSpellbookList(L2ItemInstance[] _items) {
        FastList _list = new FastList();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || item.getItemName().toUpperCase().startsWith("AMULET")) && item.getItem().getType2() != 4 || _list.size() >= 300) continue;
            _list.add(new L2WarehouseItem(item));
        }
        return _list;
    }

    private List<L2WarehouseItem> createConsumableList(L2ItemInstance[] _items) {
        FastList _list = new FastList();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || item.getEtcItem().getItemType() != L2EtcItemType.SCROLL && item.getEtcItem().getItemType() != L2EtcItemType.SHOT) && item.getItem().getType2() != 4 || _list.size() >= 300) continue;
            _list.add(new L2WarehouseItem(item));
        }
        return _list;
    }

    private List<L2WarehouseItem> createShotList(L2ItemInstance[] _items) {
        FastList _list = new FastList();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || item.getEtcItem().getItemType() != L2EtcItemType.SHOT) && item.getItem().getType2() != 4 || _list.size() >= 300) continue;
            _list.add(new L2WarehouseItem(item));
        }
        return _list;
    }

    private List<L2WarehouseItem> createScrollList(L2ItemInstance[] _items) {
        FastList _list = new FastList();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || item.getEtcItem().getItemType() != L2EtcItemType.SCROLL) && item.getItem().getType2() != 4 || _list.size() >= 300) continue;
            _list.add(new L2WarehouseItem(item));
        }
        return _list;
    }

    private List<L2WarehouseItem> createSeedList(L2ItemInstance[] _items) {
        FastList _list = new FastList();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || item.getEtcItem().getItemType() != L2EtcItemType.SEED) && item.getItem().getType2() != 4 || _list.size() >= 300) continue;
            _list.add(new L2WarehouseItem(item));
        }
        return _list;
    }

    private List<L2WarehouseItem> createOtherList(L2ItemInstance[] _items) {
        FastList _list = new FastList();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || item.getEtcItem().getItemType() == L2EtcItemType.MATERIAL || item.getEtcItem().getItemType() == L2EtcItemType.RECIPE || item.getEtcItem().getItemType() == L2EtcItemType.SCROLL || item.getEtcItem().getItemType() == L2EtcItemType.SHOT) && item.getItem().getType2() != 4 || _list.size() >= 300) continue;
            _list.add(new L2WarehouseItem(item));
        }
        return _list;
    }

    private List<L2WarehouseItem> createAllList(L2ItemInstance[] _items) {
        FastList _list = new FastList();
        for (L2ItemInstance item : _items) {
            if (_list.size() >= 300) continue;
            _list.add(new L2WarehouseItem(item));
        }
        return _list;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(66);
        this.writeH(this._whType);
        this.writeQ(this._playerAdena);
        this.writeH(this._objects.size());
        for (L2WarehouseItem item : this._objects) {
            this.writeD(item.getObjectId());
            this.writeD(item.getItem().getDisplayId());
            this.writeD(item.getLocationSlot());
            this.writeQ(item.getCount());
            this.writeH(item.getItem().getType2());
            this.writeH(item.getCustomType1());
            this.writeH(0);
            this.writeD(item.getItem().getBodyPart());
            this.writeH(item.getEnchantLevel());
            this.writeH(item.getCustomType2());
            if (item.isAugmented()) {
                this.writeD(item.getAugmentationId());
            } else {
                this.writeD(0);
            }
            this.writeD(item.getMana());
            this.writeD(item.getTime());
            this.writeH(item.getAttackElementType());
            this.writeH(item.getAttackElementPower());
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this.writeH(item.getElementDefAttr(i));
            }
            for (int op : item.getEnchantOptions()) {
                this.writeH(op);
            }
            this.writeD(item.getObjectId());
        }
    }

    private static class WarehouseItemTypeComparator
    implements Comparator<L2WarehouseItem> {
        byte order = 0;

        protected WarehouseItemTypeComparator(byte sortOrder) {
            this.order = sortOrder;
        }

        @Override
        public int compare(L2WarehouseItem o1, L2WarehouseItem o2) {
            if (o1.getType2() == 4 && o2.getType2() != 4) {
                return this.order == 1 ? -1 : 1;
            }
            if (o2.getType2() == 4 && o1.getType2() != 4) {
                return this.order == 1 ? 1 : -1;
            }
            try {
                Integer i1 = o1.getItem().getMaterialType();
                Integer i2 = o2.getItem().getMaterialType();
                return this.order == 1 ? i1.compareTo(i2) : i2.compareTo(i1);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }

    private static class WarehouseItemGradeComparator
    implements Comparator<L2WarehouseItem> {
        byte order = 0;

        protected WarehouseItemGradeComparator(byte sortOrder) {
            this.order = sortOrder;
        }

        @Override
        public int compare(L2WarehouseItem o1, L2WarehouseItem o2) {
            if (o1.getType2() == 4 && o2.getType2() != 4) {
                return this.order == 1 ? -1 : 1;
            }
            if (o2.getType2() == 4 && o1.getType2() != 4) {
                return this.order == 1 ? 1 : -1;
            }
            Integer i1 = o1.getItemGrade();
            Integer i2 = o2.getItemGrade();
            return this.order == 1 ? i1.compareTo(i2) : i2.compareTo(i1);
        }
    }

    private static class WarehouseItemBodypartComparator
    implements Comparator<L2WarehouseItem> {
        private byte order = 0;

        protected WarehouseItemBodypartComparator(byte sortOrder) {
            this.order = sortOrder;
        }

        @Override
        public int compare(L2WarehouseItem o1, L2WarehouseItem o2) {
            if (o1.getType2() == 4 && o2.getType2() != 4) {
                return this.order == 1 ? -1 : 1;
            }
            if (o2.getType2() == 4 && o1.getType2() != 4) {
                return this.order == 1 ? 1 : -1;
            }
            Integer i1 = o1.getBodyPart();
            Integer i2 = o2.getBodyPart();
            return this.order == 1 ? i1.compareTo(i2) : i2.compareTo(i1);
        }
    }

    private static class WarehouseItemRecipeComparator
    implements Comparator<L2WarehouseItem> {
        private int order = 0;
        private RecipeData rd = null;

        protected WarehouseItemRecipeComparator(int sortOrder) {
            this.order = sortOrder;
            this.rd = RecipeData.getInstance();
        }

        @Override
        public int compare(L2WarehouseItem o1, L2WarehouseItem o2) {
            if (o1.getType2() == 4 && o2.getType2() != 4) {
                return this.order == 1 ? -1 : 1;
            }
            if (o2.getType2() == 4 && o1.getType2() != 4) {
                return this.order == 1 ? 1 : -1;
            }
            if (o1.isEtcItem() && o1.getItemType() == L2EtcItemType.RECIPE && o2.isEtcItem() && o2.getItemType() == L2EtcItemType.RECIPE) {
                try {
                    L2RecipeList rp1 = this.rd.getRecipeByItemId(o1.getItemId());
                    L2RecipeList rp2 = this.rd.getRecipeByItemId(o2.getItemId());
                    if (rp1 == null) {
                        return this.order == 1 ? 1 : -1;
                    }
                    if (rp2 == null) {
                        return this.order == 1 ? -1 : 1;
                    }
                    Integer i1 = rp1.getLevel();
                    Integer i2 = rp2.getLevel();
                    return this.order == 1 ? i1.compareTo(i2) : i2.compareTo(i1);
                }
                catch (Exception e) {
                    return 0;
                }
            }
            String s1 = o1.getItemName();
            String s2 = o2.getItemName();
            return this.order == 1 ? s1.compareTo(s2) : s2.compareTo(s1);
        }
    }

    private static class WarehouseItemNameComparator
    implements Comparator<L2WarehouseItem> {
        private byte order = 0;

        protected WarehouseItemNameComparator(byte sortOrder) {
            this.order = sortOrder;
        }

        @Override
        public int compare(L2WarehouseItem o1, L2WarehouseItem o2) {
            if (o1.getType2() == 4 && o2.getType2() != 4) {
                return this.order == 1 ? -1 : 1;
            }
            if (o2.getType2() == 4 && o1.getType2() != 4) {
                return this.order == 1 ? 1 : -1;
            }
            String s1 = o1.getItemName();
            String s2 = o2.getItemName();
            return this.order == 1 ? s1.compareTo(s2) : s2.compareTo(s1);
        }
    }

    public static enum WarehouseListType {
        WEAPON,
        ARMOR,
        ETCITEM,
        MATERIAL,
        RECIPE,
        AMULETT,
        SPELLBOOK,
        SHOT,
        SCROLL,
        CONSUMABLE,
        SEED,
        POTION,
        QUEST,
        PET,
        OTHER,
        ALL;

    }
}

