/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.script.faenor;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.EventDroplist;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.script.DateRange;
import com.l2jserver.gameserver.script.EventDrop;
import com.l2jserver.gameserver.script.Parser;
import com.l2jserver.gameserver.script.ParserNotCreatedException;
import com.l2jserver.gameserver.script.ScriptDocument;
import com.l2jserver.gameserver.script.ScriptEngine;
import com.l2jserver.util.Util;
import com.l2jserver.util.file.filter.XMLFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptContext;
import org.w3c.dom.Node;

public class FaenorScriptEngine
extends ScriptEngine {
    private static final Logger _log = Logger.getLogger(FaenorScriptEngine.class.getName());
    public static final String PACKAGE_DIRECTORY = "data/faenor/";

    protected FaenorScriptEngine() {
        File[] files;
        File packDirectory = new File(Config.DATAPACK_ROOT, PACKAGE_DIRECTORY);
        for (File file : files = packDirectory.listFiles(new XMLFilter())) {
            _log.info("FaenorScriptEngine: " + file.getPath());
            try (FileInputStream in = new FileInputStream(file);){
                this.parseScript(new ScriptDocument(file.getName(), in), null);
            }
            catch (IOException e) {
                _log.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private void parseScript(ScriptDocument script, ScriptContext context) {
        Node node = script.getDocument().getFirstChild();
        String parserClass = "faenor.Faenor" + node.getNodeName() + "Parser";
        Parser parser = null;
        try {
            parser = FaenorScriptEngine.createParser(parserClass);
        }
        catch (ParserNotCreatedException e) {
            _log.log(Level.WARNING, "ERROR: No parser registered for Script: " + parserClass + ": " + e.getMessage(), e);
        }
        if (parser == null) {
            _log.warning("Unknown Script Type: " + script.getName());
            return;
        }
        parser.parseScript(node, context);
    }

    public static FaenorScriptEngine getInstance() {
        return SingletonHolder._instance;
    }

    public void dump() {
        System.out.println("FaenorScriptEngine:");
        for (EventDroplist.DateDrop dateDrop : EventDroplist.getInstance().getAllDrops()) {
            EventDrop eventDrop = dateDrop.getEventDrop();
            DateRange dateRange = dateDrop.getDateRange();
            System.out.println("  Active=" + Util.dateFormat(dateRange.getStartDate()) + "-" + Util.dateFormat(dateRange.getEndDate()));
            System.out.println("  Count=" + eventDrop.getMinCount() + "," + eventDrop.getMaxCount() + " Chance=" + (double)eventDrop.getDropChance() * 100.0 / 1000000.0 + "%");
            for (int itemId : eventDrop.getItemIdList()) {
                L2Item i = ItemTable.getInstance().getTemplate(itemId);
                System.out.println("    Item=" + itemId + " " + (i == null ? "NULL" : i.getName()));
            }
        }
    }

    private static class SingletonHolder {
        protected static final FaenorScriptEngine _instance = new FaenorScriptEngine();

        private SingletonHolder() {
        }
    }
}

