/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager.tasks;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.instancemanager.MailManager;
import com.l2jserver.gameserver.model.entity.Message;
import com.l2jserver.gameserver.model.itemcontainer.Mail;
import com.l2jserver.gameserver.taskmanager.Task;
import com.l2jserver.gameserver.taskmanager.TaskManager;
import com.l2jserver.gameserver.taskmanager.TaskTypes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.logging.Level;

public class TaskBirthday
extends Task {
    private static final String NAME = "birthday";
    private static final String QUERY = "SELECT charId, createDate FROM characters WHERE createDate LIKE ?";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void onTimeElapsed(TaskManager.ExecutedTask task) {
        Calendar now = Calendar.getInstance();
        now.set(11, 23);
        now.set(12, 59);
        now.set(13, 59);
        now.set(14, 999);
        GregorianCalendar birth = new GregorianCalendar();
        long lastActivation = task.getLastActivation();
        if (lastActivation != 0L) {
            birth.setTimeInMillis(lastActivation);
            birth.add(5, 1);
        }
        while (!birth.after(now)) {
            int year = birth.get(1);
            int month = birth.get(2) + 1;
            int day = birth.get(5);
            this.checkBirthday(year, month, day);
            if (month == 2 && day == 28 && !birth.isLeapYear(birth.get(1))) {
                this.checkBirthday(year, 2, 29);
            }
            birth.add(5, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBirthday(int year, int month, int day) {
        int count = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(QUERY);){
            statement.setString(1, "%-" + this.getNum(month) + "-" + this.getNum(day));
            try (ResultSet rset = statement.executeQuery();){
                while (rset.next()) {
                    int playerId = rset.getInt("charId");
                    Calendar createDate = Calendar.getInstance();
                    createDate.setTime(rset.getDate("createDate"));
                    int age = year - createDate.get(1);
                    if (age <= 0) continue;
                    String text = Config.ALT_BIRTHDAY_MAIL_TEXT;
                    if (text.contains("$c1")) {
                        text = text.replace("$c1", CharNameTable.getInstance().getNameById(playerId));
                    }
                    if (text.contains("$s1")) {
                        text = text.replace("$s1", String.valueOf(age));
                    }
                    Message msg = new Message(playerId, Config.ALT_BIRTHDAY_MAIL_SUBJECT, text, Message.SendBySystem.ALEGRIA);
                    Mail attachments = msg.createAttachments();
                    attachments.addItem("Birthday", Config.ALT_BIRTHDAY_GIFT, 1L, null, null);
                    MailManager.getInstance().sendMessage(msg);
                    ++count;
                }
            }
        }
        catch (SQLException e) {
            this._log.log(Level.WARNING, "Error checking birthdays. ", e);
        }
        finally {
            this._log.info("BirthdayManager: " + count + " gifts sent. " + year + "/" + month + "/" + day);
        }
    }

    private String getNum(int num) {
        return num <= 9 ? "0" + num : String.valueOf(num);
    }

    @Override
    public void initializate() {
        super.initializate();
        TaskManager.addUniqueTask(NAME, TaskTypes.TYPE_GLOBAL_TASK, "1", "06:30:00", "");
    }
}

