/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public class StackTrace {
    private static final Logger _log = Logger.getLogger(StackTrace.class.getName());

    public static boolean displayStackTraceInformation(Throwable ex) {
        return StackTrace.displayStackTraceInformation(ex, false);
    }

    public static boolean displayStackTraceInformation(Throwable ex, boolean displayAll) {
        if (ex == null) {
            return false;
        }
        _log.log(Level.INFO, "", ex);
        if (!displayAll) {
            return true;
        }
        StackTraceElement[] stackElements = ex.getStackTrace();
        _log.log(Level.INFO, "The " + stackElements.length + " element" + (stackElements.length == 1 ? "" : "s") + " of the stack trace:\n");
        for (StackTraceElement stackElement : stackElements) {
            _log.log(Level.INFO, "File name: " + stackElement.getFileName());
            _log.log(Level.INFO, "Line number: " + stackElement.getLineNumber());
            String className = stackElement.getClassName();
            String packageName = StackTrace.extractPackageName(className);
            String simpleClassName = StackTrace.extractSimpleClassName(className);
            _log.log(Level.INFO, "Package name: " + ("".equals(packageName) ? "[default package]" : packageName));
            _log.log(Level.INFO, "Full class name: " + className);
            _log.log(Level.INFO, "Simple class name: " + simpleClassName);
            _log.log(Level.INFO, "Unmunged class name: " + StackTrace.unmungeSimpleClassName(simpleClassName));
            _log.log(Level.INFO, "Direct class name: " + StackTrace.extractDirectClassName(simpleClassName));
            _log.log(Level.INFO, "Method name: " + stackElement.getMethodName());
            _log.log(Level.INFO, "Native method?: " + stackElement.isNativeMethod());
            _log.log(Level.INFO, "toString(): " + stackElement.toString());
            _log.log(Level.INFO, "");
        }
        _log.log(Level.INFO, "");
        return true;
    }

    private static String extractPackageName(String fullClassName) {
        if (null == fullClassName || fullClassName.isEmpty()) {
            return "";
        }
        int lastDot = fullClassName.lastIndexOf(46);
        if (0 >= lastDot) {
            return "";
        }
        return fullClassName.substring(0, lastDot);
    }

    private static String extractSimpleClassName(String fullClassName) {
        if (null == fullClassName || fullClassName.isEmpty()) {
            return "";
        }
        int lastDot = fullClassName.lastIndexOf(46);
        if (0 > lastDot) {
            return fullClassName;
        }
        return fullClassName.substring(++lastDot);
    }

    private static String extractDirectClassName(String simpleClassName) {
        if (null == simpleClassName || simpleClassName.isEmpty()) {
            return "";
        }
        int lastSign = simpleClassName.lastIndexOf(36);
        if (0 > lastSign) {
            return simpleClassName;
        }
        return simpleClassName.substring(++lastSign);
    }

    private static String unmungeSimpleClassName(String simpleClassName) {
        if (null == simpleClassName || simpleClassName.isEmpty()) {
            return "";
        }
        return simpleClassName.replace('$', '.');
    }
}

