/*
 * Copyright (C) 2004-2014 L2J DataPack
 *
 * This file is part of L2J DataPack.
 *
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.individual.Antharas;

import static com.l2jserver.gameserver.datatables.SkillTable.*;

import java.util.List;

import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;
import ai.npc.AbstractNpcAI;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.enums.MountType;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.zone.type.L2NoRestartZone;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.serverpackets.Earthquake;
import com.l2jserver.gameserver.network.serverpackets.ExShowScreenMessage;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.SpecialCamera;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.gameserver.util.Util;

/**
 * Antharas AI.
 * @author St3eT
 */
public final class Antharas extends AbstractNpcAI
{
	// NPC
	private static final int ANTHARAS = 29068; // Antharas
	private static final int BEHEMOTH = 29069; // Behemoth Dragon
	private static final int TERASQUE = 29190; // Tarask Dragon
	private static final int BOMBER = 29070; // Dragon Bomber
	private static final int HEART = 13001; // Heart of Warding
	private static final int CUBE = 31859; // Teleportation Cubic
	private static final SortedIntObjectArrayMap<Location> INVISIBLE_NPC = new SortedIntObjectArrayMap<Location>()
		.append(29077, new Location(177229, 113298, -7735)) // antaras_clear_npc_1
		.append(29078, new Location(176707, 113585, -7735)) // antaras_clear_npc_2
		.append(29079, new Location(176385, 113889, -7735)) // antaras_clear_npc_3
		.append(29080, new Location(176082, 114241, -7735)) // antaras_clear_npc_4
		.append(29081, new Location(176066, 114802, -7735)) // antaras_clear_npc_5
		.append(29082, new Location(176095, 115313, -7735)) // antaras_clear_npc_6
		.append(29083, new Location(176425, 115829, -7735)) // antaras_clear_npc_7
		.append(29084, new Location(176949, 116378, -7735)) // antaras_clear_npc_8
		.append(29085, new Location(177655, 116402, -7735)) // antaras_clear_npc_9
		.append(29086, new Location(178248, 116395, -7735)) // antaras_clear_npc_10
		.append(29087, new Location(178706, 115998, -7735)) // antaras_clear_npc_11
		.append(29088, new Location(179208, 115452, -7735)) // antaras_clear_npc_12
		.append(29089, new Location(179191, 115079, -7735)) // antaras_clear_npc_13
		.append(29090, new Location(179221, 114546, -7735)) // antaras_clear_npc_14
		.append(29091, new Location(178916, 113925, -7735)) // antaras_clear_npc_15
		.append(29092, new Location(178782, 113814, -7735)) // antaras_clear_npc_16
		.append(29093, new Location(178419, 113417, -7735)) // antaras_clear_npc_17
		.append(29094, new Location(177855, 113282, -7735)) // antaras_clear_npc_18
	;
	
	// Item
	private static final int STONE = 3865; // Portal Stone
	// Skill
	private static final int ANTH_JUMP = getSkillHashCode(4106, 1); // Antharas Stun
	private static final int ANTH_TAIL = getSkillHashCode(4107, 1); // Antharas Stun
	private static final int ANTH_FEAR = getSkillHashCode(4108, 1); // Antharas Terror
	private static final int ANTH_DEBUFF = getSkillHashCode(4109, 1); // Curse of Antharas
	private static final int ANTH_MOUTH = getSkillHashCode(4110, 2); // Breath Attack
	private static final int ANTH_BREATH = getSkillHashCode(4111, 1); // Antharas Fossilization
	private static final int ANTH_NORM_ATTACK = getSkillHashCode(4112, 1); // Ordinary Attack
	private static final int ANTH_NORM_ATTACK_EX = getSkillHashCode(4113, 1); // Animal doing ordinary attack
	private static final int ANTH_REGEN_1 = getSkillHashCode(4125, 1); // Antharas Regeneration
	private static final int ANTH_REGEN_2 = getSkillHashCode(4239, 1); // Antharas Regeneration
	private static final int ANTH_REGEN_3 = getSkillHashCode(4240, 1); // Antharas Regeneration
	private static final int ANTH_REGEN_4 = getSkillHashCode(4241, 1); // Antharas Regeneration
	private static final int DISPEL_BOM = getSkillHashCode(5042, 1); // NPC Dispel Bomb
	private static final int ANTH_ANTI_STRIDER = getSkillHashCode(4258, 1); // Hinder Strider
	private static final int ANTH_FEAR_SHORT = getSkillHashCode(5092, 1); // Antharas Terror
	private static final int ANTH_METEOR = getSkillHashCode(5093, 1); // Antharas Meteor
	// Zone
	private static final L2NoRestartZone zone = ZoneManager.getInstance().getZoneById(70050, L2NoRestartZone.class); // Antharas Nest zone
	// Status
	private static final int ALIVE = 0;		// DORMANT
	private static final int WAITING = 1;
	private static final int IN_FIGHT = 2;	// FIGHTING
	private static final int DEAD = 3;
	// Misc
	private static final int MAX_PEOPLE = 200; // Max allowed players
	private static final int INACTIVITY_TIME = 900000; // Activity time
	private static final int CLEAR_DELAY = 900000; // Clear delay
	private static final boolean SERVERE_ARTHQUAKE = true; // Do servere arthquake
	private static final int MAX_MINIONS = 100; // Max minions
	private static final int SPAWN_MINION_INTERVAL = 300000; // Interval of minions
	
	private L2GrandBossInstance _antharas = null;
	private static long _lastAttack;
	private static int _minionCount;
	private static int minionMultipler;
	private static int moveChance;
	private static int sandStorm;
	private static L2PcInstance attacker_1;
	private static L2PcInstance attacker_2;
	private static L2PcInstance attacker_3;
	private static int attacker_1_hate;
	private static int attacker_2_hate;
	private static int attacker_3_hate;
	
	private void init()
	{
		_lastAttack = 0;
		_minionCount = 0;
		minionMultipler = 0;
		moveChance = 0;
		sandStorm = 0;
		attacker_1 = null;
		attacker_2 = null;
		attacker_3 = null;
		attacker_1_hate = 0;
		attacker_2_hate = 0;
		attacker_3_hate = 0;
	}
	
	private Antharas()
	{
		super(Antharas.class.getSimpleName(), "ai/individual");
		addStartNpc(HEART, CUBE);
		addTalkId(HEART, CUBE);
		addFirstTalkId(HEART);
		addSpawnId(INVISIBLE_NPC.keySet());
		addSpawnId(ANTHARAS);
		addMoveFinishedId(BOMBER);
		addAggroRangeEnterId(BOMBER);
		addSpellFinishedId(ANTHARAS);
		addAttackId(ANTHARAS, BOMBER/*, BEHEMOTH, TERASQUE*/);
		addKillId(ANTHARAS, TERASQUE, BEHEMOTH);
		
		final StatsSet info = GrandBossManager.getInstance().getStatsSet(ANTHARAS);
		final int curr_hp = info.getInt("currentHP");
		final int curr_mp = info.getInt("currentMP");
		final int loc_x = info.getInt("loc_x");
		final int loc_y = info.getInt("loc_y");
		final int loc_z = info.getInt("loc_z");
		final int heading = info.getInt("heading");
		final long respawnTime = info.getLong("respawn_time");
		
		switch (getStatus())
		{
			case ALIVE:
			{
				_antharas = (L2GrandBossInstance) addSpawn(ANTHARAS, 185708, 114298, -8221, 0, false, 0);
				_antharas.setCurrentHpMp(curr_hp, curr_mp);
				addBoss(_antharas);
				break;
			}
			case WAITING:
			{
				_antharas = (L2GrandBossInstance) addSpawn(ANTHARAS, 185708, 114298, -8221, 0, false, 0);
				_antharas.setCurrentHpMp(curr_hp, curr_mp);
				addBoss(_antharas);
				startQuestTimer("SPAWN_ANTHARAS", Config.ANTHARAS_WAIT_TIME * 60000, null, null);
				break;
			}
			case IN_FIGHT:
			{
				_antharas = (L2GrandBossInstance) addSpawn(ANTHARAS, loc_x, loc_y, loc_z, heading, false, 0);
				_antharas.setCurrentHpMp(curr_hp, curr_mp);
				addBoss(_antharas);
				_lastAttack = System.currentTimeMillis();
				startQuestTimer("CHECK_ATTACK", 60000, _antharas, null);
				startQuestTimer("SPAWN_MINION", SPAWN_MINION_INTERVAL, _antharas, null);
				break;
			}
			case DEAD:
			{
				final long remain = respawnTime - System.currentTimeMillis();
				if (remain > 0)
				{
					startQuestTimer("CLEAR_STATUS", remain, null, null);
				}
				else
				{
					setStatus(ALIVE);
					_antharas = (L2GrandBossInstance) addSpawn(ANTHARAS, 185708, 114298, -8221, 0, false, 0);
					addBoss(_antharas);
				}
				break;
			}
		}
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		switch (event)
		{
			case "enter":	// 13001.html
			{
				String htmltext = null;
				if (getStatus() == DEAD)
				{
					htmltext = "13001-01.html";
				}
				else if (getStatus() == IN_FIGHT)
				{
					htmltext = "13001-02.html";
				}
				else if (player.isInParty())
				{
					final L2Party party = player.getParty();
					final boolean isInCC = party.isInCommandChannel();
					final List<L2PcInstance> members = (isInCC) ? party.getCommandChannel().getMembers() : party.getMembers();
					final boolean isPartyLeader = (isInCC) ? party.getCommandChannel().isLeader(player) : party.isLeader(player);
					if (!isPartyLeader)
					{
						htmltext = "13001-05.html";
					}
					else if (!hasQuestItems(player, STONE))
					{
						htmltext = "13001-03.html";
					}
					else if (zone.getPlayersInside().size() + members.size() > MAX_PEOPLE)
					{
						htmltext = "13001-04.html";
					}
					else
					{
						for (L2PcInstance member : members)
						{
							if (member.isInsideRadius(npc, 1000, true, false))
							{
								member.teleToLocation(179700 + getRandom(700), 113800 + getRandom(2100), -7709);
							}
						}
						if (getStatus() != WAITING)
						{
							init();
							setStatus(WAITING);
							startQuestTimer("SPAWN_ANTHARAS", Config.ANTHARAS_WAIT_TIME * 60000, null, null);
						}
					}
				}
				else
				{
					if (!hasQuestItems(player, STONE))
					{
						htmltext = "13001-03.html";
					}
					else if (zone.getPlayersInside().size() + 1 > MAX_PEOPLE)
					{
						htmltext = "13001-04.html";
					}
					else
					{
						player.teleToLocation(179700 + getRandom(700), 113800 + getRandom(2100), -7709);
						if (getStatus() != WAITING)
						{
							init();
							setStatus(WAITING);
							startQuestTimer("SPAWN_ANTHARAS", Config.ANTHARAS_WAIT_TIME * 60000, null, null);
						}
					}
				}
				return htmltext;
			}
			case "teleportOut":
			{
				player.teleToLocation(79800 + getRandom(600), 151200 + getRandom(1100), -3534);
				break;
			}
			case "SPAWN_ANTHARAS":
			{
				_antharas.teleToLocation(181323, 114850, -7623, 32542);
				setStatus(IN_FIGHT);
				_lastAttack = System.currentTimeMillis();
				zone.broadcastPacket(new PlaySound("BS02_A"));
				startQuestTimer("CAMERA_1", 23, _antharas, null);
				break;
			}
			case "CAMERA_1":
			{
				zone.broadcastPacket(new SpecialCamera(npc, 700, 13, -19, 0, 10000, 20000, 0, 0, 0, 0, 0));
				startQuestTimer("CAMERA_2", 3000, npc, null);
				break;
			}
			case "CAMERA_2":
			{
				zone.broadcastPacket(new SpecialCamera(npc, 700, 13, 0, 6000, 10000, 20000, 0, 0, 0, 0, 0));
				startQuestTimer("CAMERA_3", 10000, npc, null);
				break;
			}
			case "CAMERA_3":
			{
				zone.broadcastPacket(new SpecialCamera(npc, 3700, 0, -3, 0, 10000, 10000, 0, 0, 0, 0, 0));
				zone.broadcastPacket(new SocialAction(npc.getObjectId(), 1));
				startQuestTimer("CAMERA_4", 200, npc, null);
				startQuestTimer("SOCIAL", 5200, npc, null);
				break;
			}
			case "CAMERA_4":
			{
				zone.broadcastPacket(new SpecialCamera(npc, 1100, 0, -3, 22000, 10000, 30000, 0, 0, 0, 0, 0));
				startQuestTimer("CAMERA_5", 10800, npc, null);
				break;
			}
			case "CAMERA_5":
			{
				zone.broadcastPacket(new SpecialCamera(npc, 1100, 0, -3, 300, 10000, 7000, 0, 0, 0, 0, 0));
				startQuestTimer("START_MOVE", 1900, npc, null);
				break;
			}
			case "SOCIAL":
			{
				zone.broadcastPacket(new SocialAction(npc.getObjectId(), 2));
				break;
			}
			case "START_MOVE":
			{
				for (L2PcInstance players : npc.getKnownList().getKnownPlayersInRadius(4000))
				{
					if (players.isHero())
					{
						zone.broadcastPacket(new ExShowScreenMessage(NpcStringId.S1_YOU_CANNOT_HOPE_TO_DEFEAT_ME_WITH_YOUR_MEAGER_STRENGTH, 2, 4000, players.getName()));
						break;
					}
				}
				npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new Location(179011, 114871, -7704));
				startQuestTimer("CHECK_ATTACK", 60000, npc, null);
				startQuestTimer("SPAWN_MINION", 300000, npc, null);
				startQuestTimer("SET_REGEN", 60000, npc, null);		//[JOJO] onSpawnz
				break;
			}
			case "SET_REGEN":	// ANTHARAS
			{
				if (isFighting(npc))
				{
					final double hpRatio = npc.getCurrentHp() / npc.getMaxHp();
					if (hpRatio < 0.25)
					{
						if (!npc.isAffectedBySkill(getSkillId(ANTH_REGEN_4)))
						{
							npc.doCast(getSkill(ANTH_REGEN_4));
						}
					}
					else if (hpRatio < 0.5)
					{
						if (!npc.isAffectedBySkill(getSkillId(ANTH_REGEN_3)))
						{
							npc.doCast(getSkill(ANTH_REGEN_3));
						}
					}
					else if (hpRatio < 0.75)
					{
						if (!npc.isAffectedBySkill(getSkillId(ANTH_REGEN_2)))
						{
							npc.doCast(getSkill(ANTH_REGEN_2));
						}
					}
					else
					{
						if (!npc.isAffectedBySkill(getSkillId(ANTH_REGEN_1)))
						{
							npc.doCast(getSkill(ANTH_REGEN_1));
						}
					}
					startQuestTimer("SET_REGEN", 60000, npc, null);	// loop
				}
				break;
			}
			case "CHECK_ATTACK":
			{
				if (_lastAttack + INACTIVITY_TIME < System.currentTimeMillis())
				{
					cancelQuestTimer("SET_REGEN", npc, null);
					cancelQuestTimer("CHECK_ATTACK", npc, null);
					cancelQuestTimer("SPAWN_MINION", npc, null);
					setStatus(ALIVE);
					for (L2Character charInside : zone.getCharactersInside())
					{
						if (charInside != null)
						{
							if (charInside.isNpc())
							{
								if (charInside.getId() == ANTHARAS)
								{
									charInside.teleToLocation(185708, 114298, -8221);
								}
								else
								{
									charInside.deleteMe();
								}
							}
							else if (charInside.isPlayer())
							{
								charInside.teleToLocation(79800 + getRandom(600), 151200 + getRandom(1100), -3534);
							}
						}
					}
					init();
				}
				else
				{
					if (attacker_1_hate > 10)
					{
						attacker_1_hate -= getRandom(10);
					}
					if (attacker_2_hate > 10)
					{
						attacker_2_hate -= getRandom(10);
					}
					if (attacker_3_hate > 10)
					{
						attacker_3_hate -= getRandom(10);
					}
					manageSkills(npc);
					startQuestTimer("CHECK_ATTACK", 60000, npc, null);	// loop
				}
				break;
			}
			case "SPAWN_MINION":	// ANTHARAS
			{
				if (isFighting(npc))
				{
					for (int i = 0; i < minionMultipler && _minionCount < MAX_MINIONS; ++i, ++_minionCount)
					{
						addSpawn(getRandomBoolean() ? BEHEMOTH : TERASQUE, npc, true);
					}
					
					if (minionMultipler < 4 && getRandom(100) < 90)
					{
						minionMultipler++;
					}
					startQuestTimer("SPAWN_MINION", 300000, npc, null);	// loop
				}
				break;
			}
			case "CLEAR_ZONE":
			{
				for (L2Character charInside : zone.getCharactersInside())
				{
					if (charInside != null)
					{
						if (charInside.isNpc())
						{
							charInside.deleteMe();
						}
						else if (charInside.isPlayer())
						{
							charInside.teleToLocation(79800 + getRandom(600), 151200 + getRandom(1100), -3534);
						}
					}
				}
				init();
				break;
			}
			case "TID_USED_FEAR":	// ANTHARAS
			{
				if (isFighting(npc))
				{
					if (sandStorm == 0)
					{
						sandStorm = 1;
						moveChance = 0;
						npc.disableCoreAI(true);
						npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new Location(177648, 114816, -7735));
						startQuestTimer("TID_FEAR_MOVE_TIMEOVER", 2000, npc, null);
						startQuestTimer("TID_FEAR_COOLTIME", 300000, npc, null);
					}
				}
				break;
			}
			case "TID_FEAR_COOLTIME":	// ANTHARAS
			{
				sandStorm = 0;
				break;
			}
			case "TID_FEAR_MOVE_TIMEOVER":	// ANTHARAS
			{
				if (isFighting(npc))
				{
					if (sandStorm == 1)
					{
						if (npc.getX() == 177648 && npc.getY() == 114816)
						{
							sandStorm = 2;
							npc.disableCoreAI(false);
							for (int index = 0; index < INVISIBLE_NPC.size(); ++index)
							{
								addSpawn(INVISIBLE_NPC.keyAt(index), INVISIBLE_NPC.valueAt(index));
							}
						}
						else
						{
							if (++moveChance <= 4)
							{
								npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new Location(177648, 114816, -7735));
								startQuestTimer("TID_FEAR_MOVE_TIMEOVER", 5000, npc, null);	// loop
							}
							else
							{
								npc.teleToLocation(177648, 114816, -7735, npc.getHeading());
								startQuestTimer("TID_FEAR_MOVE_TIMEOVER", 1000, npc, null);	// loop
							}
						}
					}
				}
				break;
			}
			case "CLEAR_STATUS":
			{
				_antharas = (L2GrandBossInstance) addSpawn(ANTHARAS, 185708, 114298, -8221, 0, false, 0);
				addBoss(_antharas);
				if (SERVERE_ARTHQUAKE)
					Broadcast.toAllOnlinePlayers(new Earthquake(185708, 114298, -8221, 20, 10));
				setStatus(ALIVE);
				break;
			}
			case "SKIP_WAITING":	// AdminGrandBoss.java "admin_grandboss_skip 29068"
			{
				if (getStatus() == WAITING)
				{
					cancelQuestTimer("SPAWN_ANTHARAS", null, null);
					notifyEvent("SPAWN_ANTHARAS", null, null);
					player.sendMessage(getClass().getSimpleName() + ": Skipping waiting time ...");
				}
				else
				{
					player.sendMessage(getClass().getSimpleName() + ": You cant skip waiting time right now!");
				}
				break;
			}
			case "RESPAWN_ANTHARAS":	// AdminGrandBoss.java "admin_grandboss_respawn 29068"
			{
				if (getStatus() == DEAD)
				{
					setRespawn(0);
					cancelQuestTimer("CLEAR_STATUS", null, null);
					notifyEvent("CLEAR_STATUS", null, null);
					player.sendMessage(getClass().getSimpleName() + ": Antharas has been respawned.");
				}
				else
				{
					player.sendMessage(getClass().getSimpleName() + ": You cant respawn antharas while antharas is alive!");
				}
				break;
			}
			case "DESPAWN_MINIONS":	// AdminGrandBoss.java "admin_grandboss_minions 29068"
			{
				if (getStatus() == IN_FIGHT)
				{
					_minionCount = 0;
					for (L2Character charInside : zone.getCharactersInside())
					{
						if ((charInside != null) && charInside.isNpc() && ((charInside.getId() == BEHEMOTH) || (charInside.getId() == TERASQUE)))
						{
							charInside.deleteMe();
						}
					}
					if (player != null) // Player dont will be null just when is this event called from GM command
					{
						player.sendMessage(getClass().getSimpleName() + ": All minions has been deleted!");
					}
				}
				else if (player != null) // Player dont will be null just when is this event called from GM command
				{
					player.sendMessage(getClass().getSimpleName() + ": You cant despawn minions right now!");
				}
				break;
			}
			case "ABORT_FIGHT":	// AdminGrandBoss.java "admin_grandboss_abort 29068"
			{
				if (getStatus() == IN_FIGHT)
				{
					if (npc != null || (npc = _antharas) != null)
					{
						cancelQuestTimer("SET_REGEN", npc, null);
						cancelQuestTimer("CHECK_ATTACK", npc, null);
						cancelQuestTimer("SPAWN_MINION", npc, null);
					}
					setStatus(ALIVE);
					for (L2Character charInside : zone.getCharactersInside())
					{
						if (charInside != null)
						{
							if (charInside.isNpc())
							{
								if (charInside.getId() == ANTHARAS)
								{
									charInside.teleToLocation(185708, 114298, -8221);
								}
								else
								{
									charInside.deleteMe();
								}
							}
							else if (charInside.isPlayer() && !charInside.isGM())
							{
								charInside.teleToLocation(79800 + getRandom(600), 151200 + getRandom(1100), -3534);
							}
						}
					}
					init();
					player.sendMessage(getClass().getSimpleName() + ": Fight has been aborted!");
				}
				else
				{
					player.sendMessage(getClass().getSimpleName() + ": You cant abort fight right now!");
				}
				break;
			}
			case "MANAGE_SKILL":
			{
				manageSkills(npc);
				break;
			}
		}
		return super.onAdvEvent(event, npc, player);
	}
	
	@Override
	public String onAggroRangeEnter(L2Npc npc, L2PcInstance player, boolean isSummon)
	{
		// BOMBER
		npc.doCast(getSkill(DISPEL_BOM));
		npc.doDie(player);
		return super.onAggroRangeEnter(npc, player, isSummon);
	}
	
	@Override
	public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isSummon, L2Skill skill)
	{
		// ANTHARAS, BOMBER, BEHEMOTH, TERASQUE
		_lastAttack = System.currentTimeMillis();
		
		if (npc.getId() == BOMBER)
		{
			if (npc.calculateDistance(attacker, true, false) < 230)
			{
				npc.doCast(getSkill(DISPEL_BOM));
				npc.doDie(attacker);
			}
		}
		else if (npc.getId() == ANTHARAS)
		{
			if (!zone.isCharacterInZone(attacker) || (getStatus() != IN_FIGHT))
			{
				_log.warning(getClass().getSimpleName() + ": Player " + attacker.getName() + " attacked Antharas in invalid conditions!");
				attacker.teleToLocation(80464, 152294, -3534);
			}
			
			if ((attacker.getMountType() == MountType.STRIDER) && !attacker.isAffectedBySkill(getSkillId(ANTH_ANTI_STRIDER)))
			{
				if (npc.checkDoCastConditions(getSkill(ANTH_ANTI_STRIDER)))
				{
					npc.setTarget(attacker);
					npc.doCast(getSkill(ANTH_ANTI_STRIDER));
				}
			}
			
			final double hpRatio = npc.getCurrentHp() / npc.getMaxHp();
			if (skill == null)
			{
				refreshAiParams(attacker, damage * 1000);
			}
			else if (hpRatio < 0.25)
			{
				refreshAiParams(attacker, damage * 33);
			}
			else if (hpRatio < 0.5)
			{
				refreshAiParams(attacker, damage * 20);
			}
			else if (hpRatio < 0.75)
			{
				refreshAiParams(attacker, damage * 10);
			}
			else
			{
				refreshAiParams(attacker, damage * 6);
			}
			manageSkills(npc);
		}
		return super.onAttack(npc, attacker, damage, isSummon, skill);
	}
	
	@Override
	public String onKill(L2Npc npc, L2PcInstance killer, boolean isSummon)
	{
		if (zone.isCharacterInZone(killer))
		{
			if (npc.getId() == ANTHARAS)
			{
				_antharas = null;
				cancelQuestTimer("SET_REGEN", npc, null);
				cancelQuestTimer("CHECK_ATTACK", npc, null);
				cancelQuestTimer("SPAWN_MINION", npc, null);
				notifyEvent("DESPAWN_MINIONS", null, null);
				zone.broadcastPacket(new SpecialCamera(npc, 1200, 20, -10, 0, 10000, 13000, 0, 0, 0, 0, 0));
				zone.broadcastPacket(new PlaySound("BS01_D"));
				addSpawn(CUBE, 177615, 114941, -7709, 0, false, CLEAR_DELAY);
				long respawnTime = (Config.ANTHARAS_SPAWN_INTERVAL + getRandom(-Config.ANTHARAS_SPAWN_RANDOM, Config.ANTHARAS_SPAWN_RANDOM)) * 3600000;
				if (respawnTime < CLEAR_DELAY + 10000) respawnTime = CLEAR_DELAY + 10000;
				setRespawn(respawnTime);
				startQuestTimer("CLEAR_ZONE", CLEAR_DELAY, null, null);
				startQuestTimer("CLEAR_STATUS", respawnTime, null, null);
				setStatus(DEAD);
				
				zone.broadcastPacket(new ExShowScreenMessage(NpcStringId.THE_EVIL_LAND_DRAGON_ANTHARAS_HAS_BEEN_DEFEATED, ExShowScreenMessage.TOP_CENTER, 30000));	//[JOJO]
			}
			else // TERASQUE | BEHEMOTH
			{
				_minionCount--;
			}
		}
		return super.onKill(npc, killer, isSummon);
	}
	
	@Override
	public boolean onMoveFinished(L2Npc npc)
	{
		// BOMBER
		npc.doCast(getSkill(DISPEL_BOM));
		npc.doDie(null);
		return false;
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
		if (npc.isTeleporting())
			return null;
		
		if (npc.getId() == ANTHARAS)
		{
			//cancelQuestTimer("SET_REGEN", npc, null);	
			//startQuestTimer("SET_REGEN", 60000, npc, null);	//[JOJO] onAdvEvent() "START_MOVE"Ɉړ
			((L2Attackable) npc).setOnKillDelay(0);
		}
		else // INVISIBLE_NPC[]
		{
			for (int i = 1; i <= 6; i++)
			{
				final int x = npc.getTemplate().getParameters().getInt("suicide" + i + "_x");
				final int y = npc.getTemplate().getParameters().getInt("suicide" + i + "_y");
				final L2Attackable bomber = (L2Attackable) addSpawn(BOMBER, npc.getX(), npc.getY(), npc.getZ(), 0, true, 15000, true);
				bomber.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new Location(x, y, npc.getZ()));
			}
			npc.deleteMe();
		}
		return super.onSpawn(npc);
	}
	
	@Override
	public String onSpellFinished(L2Npc npc, L2PcInstance player, L2Skill skill)
	{
		// ANTHARAS
		if ((skill.getId() == getSkillId(ANTH_FEAR)) || (skill.getId() == getSkillId(ANTH_FEAR_SHORT)))
		{
			startQuestTimer("TID_USED_FEAR", 7000, npc, null);
		}
		startQuestTimer("MANAGE_SKILL", 1000, npc, null);
		return super.onSpellFinished(npc, player, skill);
	}
	
	@Override
	public boolean unload(boolean removeFromList)
	{
		cancelAllQuestTimers();
		onAdvEvent("CLEAR_ZONE", null, null);
	//	if (_antharas != null)
	//	{
	//		_antharas.deleteMe();
	//		_antharas = null;
	//	}
		return super.unload(removeFromList);
	}
	
	private int getStatus()
	{
		return GrandBossManager.getInstance().getBossStatus(ANTHARAS);
	}
	
	private void addBoss(L2GrandBossInstance grandboss)
	{
		GrandBossManager.getInstance().addBoss(grandboss);
	}
	
	private void setStatus(int status)
	{
		GrandBossManager.getInstance().setBossStatus(ANTHARAS, status);
	}
	
	private void setRespawn(long respawnTime)
	{
		GrandBossManager.getInstance().getStatsSet(ANTHARAS).set("respawn_time", (System.currentTimeMillis() + respawnTime));
	}
	
	private final void refreshAiParams(L2PcInstance attacker, int damage)
	{
		if ((attacker_1 != null) && (attacker == attacker_1))
		{
			if (attacker_1_hate < (damage + 1000))
			{
				attacker_1_hate = damage + getRandom(3000);
			}
		}
		else if ((attacker_2 != null) && (attacker == attacker_2))
		{
			if (attacker_2_hate < (damage + 1000))
			{
				attacker_2_hate = damage + getRandom(3000);
			}
		}
		else if ((attacker_3 != null) && (attacker == attacker_3))
		{
			if (attacker_3_hate < (damage + 1000))
			{
				attacker_3_hate = damage + getRandom(3000);
			}
		}
		else
		{
			final int i1 = Util.min(attacker_1_hate, attacker_2_hate, attacker_3_hate);
			if (attacker_1_hate == i1)
			{
				attacker_1_hate = damage + getRandom(3000);
				attacker_1 = attacker;
			}
			else if (attacker_2_hate == i1)
			{
				attacker_2_hate = damage + getRandom(3000);
				attacker_2 = attacker;
			}
			else if (attacker_3_hate == i1)
			{
				attacker_3_hate = damage + getRandom(3000);
				attacker_3 = attacker;
			}
		}
	}
	
	private void manageSkills(L2Npc npc)
	{
		if (npc.isCastingNow() || npc.isCoreAIDisabled() || !npc.isInCombat())
		{
			return;
		}
		
		int i1 = 0;
		int i2 = 0;
		L2PcInstance c2 = null;
		if ((attacker_1 == null) || (npc.calculateDistance(attacker_1, true, false) > 9000) || attacker_1.isDead())
		{
			attacker_1_hate = 0;
		}
		
		if ((attacker_2 == null) || (npc.calculateDistance(attacker_2, true, false) > 9000) || attacker_2.isDead())
		{
			attacker_2_hate = 0;
		}
		
		if ((attacker_3 == null) || (npc.calculateDistance(attacker_3, true, false) > 9000) || attacker_3.isDead())
		{
			attacker_3_hate = 0;
		}
		
		if (attacker_1_hate > attacker_2_hate)
		{
			i1 = 2;
			i2 = attacker_1_hate;
			c2 = attacker_1;
		}
		else if (attacker_2_hate > 0)
		{
			i1 = 3;
			i2 = attacker_2_hate;
			c2 = attacker_2;
		}
		
		if (attacker_3_hate > i2)
		{
			i1 = 4;
			i2 = attacker_3_hate;
			c2 = attacker_3;
		}
		if (i2 > 0)
		{
			if (getRandom(100) < 70)
			{
				switch (i1)
				{
					case 2:
					{
						attacker_1_hate = 500;
						break;
					}
					case 3:
					{
						attacker_2_hate = 500;
						break;
					}
					case 4:
					{
						attacker_3_hate = 500;
						break;
					}
				}
			}
			
			final double distance_c2 = npc.calculateDistance(c2, true, false);
			final double direction_c2 = npc.calculateDirectionTo(c2);
			
			int skillToCast = 0;
			final double hpRatio = npc.getCurrentHp() / npc.getMaxHp();
			if (hpRatio < 0.25)
			{
				if (getRandom(100) < 30)
				{
					npc.setTarget(c2);
					skillToCast = ANTH_MOUTH;
				}
				else if ((getRandom(100) < 80) && (((distance_c2 < 1423) && (direction_c2 < 188) && (direction_c2 > 172)) || ((distance_c2 < 802) && (direction_c2 < 194) && (direction_c2 > 166))))
				{
					skillToCast = ANTH_TAIL;
				}
				else if ((getRandom(100) < 40) && (((distance_c2 < 850) && (direction_c2 < 210) && (direction_c2 > 150)) || ((distance_c2 < 425) && (direction_c2 < 270) && (direction_c2 > 90))))
				{
					skillToCast = ANTH_DEBUFF;
				}
				else if ((getRandom(100) < 10) && (distance_c2 < 1100))
				{
					skillToCast = ANTH_JUMP;
				}
				else if (getRandom(100) < 10)
				{
					npc.setTarget(c2);
					skillToCast = ANTH_METEOR;
				}
				else if (getRandom(100) < 6)
				{
					npc.setTarget(c2);
					skillToCast = ANTH_BREATH;
				}
				else if (getRandomBoolean())
				{
					npc.setTarget(c2);
					skillToCast = ANTH_NORM_ATTACK_EX;
				}
				else if (getRandom(100) < 5)
				{
					npc.setTarget(c2);
					skillToCast = getRandomBoolean() ? ANTH_FEAR : ANTH_FEAR_SHORT;
				}
				else
				{
					npc.setTarget(c2);
					skillToCast = ANTH_NORM_ATTACK;
				}
			}
			else if (hpRatio < 0.5)
			{
				if ((getRandom(100) < 80) && (((distance_c2 < 1423) && (direction_c2 < 188) && (direction_c2 > 172)) || ((distance_c2 < 802) && (direction_c2 < 194) && (direction_c2 > 166))))
				{
					skillToCast = ANTH_TAIL;
				}
				else if ((getRandom(100) < 40) && (((distance_c2 < 850) && (direction_c2 < 210) && (direction_c2 > 150)) || ((distance_c2 < 425) && (direction_c2 < 270) && (direction_c2 > 90))))
				{
					skillToCast = ANTH_DEBUFF;
				}
				else if ((getRandom(100) < 10) && (distance_c2 < 1100))
				{
					skillToCast = ANTH_JUMP;
				}
				else if (getRandom(100) < 7)
				{
					npc.setTarget(c2);
					skillToCast = ANTH_METEOR;
				}
				else if (getRandom(100) < 6)
				{
					npc.setTarget(c2);
					skillToCast = ANTH_BREATH;
				}
				else if (getRandomBoolean())
				{
					npc.setTarget(c2);
					skillToCast = ANTH_NORM_ATTACK_EX;
				}
				else if (getRandom(100) < 5)
				{
					npc.setTarget(c2);
					skillToCast = getRandomBoolean() ? ANTH_FEAR : ANTH_FEAR_SHORT;
				}
				else
				{
					npc.setTarget(c2);
					skillToCast = ANTH_NORM_ATTACK;
				}
			}
			else if (hpRatio < 0.75)
			{
				if ((getRandom(100) < 80) && (((distance_c2 < 1423) && (direction_c2 < 188) && (direction_c2 > 172)) || ((distance_c2 < 802) && (direction_c2 < 194) && (direction_c2 > 166))))
				{
					skillToCast = ANTH_TAIL;
				}
				else if ((getRandom(100) < 10) && (distance_c2 < 1100))
				{
					skillToCast = ANTH_JUMP;
				}
				else if (getRandom(100) < 5)
				{
					npc.setTarget(c2);
					skillToCast = ANTH_METEOR;
				}
				else if (getRandom(100) < 6)
				{
					npc.setTarget(c2);
					skillToCast = ANTH_BREATH;
				}
				else if (getRandomBoolean())
				{
					npc.setTarget(c2);
					skillToCast = ANTH_NORM_ATTACK_EX;
				}
				else if (getRandom(100) < 5)
				{
					npc.setTarget(c2);
					skillToCast = getRandomBoolean() ? ANTH_FEAR : ANTH_FEAR_SHORT;
				}
				else
				{
					npc.setTarget(c2);
					skillToCast = ANTH_NORM_ATTACK;
				}
			}
			else
			{
				if ((getRandom(100) < 80) && (((distance_c2 < 1423) && (direction_c2 < 188) && (direction_c2 > 172)) || ((distance_c2 < 802) && (direction_c2 < 194) && (direction_c2 > 166))))
				{
					skillToCast = ANTH_TAIL;
				}
				else if (getRandom(100) < 3)
				{
					npc.setTarget(c2);
					skillToCast = ANTH_METEOR;
				}
				else if (getRandom(100) < 6)
				{
					npc.setTarget(c2);
					skillToCast = ANTH_BREATH;
				}
				else if (getRandomBoolean())
				{
					npc.setTarget(c2);
					skillToCast = ANTH_NORM_ATTACK_EX;
				}
				else if (getRandom(100) < 5)
				{
					npc.setTarget(c2);
					skillToCast = getRandomBoolean() ? ANTH_FEAR : ANTH_FEAR_SHORT;
				}
				else
				{
					npc.setTarget(c2);
					skillToCast = ANTH_NORM_ATTACK;
				}
			}
			
			if (skillToCast != 0 && npc.checkDoCastConditions(getSkill(skillToCast)))
			{
				npc.doCast(getSkill(skillToCast));
			}
		}
	}
	
	private boolean isFighting(L2Npc npc)
	{
		return npc.isVisible() && !npc.isDead();
	}
	
	public static void main(String[] args)
	{
		new Antharas();
	}
}