package ai.npc.NpcBuffers.impl;

import java.util.Collections;
import java.util.Map;

import com.l2jserver.gameserver.model.CharEffectList;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;

//@formatter:off
/**
 * @author JOJO
 */
class NpcBuffUtil
{
	static void handleEffect(L2PcInstance player, L2Skill skill)
	{
		if (! doesStack(player, skill))
		{
			skill.applyEffects(player, player);
		}
	}
	
	static void handleBuff(L2Npc npc, L2PcInstance player, L2Skill skill)
	{
		if (! doesStack(player, skill))
		{
			skill.applyEffects(npc, player);
			player.sendPacket(new MagicSkillUse(npc, player, skill.getId(), skill.getLevel(), skill.getHitTime(), 0));
		}
	}
	
	static boolean doesStack(L2PcInstance player, L2Skill checkSkill)
	{
		AbnormalType type = checkSkill.getAbnormalType();
		for (BuffInfo e : getEffectList(player, checkSkill).values())
			if (e != null && e.getSkill().getAbnormalType() == type)
				return true;
		return false;
	}
	
	static Map<Integer, BuffInfo> getEffectList(L2PcInstance player, L2Skill skill)
	{
		final CharEffectList e = player.getEffectList();
		return skill == null        ? Collections.<Integer, BuffInfo> emptyMap()
		 : skill.isPassive()        ? e.getPassives()
		 : skill.isDebuff()         ? e.getDebuffs()
		 : skill.isTriggeredSkill() ? e.getTriggered()
		 : skill.isDance()          ? e.getDances()
		 : skill.isToggle()         ? e.getToggles()
		 :                            e.getBuffs();
	}

}
