/*
 * Copyright (C) 2005-2008 L2J_JP / 2008-2013 L2J-SFJP
 * 
 * This file is part of L2J Server.
 * 
 * L2J Server is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J Server is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package cron;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.OfflineTradersTable;

/**
 * @author UnAfraid  http://www.l2jserver.com/forum/viewtopic.php?f=73&t=25681
 */
public class OfflineShops
{
	private static final Logger _log = Logger.getLogger(OfflineShops.class.getName());
	
	public static void main(String[] args)
	{
		if (Config.OFFLINE_TRADE_ENABLE || Config.OFFLINE_CRAFT_ENABLE)
		{
			OfflineTradersTable.getInstance().storeOffliners();
			_log.log(Level.INFO, OfflineShops.class.getSimpleName() + " has been stored in db.");
		}
	}
}