/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package quests.Q00633_InTheForgottenVillage;


import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.holders.ItemChanceHolder;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;

/**
 * In The Forgotten Village (633)
 * @author netvirus
 */
public final class Q00633_InTheForgottenVillage extends Quest
{
	// NPC
	private static final int MINA = 31388;
	// Items
	private static final int RIB_BONE_OF_A_BLACK_MAGUS = 7544;
	private static final int ZOMBIES_LIVER = 7545;
	// Misc
	private static final int MIN_LVL = 65;
	private static final int RIB_BONE_REQUIRED_COUNT = 200;
	// Mobs
	private static final 	SortedIntObjectArrayMap<ItemChanceHolder> MOBS_DROP_CHANCES = new SortedIntObjectArrayMap<ItemChanceHolder>()
		.append(21553, new ItemChanceHolder(ZOMBIES_LIVER, 0.417)) // Trampled Man
		.append(21554, new ItemChanceHolder(ZOMBIES_LIVER, 0.417)) // Trampled Man
		.append(21557, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.394)) // Bone Snatcher
		.append(21558, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.394)) // Bone Snatcher
		.append(21559, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.436)) // Bone Maker
		.append(21560, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.430)) // Bone Shaper
		.append(21561, new ItemChanceHolder(ZOMBIES_LIVER, 0.538)) // Sacrificed Man
		.append(21563, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.436)) // Bone Collector
		.append(21564, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.414)) // Skull Collector
		.append(21565, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.420)) // Bone Animator
		.append(21566, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.460)) // Skull Animator
		.append(21567, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.549)) // Bone Slayer
		.append(21570, new ItemChanceHolder(ZOMBIES_LIVER, 0.508)) // Ghost of Betrayer
		.append(21572, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.465)) // Bone Sweeper
		.append(21574, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.586)) // Bone Grinder
		.append(21575, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.329)) // Bone Grinder
		.append(21578, new ItemChanceHolder(ZOMBIES_LIVER, 0.649)) // Behemoth Zombie
		.append(21580, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.462)) // Bone Caster
		.append(21581, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.505)) // Bone Puppeteer
		.append(21583, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.475)) // Bone Scavenger
		.append(21584, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.475)) // Bone Scavenger
		.append(21596, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.543)) // Requiem Lord
		.append(21597, new ItemChanceHolder(ZOMBIES_LIVER, 0.510)) // Requiem Behemoth
		.append(21598, new ItemChanceHolder(ZOMBIES_LIVER, 0.572)) // Requiem Behemoth
		.append(21599, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.580)) // Requiem Priest
		.append(21600, new ItemChanceHolder(ZOMBIES_LIVER, 0.561)) // Requiem Behemoth
		.append(21601, new ItemChanceHolder(RIB_BONE_OF_A_BLACK_MAGUS, 0.677)) // Requiem Behemoth
	;
	
	private Q00633_InTheForgottenVillage()
	{
		super(633, Q00633_InTheForgottenVillage.class.getSimpleName(), "Yꂽ");
		addStartNpc(MINA);
		addTalkId(MINA);
		addKillId(MOBS_DROP_CHANCES.keySet());
		registerQuestItems(RIB_BONE_OF_A_BLACK_MAGUS, ZOMBIES_LIVER);
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		final QuestState qs = getQuestState(player, false);
		String htmltext = null;
		if (qs == null)
		{
			return htmltext;
		}
		
		switch (event)
		{
			case "31388-03.htm":
			{
				if (qs.isCreated())
				{
					qs.startQuest();
					htmltext = event;
				}
				break;
			}
			case "31388-04.html":
			case "31388-05.html":
			case "31388-06.html":
			{
				if (qs.isStarted())
				{
					htmltext = event;
				}
				break;
			}
			case "31388-07.html":
			{
				if (qs.isCond(2))
				{
					if (getQuestItemsCount(player, RIB_BONE_OF_A_BLACK_MAGUS) >= RIB_BONE_REQUIRED_COUNT)
					{
						giveAdena(player, 25000, true);
						addExpAndSp(player, 305235, 0);
						takeItems(player, RIB_BONE_OF_A_BLACK_MAGUS, -1);
						qs.setCond(1, true);
						htmltext = event;
					}
					else
					{
						htmltext = "31388-08.html";
					}
				}
				break;
			}
			case "31388-09.html":
			{
				if (qs.isStarted())
				{
					qs.exitQuest(true, true);
					htmltext = event;
				}
				break;
			}
		}
		return htmltext;
	}
	
	@Override
	public String onKill(L2Npc npc, L2PcInstance killer, boolean isSummon)
	{
		final QuestState qs = getRandomPartyMemberState(killer, -1, 3, npc);
		if (qs != null)
		{
			final ItemChanceHolder info = MOBS_DROP_CHANCES.get(npc.getId());
			switch (info.getId())
			{
				case RIB_BONE_OF_A_BLACK_MAGUS:
				{
					if (qs.isCond(1) && giveItemRandomly(qs.getPlayer(), npc, RIB_BONE_OF_A_BLACK_MAGUS, 1, RIB_BONE_REQUIRED_COUNT, info.getChance(), true))
					{
						qs.setCond(2);
					}
					break;
				}
				case ZOMBIES_LIVER:
				{
					giveItemRandomly(qs.getPlayer(), npc, ZOMBIES_LIVER, 1, 0, info.getChance(), true);
					break;
				}
			}
		}
		return super.onKill(npc, killer, isSummon);
	}
	
	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		final QuestState qs = getQuestState(player, true);
		String htmltext = getNoQuestMsg(player);
		if (qs == null)
		{
			return htmltext;
		}
		
		if (qs.isCreated())
		{
			htmltext = ((player.getLevel() >= MIN_LVL) ? "31388-01.htm" : "31388-02.htm");
		}
		else if (qs.isStarted())
		{
			htmltext = ((getQuestItemsCount(player, RIB_BONE_OF_A_BLACK_MAGUS) >= RIB_BONE_REQUIRED_COUNT) ? "31388-04.html" : "31388-05.html");
		}
		return htmltext;
	}
	
	public static void main(String[] args)
	{
		new Q00633_InTheForgottenVillage();
	}
}
