/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.communitybbs;

import com.l2jserver.Config;
import com.l2jserver.gameserver.communitybbs.Manager.ClanBBSManager;
import com.l2jserver.gameserver.communitybbs.Manager.CustomBBSManager;
import com.l2jserver.gameserver.communitybbs.Manager.FriendListManager;
import com.l2jserver.gameserver.communitybbs.Manager.PostBBSManager;
import com.l2jserver.gameserver.communitybbs.Manager.RegionBBSManager;
import com.l2jserver.gameserver.communitybbs.Manager.TopBBSManager;
import com.l2jserver.gameserver.communitybbs.Manager.TopicBBSManager;
import com.l2jserver.gameserver.communitybbs.Manager.favorite.FavoriteManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ShowBoard;

public class CommunityBoard {
    public static CommunityBoard getInstance() {
        return SingletonHolder._instance;
    }

    public void handleCommands(L2GameClient client, String command) {
        L2PcInstance activeChar = client.getActiveChar();
        if (activeChar == null) {
            return;
        }
        switch (Config.COMMUNITY_TYPE) {
            default: {
                activeChar.sendPacket(SystemMessageId.CB_OFFLINE);
                break;
            }
            case 1: {
                RegionBBSManager.getInstance().parsecmd(command, activeChar);
                break;
            }
            case 2: {
                if (command.startsWith("_friendlist")) {
                    FriendListManager.getInstance().parsecmd(command, activeChar);
                    break;
                }
                if (Config.CUSTOM_COMMUNITY_BOARD && (command.startsWith("_bbscustom") || command.startsWith("_maillist") || command.startsWith("_bbsmemo"))) {
                    CustomBBSManager.getInstance().parsecmd(command, activeChar);
                    break;
                }
                if (command.startsWith("_bbsgetfav")) {
                    FavoriteManager.getInstance().parsecmd(command, activeChar);
                    break;
                }
                if (command.startsWith("bbs_add_fav")) {
                    ShowBoard sb = new ShowBoard("<html><body><br><br><center>\u6e96\u5099\u4e2d\uff08&$379;\uff09</center></body></html>", "101");
                    activeChar.sendPacket(sb);
                    activeChar.sendPacket(new ShowBoard(null, "102"));
                    activeChar.sendPacket(new ShowBoard(null, "103"));
                    break;
                }
                if (command.startsWith("_bbsclan")) {
                    ClanBBSManager.getInstance().parsecmd(command, activeChar);
                    break;
                }
                if (command.startsWith("_bbsmemo")) {
                    TopicBBSManager.getInstance().parsecmd(command, activeChar);
                    break;
                }
                if (command.startsWith("_bbstopics")) {
                    TopicBBSManager.getInstance().parsecmd(command, activeChar);
                    break;
                }
                if (command.startsWith("_bbsposts")) {
                    PostBBSManager.getInstance().parsecmd(command, activeChar);
                    break;
                }
                if (command.startsWith("_bbstop")) {
                    TopBBSManager.getInstance().parsecmd(command, activeChar);
                    break;
                }
                if (command.startsWith("_bbshome")) {
                    TopBBSManager.getInstance().parsecmd(command, activeChar);
                    break;
                }
                if (command.startsWith("_bbsloc")) {
                    RegionBBSManager.getInstance().parsecmd(command, activeChar);
                    break;
                }
                ShowBoard sb = new ShowBoard("<html><body><br><br><center>the command: " + command + " is not implemented yet</center><br><br></body></html>", "101");
                activeChar.sendPacket(sb);
                activeChar.sendPacket(new ShowBoard(null, "102"));
                activeChar.sendPacket(new ShowBoard(null, "103"));
            }
        }
    }

    public void handleWriteCommands(L2GameClient client, String url, String arg1, String arg2, String arg3, String arg4, String arg5) {
        L2PcInstance activeChar = client.getActiveChar();
        if (activeChar == null) {
            return;
        }
        switch (Config.COMMUNITY_TYPE) {
            case 2: {
                if (url.equals("Clan")) {
                    ClanBBSManager.getInstance().parsewrite(arg1, arg2, arg3, arg4, arg5, activeChar);
                    break;
                }
                if (url.equals("Custom")) {
                    CustomBBSManager.getInstance().parsewrite(arg1, arg2, arg3, arg4, arg5, activeChar);
                    break;
                }
                if (url.equals("Favorite")) {
                    FavoriteManager.getInstance().parsewrite(arg1, arg2, arg3, arg4, arg5, activeChar);
                    break;
                }
                if (url.equals("Topic")) {
                    TopicBBSManager.getInstance().parsewrite(arg1, arg2, arg3, arg4, arg5, activeChar);
                    break;
                }
                if (url.equals("Post")) {
                    PostBBSManager.getInstance().parsewrite(arg1, arg2, arg3, arg4, arg5, activeChar);
                    break;
                }
                if (url.equals("Region")) {
                    RegionBBSManager.getInstance().parsewrite(arg1, arg2, arg3, arg4, arg5, activeChar);
                    break;
                }
                if (url.equals("Notice")) {
                    ClanBBSManager.getInstance().parsewrite(arg1, arg2, arg3, arg4, arg5, activeChar);
                    break;
                }
                ShowBoard sb = new ShowBoard("<html><body><br><br><center>the command: " + url + " is not implemented yet</center><br><br></body></html>", "101");
                activeChar.sendPacket(sb);
                activeChar.sendPacket(new ShowBoard(null, "102"));
                activeChar.sendPacket(new ShowBoard(null, "103"));
                break;
            }
            case 1: {
                RegionBBSManager.getInstance().parsewrite(arg1, arg2, arg3, arg4, arg5, activeChar);
                break;
            }
            default: {
                ShowBoard sb = new ShowBoard("<html><body><br><br><center>The Community board is currently disabled</center><br><br></body></html>", "101");
                activeChar.sendPacket(sb);
                activeChar.sendPacket(new ShowBoard(null, "102"));
                activeChar.sendPacket(new ShowBoard(null, "103"));
            }
        }
    }

    private static class SingletonHolder {
        protected static final CommunityBoard _instance = new CommunityBoard();

        private SingletonHolder() {
        }
    }
}

