/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.model.L2PetData;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2ServitorInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.serverpackets.PetItemList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import jp.sf.l2j.troja.FastIntObjectMap;

public class CharSummonTable {
    private static final Logger _log = Logger.getLogger(CharSummonTable.class.getName());
    private static final FastIntObjectMap<Integer> _pets = new FastIntObjectMap().shared();
    private static final FastIntObjectMap<Integer> _servitors = new FastIntObjectMap().shared();
    private static final String INIT_PET = "SELECT ownerId, item_obj_id FROM pets WHERE restore = 'true'";
    private static final String INIT_SUMMONS = "SELECT ownerId, summonSkillId FROM character_summons";
    private static final String LOAD_SUMMON = "SELECT curHp, curMp, time FROM character_summons WHERE ownerId = ? AND summonSkillId = ?";
    private static final String REMOVE_SUMMON = "DELETE FROM character_summons WHERE ownerId = ?";
    private static final String SAVE_SUMMON = "REPLACE INTO character_summons (ownerId,summonSkillId,curHp,curMp,time) VALUES (?,?,?,?,?)";

    public FastIntObjectMap<Integer> getPets() {
        return _pets;
    }

    public FastIntObjectMap<Integer> getServitors() {
        return _servitors;
    }

    public void init() {
        Throwable throwable;
        ResultSet rs;
        Throwable throwable2;
        Statement s;
        Throwable throwable3;
        Connection con;
        if (Config.RESTORE_SERVITOR_ON_RECONNECT) {
            try {
                con = L2DatabaseFactory.getInstance().getConnectionFast();
                throwable3 = null;
                try {
                    s = con.createStatement();
                    throwable2 = null;
                    try {
                        rs = s.executeQuery(INIT_SUMMONS);
                        throwable = null;
                        try {
                            while (rs.next()) {
                                _servitors.put(rs.getInt("ownerId"), (Object)rs.getInt("summonSkillId"));
                            }
                        }
                        catch (Throwable x2) {
                            throwable = x2;
                            throw x2;
                        }
                        finally {
                            if (rs != null) {
                                if (throwable != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                        }
                    }
                    catch (Throwable x2) {
                        throwable2 = x2;
                        throw x2;
                    }
                    finally {
                        if (s != null) {
                            if (throwable2 != null) {
                                try {
                                    s.close();
                                }
                                catch (Throwable x2) {
                                    throwable2.addSuppressed(x2);
                                }
                            } else {
                                s.close();
                            }
                        }
                    }
                }
                catch (Throwable x2) {
                    throwable3 = x2;
                    throw x2;
                }
                finally {
                    if (con != null) {
                        if (throwable3 != null) {
                            try {
                                con.close();
                            }
                            catch (Throwable x2) {
                                throwable3.addSuppressed(x2);
                            }
                        } else {
                            con.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                _log.warning(this.getClass().getSimpleName() + ": Error while loading saved servitor: " + e);
            }
        }
        if (Config.RESTORE_PET_ON_RECONNECT) {
            try {
                con = L2DatabaseFactory.getInstance().getConnectionFast();
                throwable3 = null;
                try {
                    s = con.createStatement();
                    throwable2 = null;
                    try {
                        rs = s.executeQuery(INIT_PET);
                        throwable = null;
                        try {
                            while (rs.next()) {
                                _pets.put(rs.getInt("ownerId"), (Object)rs.getInt("item_obj_id"));
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (rs != null) {
                                if (throwable != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (s != null) {
                            if (throwable2 != null) {
                                try {
                                    s.close();
                                }
                                catch (Throwable x2) {
                                    throwable2.addSuppressed(x2);
                                }
                            } else {
                                s.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable6) {
                    throwable3 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (con != null) {
                        if (throwable3 != null) {
                            try {
                                con.close();
                            }
                            catch (Throwable x2) {
                                throwable3.addSuppressed(x2);
                            }
                        } else {
                            con.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                _log.warning(this.getClass().getSimpleName() + ": Error while loading saved pet: " + e);
            }
        }
    }

    public void removeServitor(L2PcInstance activeChar) {
        _servitors.remove(activeChar.getObjectId());
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement(REMOVE_SUMMON);){
            ps.setInt(1, activeChar.getObjectId());
            ps.execute();
        }
        catch (SQLException e) {
            _log.warning(this.getClass().getSimpleName() + ": Summon cannot be removed: " + e);
        }
    }

    public void restorePet(L2PcInstance activeChar) {
        L2ItemInstance item = activeChar.getInventory().getItemByObjectId((Integer)_pets.get(activeChar.getObjectId()));
        if (item == null) {
            _log.warning(this.getClass().getSimpleName() + ": Null pet summoning item for: " + activeChar);
            return;
        }
        L2PetData petData = PetDataTable.getInstance().getPetDataByItemId(item.getId());
        if (petData == null) {
            _log.warning(this.getClass().getSimpleName() + ": Null pet data for: " + activeChar + " and summoning item: " + item);
            return;
        }
        L2NpcTemplate npcTemplate = NpcData.getInstance().getTemplate(petData.getNpcId());
        if (npcTemplate == null) {
            _log.warning(this.getClass().getSimpleName() + ": Null pet NPC template for: " + activeChar + " and pet Id:" + petData.getNpcId());
            return;
        }
        L2PetInstance pet = L2PetInstance.spawnPet(npcTemplate, activeChar, item);
        if (pet == null) {
            _log.warning(this.getClass().getSimpleName() + ": Null pet instance for: " + activeChar + " and pet NPC template:" + npcTemplate);
            return;
        }
        pet.setShowSummonAnimation(true);
        pet.setTitle(activeChar.getName());
        if (!pet.isRespawned()) {
            pet.setCurrentHp(pet.getMaxHp());
            pet.setCurrentMp(pet.getMaxMp());
            pet.getStat().setExp(pet.getExpForThisLevel());
            pet.setCurrentFed(pet.getMaxFed());
        }
        pet.setRunning();
        if (!pet.isRespawned()) {
            pet.storeMe();
        }
        activeChar.setPet(pet);
        pet.spawnMe(activeChar.getX() + 50, activeChar.getY() + 100, activeChar.getZ());
        pet.startFeed();
        item.setEnchantLevel(pet.getLevel());
        if (pet.getCurrentFed() <= 0) {
            pet.unSummon(activeChar);
        } else {
            pet.startFeed();
        }
        pet.setFollowStatus(true);
        pet.getOwner().sendPacket(new PetItemList(pet.getInventory().getItems()));
        pet.broadcastStatusUpdate();
    }

    public void restoreServitor(L2PcInstance activeChar) {
        int skillId = (Integer)_servitors.get(activeChar.getObjectId());
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement(LOAD_SUMMON);){
            ps.setInt(1, activeChar.getObjectId());
            ps.setInt(2, skillId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int curHp = rs.getInt("curHp");
                    int curMp = rs.getInt("curMp");
                    int time = rs.getInt("time");
                    Skill skill = SkillData.getInstance().getSkill(skillId, activeChar.getSkillLevel(skillId));
                    if (skill == null) {
                        this.removeServitor(activeChar);
                        return;
                    }
                    skill.applyEffects(activeChar, activeChar);
                    if (!activeChar.hasServitor()) continue;
                    L2ServitorInstance summon = (L2ServitorInstance)activeChar.getSummon();
                    summon.setCurrentHp(curHp);
                    summon.setCurrentMp(curMp);
                    summon.setLifeTimeRemaining(time);
                }
            }
        }
        catch (SQLException e) {
            _log.warning(this.getClass().getSimpleName() + ": Servitor cannot be restored: " + e);
        }
    }

    public void saveSummon(L2ServitorInstance summon) {
        if (summon == null || summon.getLifeTimeRemaining() <= 0) {
            return;
        }
        _servitors.put(summon.getOwner().getObjectId(), (Object)summon.getReferenceSkill());
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement(SAVE_SUMMON);){
            ps.setInt(1, summon.getOwner().getObjectId());
            ps.setInt(2, summon.getReferenceSkill());
            ps.setInt(3, (int)Math.round(summon.getCurrentHp()));
            ps.setInt(4, (int)Math.round(summon.getCurrentMp()));
            ps.setInt(5, summon.getLifeTimeRemaining());
            ps.execute();
        }
        catch (Exception e) {
            _log.warning(this.getClass().getSimpleName() + ": Failed to store summon: " + summon + " from " + summon.getOwner() + ", error: " + e);
        }
    }

    public static CharSummonTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final CharSummonTable _instance = new CharSummonTable();

        private SingletonHolder() {
        }
    }
}

