/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Crest;
import com.l2jserver.gameserver.util.FastIntSet;
import com.l2jserver.util.file.filter.BMPFilter;
import java.io.File;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.l2j.troja.FastIntObjectMap;

public final class CrestTable {
    private static final Logger _log = Logger.getLogger(CrestTable.class.getName());
    private final FastIntObjectMap<L2Crest> _crests = new FastIntObjectMap().shared();
    private final AtomicInteger _nextId = new AtomicInteger(1);

    protected CrestTable() {
        this.load();
    }

    public synchronized void load() {
        this._crests.clear();
        FastIntSet crestsInUse = new FastIntSet();
        for (L2Clan l2Clan : ClanTable.getInstance().getClans()) {
            if (l2Clan.getCrestId() != 0) {
                crestsInUse.add(l2Clan.getCrestId());
            }
            if (l2Clan.getCrestLargeId() != 0) {
                crestsInUse.add(l2Clan.getCrestLargeId());
            }
            if (l2Clan.getAllyCrestId() == 0) continue;
            crestsInUse.add(l2Clan.getAllyCrestId());
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            Throwable throwable = null;
            try (Statement statement = con.createStatement(1003, 1008);
                 ResultSet rs = statement.executeQuery("SELECT `crest_id`, `data`, `type` FROM `crests` ORDER BY `crest_id` DESC");){
                while (rs.next()) {
                    int id = rs.getInt("crest_id");
                    if (this._nextId.get() <= id) {
                        this._nextId.set(id + 1);
                    }
                    if (!crestsInUse.contains(id) && id != this._nextId.get() - 1) {
                        rs.deleteRow();
                        continue;
                    }
                    byte[] data = rs.getBytes("data");
                    L2Crest.CrestType crestType = L2Crest.CrestType.getById(rs.getInt("type"));
                    if (crestType != null) {
                        this._crests.put(id, (Object)new L2Crest(id, data, crestType));
                        continue;
                    }
                    _log.warning("Unknown crest type found in database. Type:" + rs.getInt("type"));
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "There was an error while loading crests from database:", e);
        }
        this.moveOldCrestsToDb(crestsInUse);
        _log.info(this.getClass().getSimpleName() + ": Loaded " + this._crests.size() + " Crests.");
        for (L2Clan l2Clan : ClanTable.getInstance().getClans()) {
            if (l2Clan.getCrestId() != 0 && this.getCrest(l2Clan.getCrestId()) == null) {
                _log.info("Removing non-existent crest for clan " + l2Clan.getName() + " [" + l2Clan.getId() + "], crestId:" + l2Clan.getCrestId());
                l2Clan.setCrestId(0);
                l2Clan.changeClanCrest(0);
            }
            if (l2Clan.getCrestLargeId() != 0 && this.getCrest(l2Clan.getCrestLargeId()) == null) {
                _log.info("Removing non-existent large crest for clan " + l2Clan.getName() + " [" + l2Clan.getId() + "], crestLargeId:" + l2Clan.getCrestLargeId());
                l2Clan.setCrestLargeId(0);
                l2Clan.changeLargeCrest(0);
            }
            if (l2Clan.getAllyCrestId() == 0 || this.getCrest(l2Clan.getAllyCrestId()) != null) continue;
            _log.info("Removing non-existent ally crest for clan " + l2Clan.getName() + " [" + l2Clan.getId() + "], allyCrestId:" + l2Clan.getAllyCrestId());
            l2Clan.setAllyCrestId(0);
            l2Clan.changeAllyCrest(0, true);
        }
    }

    private void moveOldCrestsToDb(FastIntSet crestsInUse) {
        File crestDir = new File(Config.DATAPACK_ROOT, "data/crests/");
        if (crestDir.exists()) {
            for (File file : crestDir.listFiles(new BMPFilter())) {
                try {
                    L2Crest crest;
                    int crestId;
                    byte[] data = Files.readAllBytes(file.toPath());
                    if (file.getName().startsWith("Crest_Large_")) {
                        crestId = Integer.parseInt(file.getName().substring(12, file.getName().length() - 4));
                        if (crestsInUse.contains(crestId) && (crest = this.createCrest(data, L2Crest.CrestType.PLEDGE_LARGE)) != null) {
                            for (L2Clan clan : ClanTable.getInstance().getClans()) {
                                if (clan.getCrestLargeId() != crestId) continue;
                                clan.setCrestLargeId(0);
                                clan.changeLargeCrest(crest.getId());
                            }
                        }
                    } else if (file.getName().startsWith("Crest_")) {
                        crestId = Integer.parseInt(file.getName().substring(6, file.getName().length() - 4));
                        if (crestsInUse.contains(crestId) && (crest = this.createCrest(data, L2Crest.CrestType.PLEDGE)) != null) {
                            for (L2Clan clan : ClanTable.getInstance().getClans()) {
                                if (clan.getCrestId() != crestId) continue;
                                clan.setCrestId(0);
                                clan.changeClanCrest(crest.getId());
                            }
                        }
                    } else if (file.getName().startsWith("AllyCrest_") && crestsInUse.contains(crestId = Integer.parseInt(file.getName().substring(10, file.getName().length() - 4))) && (crest = this.createCrest(data, L2Crest.CrestType.ALLY)) != null) {
                        for (L2Clan clan : ClanTable.getInstance().getClans()) {
                            if (clan.getAllyCrestId() != crestId) continue;
                            clan.setAllyCrestId(0);
                            clan.changeAllyCrest(crest.getId(), false);
                        }
                    }
                    file.delete();
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "There was an error while moving crest file " + file.getName() + " to database:", e);
                }
            }
            crestDir.delete();
        }
    }

    public L2Crest getCrest(int crestId) {
        return (L2Crest)this._crests.get(crestId);
    }

    /*
     * Exception decompiling
     */
    public L2Crest createCrest(byte[] data, L2Crest.CrestType crestType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void removeCrest(int crestId) {
        this._crests.remove(crestId);
        if (crestId == this._nextId.get() - 1) {
            return;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("DELETE FROM `crests` WHERE `crest_id` = ?");){
            statement.setInt(1, crestId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "There was an error while deleting crest from database:", e);
        }
    }

    public int getNextId() {
        return this._nextId.getAndIncrement();
    }

    public static CrestTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final CrestTable _instance = new CrestTable();

        private SingletonHolder() {
        }
    }
}

